/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.addons;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.api.common.capability.IEntitySkinCapability;
import moe.plushie.armourers_workshop.api.common.capability.IWardrobeCap;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDescriptor;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDye;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.client.render.SkinModelRenderHelper;
import moe.plushie.armourers_workshop.client.render.SkinRenderData;
import moe.plushie.armourers_workshop.client.render.entity.SkinLayerRendererHeldItem;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.common.addons.ModAddon;
import moe.plushie.armourers_workshop.common.capability.entityskin.EntitySkinCapability;
import moe.plushie.armourers_workshop.common.capability.wardrobe.ExtraColours;
import moe.plushie.armourers_workshop.common.capability.wardrobe.WardrobeCap;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDye;
import moe.plushie.armourers_workshop.common.skin.entity.SkinnableEntity;
import moe.plushie.armourers_workshop.common.skin.entity.SkinnableEntityRegisty;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class AddonCustomNPCS
extends ModAddon {
    private static final String CLASS_NAME_ENTITY_CNPC = "noppes.npcs.entity.EntityCustomNpc";
    private static final String CLASS_NAME_NPC_API = "noppes.npcs.api.NpcAPI";
    private static Object npcAPI = null;

    public AddonCustomNPCS() {
        super("customnpcs", "CustomNPC");
    }

    @Override
    public void init() {
        if (this.isModLoaded()) {
            SkinnableEntityRegisty.INSTANCE.registerEntity(new SkinnableEntityCustomNPC());
        }
    }

    @Override
    public void postInit() {
        if (this.setIsModLoaded()) {
            npcAPI = AddonCustomNPCS.getApi();
        }
    }

    private static Object getApi() {
        try {
            Class<?> c = Class.forName(CLASS_NAME_NPC_API);
            Method m = ReflectionHelper.findMethod(c, (String)"Instance", null, (Class[])new Class[0]);
            return m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getiEntity(Entity entity) {
        if (npcAPI != null) {
            try {
                Method m = ReflectionHelper.findMethod(npcAPI.getClass(), (String)"getIEntity", null, (Class[])new Class[]{Entity.class});
                return m.invoke(npcAPI, entity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Object getDisplay(Object iEntity) {
        if (npcAPI != null) {
            try {
                Method m = ReflectionHelper.findMethod(iEntity.getClass(), (String)"getDisplay", null, (Class[])new Class[0]);
                return m.invoke(iEntity, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static float[] getModelScale(Object iDisplay, int part) {
        if (npcAPI != null) {
            try {
                Method m = ReflectionHelper.findMethod(iDisplay.getClass(), (String)"getModelScale", null, (Class[])new Class[]{Integer.TYPE});
                return (float[])m.invoke(iDisplay, part);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static Class<? extends EntityLivingBase> getCNPCEntityClass() {
        try {
            return Class.forName(CLASS_NAME_ENTITY_CNPC);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class SkinLayerRendererCustomNPC
    implements LayerRenderer {
        private final RenderLivingBase renderLivingBase;

        public SkinLayerRendererCustomNPC(RenderLivingBase renderLivingBase) {
            this.renderLivingBase = renderLivingBase;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        public void func_177141_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            IEntitySkinCapability skinCapability = EntitySkinCapability.get((Entity)entitylivingbaseIn);
            if (skinCapability == null) {
                return;
            }
            double distance = Minecraft.func_71410_x().field_71439_g.func_70011_f(entitylivingbaseIn.field_70165_t, entitylivingbaseIn.field_70163_u, entitylivingbaseIn.field_70161_v);
            if (distance > (double)ConfigHandlerClient.renderDistanceSkin) {
                return;
            }
            ISkinType[] skinTypes = skinCapability.getValidSkinTypes();
            SkinModelRenderHelper modelRenderer = SkinModelRenderHelper.INSTANCE;
            IExtraColours extraColours = ExtraColours.EMPTY_COLOUR;
            IWardrobeCap wardrobe = WardrobeCap.get((Entity)entitylivingbaseIn);
            if (wardrobe != null) {
                extraColours = wardrobe.getExtraColours();
            }
            GlStateManager.func_179091_B();
            for (int i = 0; i < skinTypes.length; ++i) {
                ISkinType skinType = skinTypes[i];
                if (!(skinType.getVanillaArmourSlotId() != -1 | skinType == SkinTypeRegistry.skinWings | skinType == SkinTypeRegistry.skinOutfit)) continue;
                for (int skinIndex = 0; skinIndex < skinCapability.getSlotCountForSkinType(skinType); ++skinIndex) {
                    Skin skin;
                    ISkinDescriptor skinDescriptor = skinCapability.getSkinDescriptor(skinType, skinIndex);
                    if (skinDescriptor == null || (skin = ClientSkinCache.INSTANCE.getSkin(skinDescriptor)) == null) continue;
                    SkinDye dye = new SkinDye(wardrobe.getDye());
                    for (int dyeIndex = 0; dyeIndex < 8; ++dyeIndex) {
                        if (!skinDescriptor.getSkinDye().haveDyeInSlot(dyeIndex)) continue;
                        dye.addDye(dyeIndex, skinDescriptor.getSkinDye().getDyeColour(dyeIndex));
                    }
                    ResourceLocation texture = DefaultPlayerSkin.func_177335_a();
                    modelRenderer.renderEquipmentPart(skin, new SkinRenderData(0.0625f, (ISkinDye)dye, extraColours, distance, true, true, false, texture), (Entity)entitylivingbaseIn, (ModelBiped)this.renderLivingBase.func_177087_b());
                }
            }
            GlStateManager.func_179101_C();
        }

        public boolean func_177142_b() {
            return false;
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public void onRenderLivingPre(RenderLivingEvent.Pre<EntityLivingBase> event) {
            if (event.getEntity().getClass() != AddonCustomNPCS.getCNPCEntityClass()) {
                return;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public void onRenderLivingPost(RenderLivingEvent.Post<EntityLivingBase> event) {
            if (event.getEntity().getClass() != AddonCustomNPCS.getCNPCEntityClass()) {
                return;
            }
        }
    }

    public static class SkinnableEntityCustomNPC
    extends SkinnableEntity {
        private boolean addedRender = false;

        public SkinnableEntityCustomNPC() {
            if (!ArmourersWorkshop.isDedicated()) {
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onRenderLiving(RenderLivingEvent.Pre event) {
            if (!this.addedRender && event.getEntity().getClass().isAssignableFrom(this.getEntityClass())) {
                this.addRenderLayer(Minecraft.func_71410_x().func_175598_ae());
                this.addedRender = true;
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addRenderLayer(RenderManager renderManager) {
            block6: {
                Render renderer = renderManager.func_78715_a(this.getEntityClass());
                if (renderer != null && renderer instanceof RenderLivingBase) {
                    SkinLayerRendererCustomNPC layerRendererNPC = new SkinLayerRendererCustomNPC((RenderLivingBase)renderer);
                    if (layerRendererNPC != null) {
                        ((RenderLivingBase)renderer).func_177094_a((LayerRenderer)layerRendererNPC);
                    }
                    try {
                        Object object = ReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)((RenderLivingBase)renderer), (String[])new String[]{"field_177097_h", "layerRenderers"});
                        if (object != null) {
                            List layerRenderers = (List)object;
                            for (int i = 0; i < layerRenderers.size(); ++i) {
                                LayerRenderer layerRenderer = (LayerRenderer)layerRenderers.get(i);
                                if (!layerRenderer.getClass().getName().contains("LayerHeldItem")) continue;
                                ModLogger.log("Removing held item layer from " + renderer);
                                layerRenderers.remove(i);
                                ModLogger.log("Adding skinned held item layer to " + renderer);
                                layerRenderers.add(new SkinLayerRendererHeldItem((RenderLivingBase)renderer, layerRenderer));
                                break block6;
                            }
                            break block6;
                        }
                        ModLogger.log(Level.WARN, "Failed to get 'layerRenderers' on " + renderer);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public Class<? extends EntityLivingBase> getEntityClass() {
            return AddonCustomNPCS.getCNPCEntityClass();
        }

        @Override
        public void getValidSkinTypes(ArrayList<ISkinType> skinTypes) {
            skinTypes.add(SkinTypeRegistry.skinOutfit);
            skinTypes.add(SkinTypeRegistry.skinHead);
            skinTypes.add(SkinTypeRegistry.skinChest);
            skinTypes.add(SkinTypeRegistry.skinLegs);
            skinTypes.add(SkinTypeRegistry.skinFeet);
            skinTypes.add(SkinTypeRegistry.skinWings);
            skinTypes.add(SkinTypeRegistry.skinSword);
            skinTypes.add(SkinTypeRegistry.skinShield);
            skinTypes.add(SkinTypeRegistry.skinBow);
        }

        @Override
        public int getSlotsForSkinType(ISkinType skinType) {
            if (skinType.getVanillaArmourSlotId() != -1 | skinType == SkinTypeRegistry.skinWings) {
                return 10;
            }
            if (skinType == SkinTypeRegistry.skinOutfit) {
                return 10;
            }
            return 1;
        }

        @Override
        public boolean canUseWandOfStyle(EntityPlayer user) {
            return true;
        }
    }
}

