/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.addons;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.common.addons.ModAddonManager;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModAddon {
    private final String modId;
    private final String modName;
    private final boolean isModLoaded;
    private final ArrayList<String> overrrides;
    private boolean itemSkinningSupport;

    public ModAddon(String modId, String modName) {
        this.modId = modId;
        this.modName = modName;
        this.isModLoaded = this.setIsModLoaded();
        if (this.isModLoaded) {
            ModLogger.log(String.format("Loading %s Compatibility Addon", this.getModName()));
        }
        this.overrrides = new ArrayList();
        this.itemSkinningSupport = true;
        if (this.isModLoaded()) {
            ModAddonManager.getLoadedAddons().add(this);
        }
    }

    protected boolean setIsModLoaded() {
        return Loader.isModLoaded((String)this.modId);
    }

    public void preInit() {
    }

    public void init() {
    }

    public void postInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public void initRenderers() {
    }

    public String getModId() {
        return this.modId;
    }

    public String getModName() {
        return this.modName;
    }

    public boolean isModLoaded() {
        return this.isModLoaded;
    }

    public ArrayList<String> getItemOverrides() {
        return this.overrrides;
    }

    protected void addItemOverride(ModAddonManager.ItemOverrideType type, String itemName) {
        this.overrrides.add(type.toString().toLowerCase() + ":" + this.getModId() + ":" + itemName);
    }

    public void setItemSkinningSupport(boolean itemSkinningSupport) {
        this.itemSkinningSupport = itemSkinningSupport;
    }

    public boolean isItemSkinningSupport() {
        return this.itemSkinningSupport;
    }

    public boolean hasItemOverrides() {
        return this.overrrides.size() > 0;
    }
}

