/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.capability.holiday;

import java.util.HashMap;
import java.util.concurrent.Callable;
import moe.plushie.armourers_workshop.common.capability.holiday.IHolidayTrackCap;
import moe.plushie.armourers_workshop.common.holiday.Holiday;
import moe.plushie.armourers_workshop.common.holiday.ModHolidays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class HolidayTrackCap
implements IHolidayTrackCap {
    @CapabilityInject(value=IHolidayTrackCap.class)
    public static final Capability<IHolidayTrackCap> HOLIDAY_TRACK_CAP = null;
    public final HashMap<Holiday, Integer> holidayYears = new HashMap();

    @Override
    public int getLastHolidayYear(Holiday holiday) {
        if (this.holidayYears.containsKey(holiday)) {
            return this.holidayYears.get(holiday);
        }
        return 0;
    }

    @Override
    public void setLastHoloidayYear(Holiday holiday, int year) {
        this.holidayYears.put(holiday, year);
    }

    @Override
    public Holiday[] getHolidays() {
        return this.holidayYears.keySet().toArray(new Holiday[this.holidayYears.size()]);
    }

    @Override
    public void clearList() {
        this.holidayYears.clear();
    }

    public static IHolidayTrackCap get(EntityPlayer player) {
        return (IHolidayTrackCap)player.getCapability(HOLIDAY_TRACK_CAP, null);
    }

    public static class Factory
    implements Callable<IHolidayTrackCap> {
        @Override
        public IHolidayTrackCap call() throws Exception {
            return new HolidayTrackCap();
        }
    }

    public static class Storage
    implements Capability.IStorage<IHolidayTrackCap> {
        private static final String TAG_HOLIDAY_LIST = "holiday-list";

        public NBTBase writeNBT(Capability<IHolidayTrackCap> capability, IHolidayTrackCap instance, EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagList list = new NBTTagList();
            for (Holiday holiday : instance.getHolidays()) {
                list.func_74742_a((NBTBase)new NBTTagString(holiday.getName() + ";" + instance.getLastHolidayYear(holiday)));
            }
            compound.func_74782_a(TAG_HOLIDAY_LIST, (NBTBase)list);
            return compound;
        }

        public void readNBT(Capability<IHolidayTrackCap> capability, IHolidayTrackCap instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            if (compound.func_150297_b(TAG_HOLIDAY_LIST, 9)) {
                NBTTagList list = compound.func_150295_c(TAG_HOLIDAY_LIST, 8);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    String key = list.func_150307_f(i);
                    if (!key.contains(";")) continue;
                    String[] split = key.split(";");
                    Holiday holiday = ModHolidays.getHoliday(split[0]);
                    int year = Integer.parseInt(split[1]);
                    instance.setLastHoloidayYear(holiday, year);
                }
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final IHolidayTrackCap holidayTrackCap = (IHolidayTrackCap)HOLIDAY_TRACK_CAP.getDefaultInstance();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability != null && capability == HOLIDAY_TRACK_CAP;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)HOLIDAY_TRACK_CAP.cast((Object)this.holidayTrackCap);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)HOLIDAY_TRACK_CAP.getStorage().writeNBT(HOLIDAY_TRACK_CAP, (Object)this.holidayTrackCap, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            HOLIDAY_TRACK_CAP.getStorage().readNBT(HOLIDAY_TRACK_CAP, (Object)this.holidayTrackCap, null, (NBTBase)nbt);
        }
    }
}

