/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.capability.wardrobe.player;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.common.capability.IPlayerWardrobeCap;
import moe.plushie.armourers_workshop.api.common.skin.entity.ISkinnableEntity;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.common.capability.wardrobe.WardrobeCap;
import moe.plushie.armourers_workshop.common.config.ConfigHandler;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientUpdatePlayerWardrobeCap;
import moe.plushie.armourers_workshop.common.network.messages.server.MessageServerSyncPlayerWardrobeCap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerWardrobeCap
extends WardrobeCap
implements IPlayerWardrobeCap {
    @CapabilityInject(value=IPlayerWardrobeCap.class)
    public static final Capability<IPlayerWardrobeCap> PLAYER_WARDROBE_CAP = null;
    private BitSet armourOverride = new BitSet(4);
    private HashMap<String, Integer> slotsUnlocked;

    public PlayerWardrobeCap(EntityPlayer entity, ISkinnableEntity skinnableEntity) {
        super((Entity)entity, skinnableEntity);
        ArrayList<ISkinType> validSkinTypes = new ArrayList<ISkinType>();
        skinnableEntity.getValidSkinTypes(validSkinTypes);
        this.slotsUnlocked = new HashMap();
        for (int i = 0; i < validSkinTypes.size(); ++i) {
            ISkinType skinType = validSkinTypes.get(i);
            this.slotsUnlocked.put(skinType.getRegistryName(), this.getUnlockedSlotsForSkinType(skinType));
        }
    }

    @Override
    public boolean getArmourOverride(EntityEquipmentSlot equipmentSlot) {
        if (equipmentSlot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
            return this.armourOverride.get(equipmentSlot.func_188452_c());
        }
        return false;
    }

    @Override
    public void setArmourOverride(EntityEquipmentSlot equipmentSlot, boolean override) {
        if (equipmentSlot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
            this.armourOverride.set(equipmentSlot.func_188452_c(), override);
        }
    }

    @Override
    public int getUnlockedSlotsForSkinType(ISkinType skinType) {
        if (this.slotsUnlocked.containsKey(skinType.getRegistryName())) {
            return this.slotsUnlocked.get(skinType.getRegistryName());
        }
        return Math.min(ConfigHandler.wardrobeStartingSlots, this.getMaxSlotsForSkinType(skinType));
    }

    @Override
    public void setUnlockedSlotsForSkinType(ISkinType skinType, int value) {
        this.slotsUnlocked.put(skinType.getRegistryName(), MathHelper.func_76125_a((int)value, (int)0, (int)this.getMaxSlotsForSkinType(skinType)));
    }

    @Override
    public int getMaxSlotsForSkinType(ISkinType skinType) {
        return this.getSkinnableEntity().getSlotsForSkinType(skinType);
    }

    public static IPlayerWardrobeCap get(EntityPlayer entity) {
        return (IPlayerWardrobeCap)entity.getCapability(PLAYER_WARDROBE_CAP, null);
    }

    @Override
    protected IMessage getUpdateMessage() {
        NBTTagCompound compound = (NBTTagCompound)PLAYER_WARDROBE_CAP.getStorage().writeNBT(PLAYER_WARDROBE_CAP, (Object)this, null);
        return new MessageServerSyncPlayerWardrobeCap(this.entity.func_145782_y(), compound);
    }

    @Override
    public void sendUpdateToServer() {
        NBTTagCompound compound = (NBTTagCompound)PLAYER_WARDROBE_CAP.getStorage().writeNBT(PLAYER_WARDROBE_CAP, (Object)this, null);
        MessageClientUpdatePlayerWardrobeCap message = new MessageClientUpdatePlayerWardrobeCap(compound);
        PacketHandler.networkWrapper.sendToServer((IMessage)message);
    }
}

