/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.capability.wardrobe.player;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.capability.IPlayerWardrobeCap;
import moe.plushie.armourers_workshop.api.common.skin.entity.ISkinnableEntity;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.common.capability.wardrobe.WardrobeCap;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class PlayerWardrobeStorage
implements Capability.IStorage<IPlayerWardrobeCap> {
    private static final String TAG_ARMOUR_OVERRIDE = "armourOverride";
    private static final String TAG_SLOTS_UNLOCKED = "slots-unlocked-";

    public NBTBase writeNBT(Capability<IPlayerWardrobeCap> capability, IPlayerWardrobeCap instance, EnumFacing side) {
        Capability.IStorage storage = WardrobeCap.WARDROBE_CAP.getStorage();
        NBTTagCompound compound = (NBTTagCompound)storage.writeNBT(WardrobeCap.WARDROBE_CAP, (Object)instance, side);
        for (int i = 0; i < 4; ++i) {
            compound.func_74757_a(TAG_ARMOUR_OVERRIDE + i, instance.getArmourOverride(EntityEquipmentSlot.values()[i + 2]));
        }
        ISkinnableEntity skinnableEntity = instance.getSkinnableEntity();
        ArrayList<ISkinType> skinTypes = new ArrayList<ISkinType>();
        skinnableEntity.getValidSkinTypes(skinTypes);
        for (ISkinType skinType : skinTypes) {
            compound.func_74768_a(TAG_SLOTS_UNLOCKED + skinType.getRegistryName(), instance.getUnlockedSlotsForSkinType(skinType));
        }
        return compound;
    }

    public void readNBT(Capability<IPlayerWardrobeCap> capability, IPlayerWardrobeCap instance, EnumFacing side, NBTBase nbt) {
        NBTTagCompound compound = (NBTTagCompound)nbt;
        Capability.IStorage storage = WardrobeCap.WARDROBE_CAP.getStorage();
        storage.readNBT(WardrobeCap.WARDROBE_CAP, (Object)instance, side, (NBTBase)compound);
        for (int i = 0; i < 4; ++i) {
            instance.setArmourOverride(EntityEquipmentSlot.values()[i + 2], compound.func_74767_n(TAG_ARMOUR_OVERRIDE + i));
        }
        ISkinnableEntity skinnableEntity = instance.getSkinnableEntity();
        ArrayList<ISkinType> skinTypes = new ArrayList<ISkinType>();
        skinnableEntity.getValidSkinTypes(skinTypes);
        for (ISkinType skinType : skinTypes) {
            if (!compound.func_150297_b(TAG_SLOTS_UNLOCKED + skinType.getRegistryName(), 3)) continue;
            instance.setUnlockedSlotsForSkinType(skinType, compound.func_74762_e(TAG_SLOTS_UNLOCKED + skinType.getRegistryName()));
        }
    }
}

