/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.command;

import java.io.File;
import java.util.List;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.common.command.ModCommand;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.common.skin.exporter.ISkinExporter;
import moe.plushie.armourers_workshop.common.skin.exporter.SkinExportManager;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandExportSkin
extends ModCommand {
    public CommandExportSkin(ModCommand parent) {
        super(parent, "export_skin");
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 2) {
            return CommandExportSkin.func_71530_a((String[])args, (String[])SkinExportManager.getExporters());
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Skin skin;
        if (args.length < 3) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[]{args});
        }
        EntityPlayerMP player = CommandExportSkin.func_71521_c((ICommandSender)sender);
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        SkinDescriptor skinPointer = SkinNBTHelper.getSkinDescriptorFromStack(stack);
        if (skinPointer == null) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[]{args});
        }
        String fileExtension = args[1];
        ISkinExporter skinExporter = SkinExportManager.getSkinExporter(fileExtension);
        if (skinExporter == null) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[]{args});
        }
        String exportName = args[2];
        if (!exportName.substring(0, 1).equals("\"")) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[]{exportName});
        }
        int usedCommands = 2;
        if (!exportName.substring(exportName.length() - 1, exportName.length()).equals("\"")) {
            for (int i = 3; i < args.length; ++i) {
                if (!(exportName = exportName + " " + args[i]).substring(exportName.length() - 1, exportName.length()).equals("\"")) continue;
                usedCommands = i;
                break;
            }
        }
        if (!exportName.substring(exportName.length() - 1, exportName.length()).equals("\"")) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[]{exportName});
        }
        exportName = exportName.replace("\"", "");
        float scale = 0.0625f;
        if (args.length > usedCommands + 1) {
            scale = (float)CommandExportSkin.func_175765_c((String)args[usedCommands + 1]);
        }
        if ((skin = ClientSkinCache.INSTANCE.getSkin(skinPointer)) == null) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[]{args});
        }
        File exportDir = new File(ArmourersWorkshop.getProxy().getModDirectory(), "model-exports");
        if (!exportDir.exists()) {
            exportDir.mkdir();
        }
        SkinExportManager.exportSkin(skin, skinExporter, exportDir, exportName, scale);
    }
}

