/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.command.wardrobe;

import java.awt.Color;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import moe.plushie.armourers_workshop.api.common.capability.IEntitySkinCapability;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.common.capability.entityskin.EntitySkinCapability;
import moe.plushie.armourers_workshop.common.command.ModCommand;
import moe.plushie.armourers_workshop.common.library.LibraryFile;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.skin.cache.CommonSkinCache;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.common.skin.data.SkinDye;
import moe.plushie.armourers_workshop.common.skin.data.SkinIdentifier;
import moe.plushie.armourers_workshop.utils.ModLogger;
import moe.plushie.armourers_workshop.utils.SkinIOUtils;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.Level;

public class CommandWardrobeSetSkin
extends ModCommand {
    public CommandWardrobeSetSkin(ModCommand parent) {
        super(parent, "set_skin");
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == this.getParentCount() + 1) {
            return CommandWardrobeSetSkin.func_71530_a((String[])args, (String[])this.getPlayers(server));
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length <= this.getParentCount() + 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[]{args});
        }
        String playerName = args[this.getParentCount()];
        EntityPlayerMP player = CommandWardrobeSetSkin.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)playerName);
        if (player == null) {
            return;
        }
        int slotNum = 0;
        slotNum = CommandWardrobeSetSkin.func_175764_a((String)args[this.getParentCount() + 1], (int)1, (int)10);
        String skinName = args[this.getParentCount() + 2];
        if (!skinName.substring(0, 1).equals("\"")) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[]{skinName});
        }
        int usedCommands = this.getParentCount() + 3;
        if (!skinName.substring(skinName.length() - 1, skinName.length()).equals("\"")) {
            for (int i = this.getParentCount() + 3; i < args.length; ++i) {
                if (!(skinName = skinName + " " + args[i]).substring(skinName.length() - 1, skinName.length()).equals("\"")) continue;
                usedCommands = i + 1;
                break;
            }
        }
        if (!skinName.substring(skinName.length() - 1, skinName.length()).equals("\"")) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[]{skinName});
        }
        skinName = skinName.replace("\"", "");
        SkinDye skinDye = new SkinDye();
        for (int i = usedCommands; i < args.length; ++i) {
            int b;
            int g;
            int r;
            String dyeCommand = args[i];
            ModLogger.log("Command dye: " + dyeCommand);
            if (!dyeCommand.contains("-")) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[]{skinName});
            }
            String[] commandSplit = dyeCommand.split("-");
            if (commandSplit.length < 2 | commandSplit.length > 3) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[]{skinName});
            }
            int dyeIndex = CommandWardrobeSetSkin.func_175764_a((String)commandSplit[0], (int)1, (int)8) - 1;
            String dye = commandSplit[1];
            IPaintType t = PaintTypeRegistry.PAINT_TYPE_NORMAL;
            if (commandSplit.length == 3) {
                String dyeString = commandSplit[2];
                t = PaintTypeRegistry.getInstance().getPaintTypeFormName(dyeString);
            }
            if (dye.startsWith("#") && dye.length() == 7) {
                if (this.isValidHex(dye)) {
                    Color dyeColour = Color.decode(dye);
                    r = dyeColour.getRed();
                    g = dyeColour.getGreen();
                    b = dyeColour.getBlue();
                    skinDye.addDye(dyeIndex, new byte[]{(byte)r, (byte)g, (byte)b, (byte)t.getId()});
                    continue;
                }
                throw new WrongUsageException("commands.armourers.invalidDyeFormat", new Object[]{dye});
            }
            if (dye.length() >= 5 & dye.contains(",")) {
                String[] dyeValues = dye.split(",");
                if (dyeValues.length != 3) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[]{skinName});
                }
                r = CommandWardrobeSetSkin.func_175764_a((String)dyeValues[0], (int)0, (int)255);
                g = CommandWardrobeSetSkin.func_175764_a((String)dyeValues[1], (int)0, (int)255);
                b = CommandWardrobeSetSkin.func_175764_a((String)dyeValues[2], (int)0, (int)255);
                skinDye.addDye(dyeIndex, new byte[]{(byte)r, (byte)g, (byte)b, (byte)t.getId()});
                continue;
            }
            throw new WrongUsageException("commands.armourers.invalidDyeFormat", new Object[]{dye});
        }
        LibraryFile libraryFile = new LibraryFile(skinName);
        Skin skin = SkinIOUtils.loadSkinFromLibraryFile(libraryFile);
        if (skin == null) {
            throw new WrongUsageException("commands.armourers.fileNotFound", new Object[]{skinName});
        }
        try {
            skin.lightHash();
        }
        catch (Exception e) {
            ModLogger.log(Level.ERROR, String.format("Unable to create ID for file %s.", libraryFile.toString()));
            return;
        }
        CommonSkinCache.INSTANCE.addEquipmentDataToCache(skin, libraryFile);
        SkinIdentifier skinIdentifier = new SkinIdentifier(0, libraryFile, 0, skin.getSkinType());
        SkinDescriptor skinDescriptor = new SkinDescriptor(skinIdentifier, skinDye);
        IEntitySkinCapability skinCapability = EntitySkinCapability.get((Entity)player);
        if (skinCapability != null) {
            skinCapability.setSkinDescriptor(skinIdentifier.getSkinType(), slotNum - 1, skinDescriptor);
            skinCapability.syncToPlayer(player);
            skinCapability.syncToAllTracking();
        }
    }

    private boolean isValidHex(String colorStr) {
        ModLogger.log(colorStr);
        String hexPatten = "^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$";
        Pattern pattern = Pattern.compile(hexPatten);
        Matcher matcher = pattern.matcher(colorStr);
        return matcher.matches();
    }
}

