/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.holiday;

import java.util.ArrayList;
import java.util.Calendar;
import moe.plushie.armourers_workshop.common.capability.holiday.HolidayTrackCap;
import moe.plushie.armourers_workshop.common.capability.holiday.IHolidayTrackCap;
import moe.plushie.armourers_workshop.common.holiday.Holiday;
import moe.plushie.armourers_workshop.common.holiday.HolidayChristmasSeason;
import moe.plushie.armourers_workshop.common.holiday.HolidayHalloweenSeason;
import moe.plushie.armourers_workshop.common.holiday.HolidayValentines;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="armourers_workshop")
public final class ModHolidays {
    private static final ArrayList<Holiday> HOLIDAY_LIST = new ArrayList();
    public static final Holiday HALLOWEEN = new Holiday("halloween", 31, 9, 1, 0);
    public static final Holiday HALLOWEEN_SEASON = new HolidayHalloweenSeason("halloween-season", 24, 9, 8, 0);
    public static final Holiday CHRISTMAS = new Holiday("christmas", 25, 11, 0, 24);
    public static final Holiday CHRISTMAS_SEASON = new HolidayChristmasSeason("christmas-season", 1, 11, 31, 0);
    public static final Holiday VALENTINES = new HolidayValentines("valentines", 14, 1, 1, 0);
    public static final Holiday NEW_YEARS = new Holiday("new-years", 1, 0, 1, 0);
    public static final Holiday PONYTAIL_DAY = new Holiday("ponytail-day", 7, 6, 1, 0);
    public static final Holiday APRIL_FOOLS = new Holiday("april-fools", 1, 3, 1, 0);

    public static ArrayList<Holiday> getHolidays() {
        return HOLIDAY_LIST;
    }

    public static Holiday getHoliday(String name) {
        for (Holiday holiday : HOLIDAY_LIST) {
            if (!holiday.getName().equals(name)) continue;
            return holiday;
        }
        return null;
    }

    public static ArrayList<Holiday> getActiveHolidays() {
        ArrayList<Holiday> activeList = new ArrayList<Holiday>();
        for (int i = 0; i < HOLIDAY_LIST.size(); ++i) {
            if (!HOLIDAY_LIST.get(i).isHolidayActive()) continue;
            activeList.add(HOLIDAY_LIST.get(i));
        }
        return activeList;
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        IHolidayTrackCap holidayTrackCap = HolidayTrackCap.get(player);
        if (holidayTrackCap == null) {
            return;
        }
        for (Holiday holiday : ModHolidays.getActiveHolidays()) {
            ItemStack gift;
            if (!holiday.hasGiftSack() || holidayTrackCap.getLastHolidayYear(holiday) >= ModHolidays.getYear() || (gift = holiday.getGiftSack()).func_190926_b()) continue;
            if (!player.field_71071_by.func_70441_a(gift)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.armourersworkshop:inventoryGiftFail", new Object[0]));
                continue;
            }
            holidayTrackCap.setLastHoloidayYear(holiday, ModHolidays.getYear());
        }
    }

    public static int getYear() {
        return Calendar.getInstance().get(1);
    }
}

