/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.blocks;

import com.mojang.authlib.GameProfile;
import java.util.Random;
import moe.plushie.armourers_workshop.client.render.item.RenderItemMannequin;
import moe.plushie.armourers_workshop.common.Contributors;
import moe.plushie.armourers_workshop.common.config.ConfigHandler;
import moe.plushie.armourers_workshop.common.data.type.TextureType;
import moe.plushie.armourers_workshop.common.holiday.ModHolidays;
import moe.plushie.armourers_workshop.common.init.blocks.AbstractModBlockContainer;
import moe.plushie.armourers_workshop.common.init.entities.EntityMannequin;
import moe.plushie.armourers_workshop.common.lib.EnumGuiId;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityMannequin;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.UtilItems;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDoll
extends AbstractModBlockContainer {
    private static final String TAG_OWNER = "owner";
    private static final String TAG_IMAGE_URL = "imageUrl";
    private final boolean isValentins;
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.95f, (double)0.8f);

    public BlockDoll() {
        super("doll", Material.field_151594_q, SoundType.field_185852_e, !ConfigHandler.hideDollFromCreativeTabs);
        this.func_149713_g(0);
        this.isValentins = ModHolidays.VALENTINES.isHolidayActive();
        this.setSortPriority(198);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityMannequin te;
        if (!worldIn.field_72995_K && (te = this.getTileEntity((IBlockAccess)worldIn, pos, TileEntityMannequin.class)) != null) {
            te.disableSync();
            BlockUtils.dropInventoryBlocks(worldIn, te, pos);
            UtilItems.spawnItemInWorld(worldIn, pos, this.createItemStackFromTile(te));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityMannequin) {
            int l = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
            ((TileEntityMannequin)te).PROP_ROTATION.set(l);
            if (!worldIn.field_72995_K && stack.func_77942_o()) {
                NBTTagCompound compound = stack.func_77978_p();
                GameProfile gameProfile = null;
                if (compound.func_150297_b(TAG_OWNER, 10)) {
                    gameProfile = NBTUtil.func_152459_a((NBTTagCompound)compound.func_74775_l(TAG_OWNER));
                    ((TileEntityMannequin)te).PROP_OWNER.set(gameProfile);
                }
                if (compound.func_150297_b(TAG_IMAGE_URL, 8)) {
                    ((TileEntityMannequin)te).PROP_IMAGE_URL.set(compound.func_74779_i(TAG_IMAGE_URL));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        Contributors.Contributor contributor;
        TileEntityMannequin te;
        TileEntity tileEntity;
        ParticleManager particleManager = Minecraft.func_71410_x().field_71452_i;
        if (this.isValentins && rand.nextFloat() * 100.0f > 75.0f) {
            Particle particle = particleManager.func_178927_a(EnumParticleTypes.HEART.func_179348_c(), (double)((float)pos.func_177958_n() - 0.2f + rand.nextFloat() * 0.6f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() - 0.2f + rand.nextFloat() * 0.6f), 0.0, 0.0, 0.0, null);
            Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
        }
        if ((tileEntity = worldIn.func_175625_s(pos)) != null && tileEntity instanceof TileEntityMannequin && (te = (TileEntityMannequin)tileEntity) != null && te.PROP_RENDER_EXTRAS.get().booleanValue() && (contributor = Contributors.INSTANCE.getContributor(te.PROP_OWNER.get())) != null & te.PROP_VISIBLE.get()) {
            for (int i = 0; i < 6; ++i) {
                Particle particle = particleManager.func_178927_a(EnumParticleTypes.SPELL.func_179348_c(), (double)((float)pos.func_177958_n() + rand.nextFloat() * 1.0f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + rand.nextFloat() * 1.0f), 0.0, 0.0, 0.0, null);
                particle.func_70538_b((float)(contributor.r & 0xFF) / 255.0f, (float)(contributor.g & 0xFF) / 255.0f, (float)(contributor.b & 0xFF) / 255.0f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
            }
        }
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityMannequin) {
            int rotation = ((TileEntityMannequin)te).PROP_ROTATION.get();
            if (++rotation > 15) {
                rotation = 0;
            }
            ((TileEntityMannequin)te).PROP_ROTATION.set(rotation);
        }
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityMannequin te = this.getTileEntity((IBlockAccess)world, pos, TileEntityMannequin.class);
        return this.createItemStackFromTile(te);
    }

    private ItemStack createItemStackFromTile(TileEntityMannequin te) {
        ItemStack stack = new ItemStack((Block)this, 1);
        if (te != null) {
            if (te.PROP_OWNER.get() != null) {
                NBTTagCompound profileTag = new NBTTagCompound();
                NBTUtil.func_180708_a((NBTTagCompound)profileTag, (GameProfile)te.PROP_OWNER.get());
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74782_a(TAG_OWNER, (NBTBase)profileTag);
            }
            if (!StringUtils.func_151246_b((String)te.PROP_IMAGE_URL.get())) {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74778_a(TAG_IMAGE_URL, te.PROP_IMAGE_URL.get());
            }
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!playerIn.func_175151_a(pos, facing, playerIn.func_184586_b(hand))) {
            return false;
        }
        this.openGui(playerIn, EnumGuiId.MANNEQUIN, worldIn, pos, state, facing);
        return true;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityMannequin(true);
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        super.registerModels();
        Item.func_150898_a((Block)this).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new RenderItemMannequin());
    }

    public void convertToEntity(World world, BlockPos pos) {
        TileEntityMannequin tileEntity = this.getTileEntity((IBlockAccess)world, pos, TileEntityMannequin.class);
        if (tileEntity != null) {
            EntityMannequin.TextureData textureData = new EntityMannequin.TextureData();
            if (tileEntity.PROP_OWNER.get() != null && tileEntity.PROP_TEXTURE_TYPE.get() == TextureType.USER) {
                textureData = new EntityMannequin.TextureData(tileEntity.PROP_OWNER.get());
            }
            if (!StringUtils.func_151246_b((String)tileEntity.PROP_IMAGE_URL.get()) && tileEntity.PROP_TEXTURE_TYPE.get() == TextureType.URL) {
                textureData = new EntityMannequin.TextureData(tileEntity.PROP_IMAGE_URL.get());
            }
            float offsetX = tileEntity.PROP_OFFSET_X.get().floatValue();
            float offsetY = tileEntity.PROP_OFFSET_Y.get().floatValue();
            float offsetZ = tileEntity.PROP_OFFSET_Z.get().floatValue();
            EntityMannequin entityMannequin = new EntityMannequin(world);
            entityMannequin.func_70107_b((float)pos.func_177958_n() + 0.5f + offsetX, (float)pos.func_177956_o() + offsetY, (float)pos.func_177952_p() + 0.5f + offsetZ);
            entityMannequin.setRotation((float)tileEntity.PROP_ROTATION.get().intValue() * 22.5f + 180.0f);
            entityMannequin.setScale(0.5f);
            world.func_72838_d((Entity)entityMannequin);
            entityMannequin.setTextureData(textureData, true);
            world.func_175713_t(pos);
            world.func_175698_g(pos);
            if (world.func_180495_p(pos.func_177972_a(EnumFacing.UP)).func_177230_c() == this) {
                world.func_175698_g(pos.func_177972_a(EnumFacing.UP));
            }
        }
    }
}

