/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.blocks;

import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.common.init.blocks.AbstractModBlockContainer;
import moe.plushie.armourers_workshop.common.lib.EnumGuiId;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityDyeTable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDyeTable
extends AbstractModBlockContainer {
    public static final PropertyDirection STATE_FACING = BlockHorizontal.field_185512_D;

    public BlockDyeTable() {
        super("dye-table");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STATE_FACING, (Comparable)EnumFacing.NORTH));
        this.setSortPriority(150);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STATE_FACING});
    }

    public IBlockState func_176203_a(int meta) {
        boolean northSouthBit = BlockDyeTable.getBitBool(meta, 0);
        boolean posNegBit = BlockDyeTable.getBitBool(meta, 1);
        EnumFacing facing = EnumFacing.EAST;
        facing = northSouthBit ? (posNegBit ? EnumFacing.SOUTH : EnumFacing.NORTH) : (posNegBit ? EnumFacing.EAST : EnumFacing.WEST);
        return this.func_176223_P().func_177226_a((IProperty)STATE_FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)STATE_FACING);
        int meta = 0;
        if (facing == EnumFacing.NORTH | facing == EnumFacing.SOUTH) {
            meta = BlockDyeTable.setBit(meta, 0, true);
        }
        if (facing == EnumFacing.EAST | facing == EnumFacing.SOUTH) {
            meta = BlockDyeTable.setBit(meta, 1, true);
        }
        return meta;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing enumfacing = placer.func_174811_aO().func_176734_d();
        return this.func_176223_P().func_177226_a((IProperty)STATE_FACING, (Comparable)enumfacing);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        if (!ConfigHandlerClient.useClassicBlockModels) {
            return BlockRenderLayer.CUTOUT_MIPPED;
        }
        return BlockRenderLayer.SOLID;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        this.openGui(playerIn, EnumGuiId.DYE_TABLE, worldIn, pos, state, facing);
        return true;
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new TileEntityDyeTable();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        if (!ConfigHandlerClient.useClassicBlockModels) {
            super.registerModels();
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_149739_a() + "-classic"), "normal"));
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178439_a("-classic").func_178442_a(new IProperty[]{STATE_FACING}).func_178441_a());
        }
    }
}

