/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.blocks;

import java.util.Random;
import moe.plushie.armourers_workshop.common.init.blocks.AbstractModBlockContainer;
import moe.plushie.armourers_workshop.common.lib.EnumGuiId;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityHologramProjector;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockHologramProjector
extends AbstractModBlockContainer {
    public static final PropertyDirection STATE_FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockHologramProjector() {
        super("hologram-projector");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STATE_FACING, (Comparable)EnumFacing.NORTH));
        this.setSortPriority(120);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STATE_FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)STATE_FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)STATE_FACING)).ordinal();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        BlockUtils.dropInventoryBlocks(worldIn, pos);
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    @Override
    public boolean func_149637_q(IBlockState state) {
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        int dir = BlockUtils.determineOrientation(pos, placer);
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)dir);
        return this.func_176223_P().func_177226_a((IProperty)STATE_FACING, (Comparable)enumfacing);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        this.updatePoweredState((IBlockAccess)worldIn, pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        this.openGui(playerIn, EnumGuiId.HOLOGRAM_PROJECTOR, worldIn, pos, state, facing);
        return true;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        this.updatePoweredState(world, pos);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        this.updatePoweredState((IBlockAccess)worldIn, pos);
    }

    private void updatePoweredState(IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileEntityHologramProjector) {
            ((TileEntityHologramProjector)tileEntity).updatePoweredState();
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityHologramProjector();
    }
}

