/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.items.paintingtool;

import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.api.common.painting.IPantableBlock;
import moe.plushie.armourers_workshop.common.holiday.ModHolidays;
import moe.plushie.armourers_workshop.common.init.items.paintingtool.AbstractPaintingTool;
import moe.plushie.armourers_workshop.common.init.sounds.ModSounds;
import moe.plushie.armourers_workshop.common.painting.tool.IConfigurableTool;
import moe.plushie.armourers_workshop.common.painting.tool.ToolOption;
import moe.plushie.armourers_workshop.common.painting.tool.ToolOptions;
import moe.plushie.armourers_workshop.common.world.undo.UndoManager;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPaintbrush
extends AbstractPaintingTool
implements IConfigurableTool {
    public ItemPaintbrush() {
        super("paintbrush");
        this.setSortPriority(20);
    }

    @Override
    public void playToolSound(EntityPlayer player, World world, BlockPos pos, ItemStack stack) {
        ModSounds.ModSound soundEvent = ModSounds.PAINT;
        if (ModHolidays.APRIL_FOOLS.isHolidayActive()) {
            soundEvent = ModSounds.BOI;
        }
        if (((Boolean)ToolOptions.FULL_BLOCK_MODE.getValue(stack)).booleanValue()) {
            world.func_184133_a(null, pos, (SoundEvent)soundEvent, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.2f + 0.9f);
        } else {
            world.func_184133_a(null, pos, (SoundEvent)soundEvent, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.5f);
        }
    }

    @Override
    public void usedOnBlockSide(ItemStack stack, EntityPlayer player, World world, BlockPos pos, Block block, EnumFacing face, boolean spawnParticles) {
        int colour = this.getToolColour(stack);
        IPaintType paintType = this.getToolPaintType(stack);
        if (!world.field_72995_K) {
            IPantableBlock worldColourable = (IPantableBlock)block;
            int oldColour = worldColourable.getColour((IBlockAccess)world, pos, face);
            byte oldPaintType = (byte)worldColourable.getPaintType((IBlockAccess)world, pos, face).getId();
            UndoManager.blockPainted(player, world, pos, oldColour, oldPaintType, face);
            ((IPantableBlock)block).setColour((IBlockAccess)world, pos, colour, face);
            ((IPantableBlock)block).setPaintType((IBlockAccess)world, pos, paintType, face);
        } else if (spawnParticles) {
            this.spawnPaintParticles(world, pos, face, colour);
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.addOpenSettingsInformation(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public void getToolOptions(ArrayList<ToolOption<?>> toolOptionList) {
        toolOptionList.add(ToolOptions.FULL_BLOCK_MODE);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                if (((Boolean)ToolOptions.FULL_BLOCK_MODE.getValue(stack)).booleanValue()) {
                    return new ModelResourceLocation(new ResourceLocation("armourers_workshop", ItemPaintbrush.this.func_77658_a()), "normal");
                }
                return new ModelResourceLocation(new ResourceLocation("armourers_workshop", ItemPaintbrush.this.func_77658_a() + "-small"), "normal");
            }
        });
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_77658_a()), "normal"), new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_77658_a() + "-small"), "normal")});
    }
}

