/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.inventory;

import java.util.HashMap;
import java.util.Set;
import moe.plushie.armourers_workshop.api.common.ISkinInventoryContainer;
import moe.plushie.armourers_workshop.api.common.skin.entity.ISkinnableEntity;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.common.inventory.ModInventory;
import moe.plushie.armourers_workshop.common.inventory.WardrobeInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class SkinInventoryContainer
implements ISkinInventoryContainer {
    private static final String TAG_WARDROBE_CONTAINER = "wardrobeContainer";
    private final HashMap<ISkinType, WardrobeInventory> skinInventorys = new HashMap();

    public SkinInventoryContainer(ModInventory.IInventoryCallback callback, ISkinType[] validSkins, int slotCount) {
        for (int i = 0; i < validSkins.length; ++i) {
            this.skinInventorys.put(validSkins[i], new WardrobeInventory(callback, validSkins[i], slotCount));
        }
    }

    public SkinInventoryContainer(ModInventory.IInventoryCallback callback, ISkinType[] validSkins, ISkinnableEntity skinnableEntity) {
        for (int i = 0; i < validSkins.length; ++i) {
            this.skinInventorys.put(validSkins[i], new WardrobeInventory(callback, validSkins[i], skinnableEntity.getSlotsForSkinType(validSkins[i])));
        }
    }

    public WardrobeInventory getSkinTypeInv(ISkinType skinType) {
        return this.skinInventorys.get(skinType);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTTagCompound containerCompound = new NBTTagCompound();
        Set<ISkinType> skinTypes = this.skinInventorys.keySet();
        for (int i = 0; i < this.skinInventorys.size(); ++i) {
            ISkinType skinType = (ISkinType)this.skinInventorys.keySet().toArray()[i];
            this.skinInventorys.get(skinType).writeItemsToNBT(containerCompound);
        }
        compound.func_74782_a(TAG_WARDROBE_CONTAINER, (NBTBase)containerCompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        if (compound.func_150297_b(TAG_WARDROBE_CONTAINER, 10)) {
            NBTTagCompound containerCompound = compound.func_74775_l(TAG_WARDROBE_CONTAINER);
            Set<ISkinType> skinTypes = this.skinInventorys.keySet();
            for (int i = 0; i < this.skinInventorys.size(); ++i) {
                ISkinType skinType = (ISkinType)this.skinInventorys.keySet().toArray()[i];
                this.skinInventorys.get(skinType).readItemsFromNBT(containerCompound);
            }
        }
    }

    @Override
    public void dropItems(World world, Vec3d pos) {
        Set<ISkinType> skinTypes = this.skinInventorys.keySet();
        for (int i = 0; i < this.skinInventorys.size(); ++i) {
            ISkinType skinType = (ISkinType)this.skinInventorys.keySet().toArray()[i];
            this.skinInventorys.get(skinType).dropItems(world, pos);
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.skinInventorys.size(); ++i) {
            ISkinType skinType = (ISkinType)this.skinInventorys.keySet().toArray()[i];
            this.skinInventorys.get(skinType).func_174888_l();
        }
    }
}

