/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.library.global.auth;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.util.Session;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.Level;

public class MinecraftAuth {
    private static final String JOIN_URL = "https://sessionserver.mojang.com/session/minecraft/join";
    private static long lastAuthTime;
    private static final Object MC_AUTH_LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkAndRefeshAuth(Session session, String serverId) {
        Object object = MC_AUTH_LOCK;
        synchronized (object) {
            if (lastAuthTime + 30000L > System.currentTimeMillis()) {
                ModLogger.log("skipping mc auth");
                return true;
            }
            ModLogger.log(Level.INFO, "MC Auth start");
            Object conn = null;
            String data = "{\"accessToken\":\"" + session.func_148254_d() + "\", \"serverId\":\"" + serverId + "\", \"selectedProfile\":\"" + session.func_148255_b() + "\"}";
            try {
                String result = MinecraftAuth.performPostRequest(new URL(JOIN_URL), data, "application/json");
                lastAuthTime = System.currentTimeMillis();
                return true;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String performPostRequest(URL url, String post, String contentType) throws IOException {
        Validate.notNull((Object)url);
        Validate.notNull((Object)post);
        Validate.notNull((Object)contentType);
        HttpURLConnection connection = MinecraftAuth.createUrlConnection(url);
        byte[] postAsBytes = post.getBytes(Charsets.UTF_8);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", contentType + "; charset=utf-8");
        connection.setRequestProperty("Content-Length", "" + postAsBytes.length);
        connection.setDoOutput(true);
        OutputStream outputStream = null;
        try {
            outputStream = connection.getOutputStream();
            IOUtils.write((byte[])postAsBytes, (OutputStream)outputStream);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        InputStream inputStream = null;
        try {
            String result;
            inputStream = connection.getInputStream();
            String string = result = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            IOUtils.closeQuietly((InputStream)inputStream);
            inputStream = connection.getErrorStream();
            if (inputStream != null) {
                String result;
                String string = result = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
                return string;
            }
            throw e;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private static HttpURLConnection createUrlConnection(URL url) throws IOException {
        Validate.notNull((Object)url);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(15000);
        connection.setUseCaches(false);
        return connection;
    }

    static {
        MC_AUTH_LOCK = new Object();
    }
}

