/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.library.global.permission;

import java.util.EnumSet;

public final class PermissionSystem {
    public final PermissionGroup groupNoLogin;
    public final PermissionGroup groupUser;
    public final PermissionGroup groupMod;
    public final PermissionGroup groupAdmin;

    public PermissionSystem() {
        EnumSet<PlushieAction> actions = EnumSet.noneOf(PlushieAction.class);
        actions.add(PlushieAction.SKIN_DOWNLOAD);
        actions.add(PlushieAction.GET_RECENTLY_UPLOADED);
        actions.add(PlushieAction.GET_MOST_DOWNLOADED);
        actions.add(PlushieAction.GET_MOST_LIKED);
        actions.add(PlushieAction.USER_INFO);
        actions.add(PlushieAction.SKIN_SEARCH);
        actions.add(PlushieAction.SKIN_LIST_USER);
        actions.add(PlushieAction.BETA_JOIN);
        actions.add(PlushieAction.BETA_CHECK);
        actions.add(PlushieAction.SERVER_VIEW_STATS);
        actions.add(PlushieAction.GET_SKIN_INFO);
        this.groupNoLogin = new PermissionGroup("no login", (EnumSet<PlushieAction>)actions.clone());
        actions.add(PlushieAction.SKIN_UPLOAD);
        actions.add(PlushieAction.SKIN_RATE);
        actions.add(PlushieAction.SKIN_REPORT);
        actions.add(PlushieAction.SKIN_OWNER_DELETE);
        actions.add(PlushieAction.SKIN_OWNER_EDIT);
        actions.add(PlushieAction.SKIN_COMMENT_CREATE);
        actions.add(PlushieAction.SKIN_COMMENT_OWNER_DELETE);
        actions.add(PlushieAction.SKIN_COMMENT_OWNER_EDIT);
        actions.add(PlushieAction.SKIN_GET_RATED);
        this.groupUser = new PermissionGroup("user", (EnumSet<PlushieAction>)actions.clone());
        actions.add(PlushieAction.SKIN_MOD_EDIT);
        actions.add(PlushieAction.SKIN_MOD_DELETE);
        actions.add(PlushieAction.SKIN_COMMENT_MOD_DELETE);
        actions.add(PlushieAction.SKIN_COMMENT_MOD_EDIT);
        actions.add(PlushieAction.FLAG_GET_LIST);
        actions.add(PlushieAction.FLAG_DELETE);
        actions.add(PlushieAction.USER_BAN_TEMP);
        actions.add(PlushieAction.USER_BAN_PERM);
        actions.add(PlushieAction.GET_REPORT_LIST);
        this.groupMod = new PermissionGroup("mod", (EnumSet<PlushieAction>)actions.clone());
        this.groupAdmin = new PermissionGroup("admin", EnumSet.allOf(PlushieAction.class));
    }

    public static class AuthenticationException
    extends Exception {
    }

    public static class InsufficientPermissionsException
    extends Exception {
        private final PlushieAction plushieAction;

        public InsufficientPermissionsException(PlushieAction plushieAction) {
            this.plushieAction = plushieAction;
        }

        public PlushieAction getAction() {
            return this.plushieAction;
        }
    }

    public static class PermissionGroup {
        private final String name;
        private final EnumSet<PlushieAction> actions;

        public PermissionGroup(String name, EnumSet<PlushieAction> actions) {
            this.name = name;
            this.actions = EnumSet.noneOf(PlushieAction.class);
            this.actions.addAll(actions);
        }

        public String getName() {
            return this.name;
        }

        public boolean havePermission(PlushieAction action) {
            return this.actions.contains((Object)action);
        }
    }

    public static enum PlushieAction {
        GET_RECENTLY_UPLOADED,
        GET_MOST_LIKED,
        GET_MOST_DOWNLOADED,
        BETA_JOIN,
        BETA_CHECK,
        SKIN_SEARCH,
        SKIN_LIST_USER,
        SKIN_DOWNLOAD,
        USER_INFO,
        SERVER_VIEW_STATS,
        GET_SKIN_INFO,
        SKIN_UPLOAD,
        SKIN_RATE,
        SKIN_GET_RATED,
        SKIN_REPORT,
        SKIN_OWNER_DELETE,
        SKIN_OWNER_EDIT,
        SKIN_COMMENT_CREATE,
        SKIN_COMMENT_OWNER_DELETE,
        SKIN_COMMENT_OWNER_EDIT,
        GET_REPORT_LIST,
        SKIN_MOD_DELETE,
        SKIN_MOD_EDIT,
        SKIN_COMMENT_MOD_DELETE,
        SKIN_COMMENT_MOD_EDIT,
        FLAG_GET_LIST,
        FLAG_DELETE,
        USER_BAN_TEMP,
        USER_BAN_PERM,
        USER_GROUP_CHANGE;

    }
}

