/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.network;

import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.common.capability.IPlayerWardrobeCap;
import moe.plushie.armourers_workshop.api.common.capability.IWardrobeCap;
import moe.plushie.armourers_workshop.client.gui.GuiAdminPanel;
import moe.plushie.armourers_workshop.client.gui.GuiDebugTool;
import moe.plushie.armourers_workshop.client.gui.GuiGuideBook;
import moe.plushie.armourers_workshop.client.gui.GuiToolOptions;
import moe.plushie.armourers_workshop.client.gui.miniarmourer.GuiMiniArmourer;
import moe.plushie.armourers_workshop.client.gui.wardrobe.GuiWardrobe;
import moe.plushie.armourers_workshop.common.capability.entityskin.EntitySkinCapability;
import moe.plushie.armourers_workshop.common.capability.wardrobe.WardrobeCap;
import moe.plushie.armourers_workshop.common.capability.wardrobe.player.PlayerWardrobeCap;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.common.inventory.ContainerSkinWardrobe;
import moe.plushie.armourers_workshop.common.inventory.IGuiFactory;
import moe.plushie.armourers_workshop.common.inventory.ModContainer;
import moe.plushie.armourers_workshop.common.lib.EnumGuiId;
import moe.plushie.armourers_workshop.common.painting.tool.IConfigurableTool;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.Level;

public class GuiHandler
implements IGuiHandler {
    public GuiHandler() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)ArmourersWorkshop.getInstance(), (IGuiHandler)this);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID < 0 & ID > EnumGuiId.values().length) {
            return null;
        }
        EnumGuiId guiId = EnumGuiId.values()[ID];
        if (guiId.isTile()) {
            TileEntity te;
            BlockPos pos = new BlockPos(x, y, z);
            if (world.func_175667_e(pos) && (te = world.func_175625_s(pos)) != null && te instanceof IGuiFactory) {
                return ((IGuiFactory)te).getServerGuiElement(player, world, pos);
            }
            return null;
        }
        switch (guiId) {
            case WARDROBE_PLAYER: {
                EntitySkinCapability skinCapabilityPlayer = (EntitySkinCapability)player.getCapability(EntitySkinCapability.ENTITY_SKIN_CAP, null);
                IPlayerWardrobeCap wardrobeCapability = PlayerWardrobeCap.get(player);
                if (skinCapabilityPlayer != null & wardrobeCapability != null) {
                    return new ContainerSkinWardrobe(player.field_71071_by, skinCapabilityPlayer, wardrobeCapability);
                }
                ModLogger.log(Level.WARN, "Error entity not found " + player.getClass());
                break;
            }
            case WARDROBE_ENTITY: {
                Entity entity = player.func_130014_f_().func_73045_a(x);
                if (entity != null) {
                    EntitySkinCapability skinCapability = (EntitySkinCapability)entity.getCapability(EntitySkinCapability.ENTITY_SKIN_CAP, null);
                    IWardrobeCap wardrobeCap = WardrobeCap.get(entity);
                    if (skinCapability == null) {
                        wardrobeCap = PlayerWardrobeCap.get(player);
                    }
                    if (skinCapability == null || wardrobeCap == null) break;
                    return new ContainerSkinWardrobe(player.field_71071_by, skinCapability, wardrobeCap);
                }
                ModLogger.log(Level.WARN, "Error entity not found");
                break;
            }
            case ADMIN_PANEL: {
                return new ModContainer(player.field_71071_by);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID < 0 & ID > EnumGuiId.values().length) {
            return null;
        }
        EnumGuiId guiId = EnumGuiId.values()[ID];
        if (guiId.isTile()) {
            TileEntity te;
            BlockPos pos = new BlockPos(x, y, z);
            if (world.func_175667_e(pos) && (te = world.func_175625_s(pos)) != null && te instanceof IGuiFactory) {
                return ((IGuiFactory)te).getClientGuiElement(player, world, pos);
            }
            return null;
        }
        switch (guiId) {
            case GUIDE_BOOK: {
                if (player.func_184614_ca().func_77973_b() != ModItems.GUIDE_BOOK) break;
                return new GuiGuideBook(player.func_184614_ca());
            }
            case WARDROBE_PLAYER: {
                EntitySkinCapability skinCapabilityPlayer = (EntitySkinCapability)player.getCapability(EntitySkinCapability.ENTITY_SKIN_CAP, null);
                IPlayerWardrobeCap wardrobeCapability = PlayerWardrobeCap.get(player);
                if (skinCapabilityPlayer != null & wardrobeCapability != null) {
                    return new GuiWardrobe(player.field_71071_by, skinCapabilityPlayer, wardrobeCapability);
                }
                ModLogger.log(Level.WARN, "Error entity not found " + player.getClass());
                break;
            }
            case TOOL_OPTIONS: {
                if (!(player.func_184614_ca().func_77973_b() instanceof IConfigurableTool)) break;
                return new GuiToolOptions(player.func_184614_ca());
            }
            case WARDROBE_ENTITY: {
                Entity entity = player.func_130014_f_().func_73045_a(x);
                if (entity != null) {
                    EntitySkinCapability skinCapability = (EntitySkinCapability)entity.getCapability(EntitySkinCapability.ENTITY_SKIN_CAP, null);
                    IWardrobeCap wardrobeCap = WardrobeCap.get(entity);
                    if (skinCapability == null) {
                        wardrobeCap = PlayerWardrobeCap.get(player);
                    }
                    if (skinCapability == null || wardrobeCap == null) break;
                    return new GuiWardrobe(player.field_71071_by, skinCapability, wardrobeCap);
                }
                ModLogger.log(Level.WARN, "Error entity not found");
                break;
            }
            case DEBUG_TOOL: {
                return new GuiDebugTool();
            }
            case ADMIN_PANEL: {
                return new GuiAdminPanel(player);
            }
            case MINI_ARMOURER: {
                return new GuiMiniArmourer(player);
            }
        }
        return null;
    }
}

