/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.network.messages.client;

import io.netty.buffer.ByteBuf;
import moe.plushie.armourers_workshop.common.data.type.BipedRotations;
import moe.plushie.armourers_workshop.common.init.entities.EntityMannequin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageClientGuiUpdateMannequin
implements IMessage {
    private int id;
    private BipedRotations bipedRotations = null;
    private EntityMannequin.TextureData textureData = null;
    private Boolean extraRenders = null;
    private Boolean flying = null;
    private Boolean visible = null;
    private Boolean noClip = null;
    private Vec3d offset = null;

    public MessageClientGuiUpdateMannequin() {
    }

    public MessageClientGuiUpdateMannequin(EntityMannequin entityMannequin) {
        this.id = entityMannequin.func_145782_y();
    }

    public MessageClientGuiUpdateMannequin setBipedRotations(BipedRotations bipedRotations) {
        this.bipedRotations = bipedRotations;
        return this;
    }

    public MessageClientGuiUpdateMannequin setTextureData(EntityMannequin.TextureData textureData) {
        this.textureData = textureData;
        return this;
    }

    public MessageClientGuiUpdateMannequin setExtraRenders(boolean checked) {
        this.extraRenders = checked;
        return this;
    }

    public MessageClientGuiUpdateMannequin setFlying(boolean checked) {
        this.flying = checked;
        return this;
    }

    public MessageClientGuiUpdateMannequin setVisible(boolean checked) {
        this.visible = checked;
        return this;
    }

    public MessageClientGuiUpdateMannequin setNoClip(boolean checked) {
        this.noClip = checked;
        return this;
    }

    public MessageClientGuiUpdateMannequin setOffset(Vec3d offset) {
        this.offset = offset;
        return this;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        if (this.bipedRotations != null) {
            buf.writeBoolean(true);
            this.bipedRotations.writeToBuf(buf);
        } else {
            buf.writeBoolean(false);
        }
        if (this.textureData != null) {
            buf.writeBoolean(true);
            this.textureData.writeToBuf(buf);
        } else {
            buf.writeBoolean(false);
        }
        if (this.extraRenders != null) {
            buf.writeBoolean(true);
            buf.writeBoolean(this.extraRenders.booleanValue());
        } else {
            buf.writeBoolean(false);
        }
        if (this.flying != null) {
            buf.writeBoolean(true);
            buf.writeBoolean(this.flying.booleanValue());
        } else {
            buf.writeBoolean(false);
        }
        if (this.visible != null) {
            buf.writeBoolean(true);
            buf.writeBoolean(this.visible.booleanValue());
        } else {
            buf.writeBoolean(false);
        }
        if (this.noClip != null) {
            buf.writeBoolean(true);
            buf.writeBoolean(this.noClip.booleanValue());
        } else {
            buf.writeBoolean(false);
        }
        if (this.offset != null) {
            buf.writeBoolean(true);
            buf.writeDouble(this.offset.field_72450_a);
            buf.writeDouble(this.offset.field_72448_b);
            buf.writeDouble(this.offset.field_72449_c);
        } else {
            buf.writeBoolean(false);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        if (buf.readBoolean()) {
            this.bipedRotations = new BipedRotations();
            this.bipedRotations.readFromBuf(buf);
        }
        if (buf.readBoolean()) {
            this.textureData = new EntityMannequin.TextureData();
            this.textureData.readFromBuf(buf);
        }
        if (buf.readBoolean()) {
            this.extraRenders = buf.readBoolean();
        }
        if (buf.readBoolean()) {
            this.flying = buf.readBoolean();
        }
        if (buf.readBoolean()) {
            this.visible = buf.readBoolean();
        }
        if (buf.readBoolean()) {
            this.noClip = buf.readBoolean();
        }
        if (buf.readBoolean()) {
            this.offset = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
    }

    public static class Handler
    implements IMessageHandler<MessageClientGuiUpdateMannequin, IMessage> {
        public IMessage onMessage(final MessageClientGuiUpdateMannequin message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.func_130014_f_();
            final Entity entity = world.func_73045_a(message.id);
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    if (entity != null && entity instanceof EntityMannequin) {
                        EntityMannequin entityMannequin = (EntityMannequin)entity;
                        if (message.bipedRotations != null) {
                            entityMannequin.setBipedRotations(message.bipedRotations);
                        }
                        if (message.textureData != null) {
                            entityMannequin.setTextureData(message.textureData, true);
                        }
                        if (message.extraRenders != null) {
                            entityMannequin.setRenderExtras(message.extraRenders);
                        }
                        if (message.flying != null) {
                            entityMannequin.setFlying(message.flying);
                        }
                        if (message.visible != null) {
                            entityMannequin.setVisible(message.visible);
                        }
                        if (message.noClip != null) {
                            entityMannequin.setNoClip(message.noClip);
                        }
                        if (message.offset != null) {
                            Vec3d pos = entityMannequin.func_174791_d();
                            pos = pos.func_178787_e(message.offset);
                            entityMannequin.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                        }
                    }
                }
            });
            return null;
        }
    }
}

