/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.network.messages.server;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import moe.plushie.armourers_workshop.common.addons.ModAddonManager;
import moe.plushie.armourers_workshop.common.config.ConfigHandler;
import moe.plushie.armourers_workshop.common.network.ByteBufHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageServerSyncConfig
implements IMessage,
IMessageHandler<MessageServerSyncConfig, IMessage> {
    private boolean wardrobeAllowOpening = ConfigHandler.wardrobeAllowOpening;
    private boolean wardrobeTabSkins = ConfigHandler.wardrobeTabSkins;
    private boolean wardrobeTabOutfits = ConfigHandler.wardrobeTabOutfits;
    private boolean wardrobeTabDisplaySettings = ConfigHandler.wardrobeTabDisplaySettings;
    private boolean wardrobeTabColourSettings = ConfigHandler.wardrobeTabColourSettings;
    private boolean wardrobeTabDyes = ConfigHandler.wardrobeTabDyes;
    private boolean allowDownloadingSkins = ConfigHandler.allowDownloadingSkins;
    private boolean allowUploadingSkins = ConfigHandler.allowUploadingSkins;
    private String[] itemOverrides = ModAddonManager.getItemOverrides().toArray(new String[ModAddonManager.getItemOverrides().size()]);
    private boolean libraryShowsModelPreviews = ConfigHandler.libraryShowsModelPreviews;
    private boolean lockDyesOnSkins = ConfigHandler.lockDyesOnSkins;
    private boolean instancedDyeTable = ConfigHandler.instancedDyeTable;
    private boolean enableRecoveringSkins = ConfigHandler.enableRecoveringSkins;
    private UUID playerId;

    public MessageServerSyncConfig(EntityPlayer player) {
        this();
        this.playerId = player.func_110124_au();
    }

    public MessageServerSyncConfig() {
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.wardrobeAllowOpening);
        buf.writeBoolean(this.wardrobeTabSkins);
        buf.writeBoolean(this.wardrobeTabOutfits);
        buf.writeBoolean(this.wardrobeTabDisplaySettings);
        buf.writeBoolean(this.wardrobeTabColourSettings);
        buf.writeBoolean(this.wardrobeTabDyes);
        buf.writeBoolean(this.allowDownloadingSkins);
        buf.writeBoolean(this.allowUploadingSkins);
        ByteBufHelper.writeStringArrayToBuf(buf, this.itemOverrides);
        buf.writeBoolean(this.libraryShowsModelPreviews);
        buf.writeBoolean(this.lockDyesOnSkins);
        buf.writeBoolean(this.instancedDyeTable);
        buf.writeBoolean(this.enableRecoveringSkins);
        if (this.playerId == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            ByteBufHelper.writeUUID(buf, this.playerId);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.wardrobeAllowOpening = buf.readBoolean();
        this.wardrobeTabSkins = buf.readBoolean();
        this.wardrobeTabOutfits = buf.readBoolean();
        this.wardrobeTabDisplaySettings = buf.readBoolean();
        this.wardrobeTabColourSettings = buf.readBoolean();
        this.wardrobeTabDyes = buf.readBoolean();
        this.allowDownloadingSkins = buf.readBoolean();
        this.allowUploadingSkins = buf.readBoolean();
        this.itemOverrides = ByteBufHelper.readStringArrayFromBuf(buf);
        this.libraryShowsModelPreviews = buf.readBoolean();
        this.lockDyesOnSkins = buf.readBoolean();
        this.instancedDyeTable = buf.readBoolean();
        this.enableRecoveringSkins = buf.readBoolean();
        if (buf.readBoolean()) {
            this.playerId = ByteBufHelper.readUUID(buf);
        }
    }

    public IMessage onMessage(MessageServerSyncConfig message, MessageContext ctx) {
        this.setConfigsOnClient(message);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void setConfigsOnClient(MessageServerSyncConfig message) {
        ConfigHandler.wardrobeAllowOpening = message.wardrobeAllowOpening;
        ConfigHandler.wardrobeTabSkins = message.wardrobeTabSkins;
        ConfigHandler.wardrobeTabOutfits = message.wardrobeTabOutfits;
        ConfigHandler.wardrobeTabDisplaySettings = message.wardrobeTabDisplaySettings;
        ConfigHandler.wardrobeTabColourSettings = message.wardrobeTabColourSettings;
        ConfigHandler.wardrobeTabDyes = message.wardrobeTabDyes;
        ConfigHandler.allowDownloadingSkins = message.allowDownloadingSkins;
        ConfigHandler.allowUploadingSkins = message.allowUploadingSkins;
        ModAddonManager.setOverridesFromServer(message.itemOverrides);
        ConfigHandler.libraryShowsModelPreviews = message.libraryShowsModelPreviews;
        ConfigHandler.lockDyesOnSkins = message.lockDyesOnSkins;
        ConfigHandler.remotePlayerId = message.playerId;
        ConfigHandler.instancedDyeTable = message.instancedDyeTable;
        ConfigHandler.enableRecoveringSkins = message.enableRecoveringSkins;
    }
}

