/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.network.messages.server;

import io.netty.buffer.ByteBuf;
import moe.plushie.armourers_workshop.api.common.capability.IEntitySkinCapability;
import moe.plushie.armourers_workshop.common.capability.entityskin.EntitySkinCapability;
import moe.plushie.armourers_workshop.common.network.messages.client.DelayedMessageHandler;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class MessageServerSyncSkinCap
implements IMessage,
IMessageHandler<MessageServerSyncSkinCap, IMessage>,
DelayedMessageHandler.IDelayedMessage {
    private int entityId;
    private NBTTagCompound compound;

    public MessageServerSyncSkinCap(int entityId, NBTTagCompound compound) {
        this.entityId = entityId;
        this.compound = compound;
    }

    public MessageServerSyncSkinCap() {
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.compound);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.compound = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public IMessage onMessage(MessageServerSyncSkinCap message, MessageContext ctx) {
        DelayedMessageHandler.addDelayedMessage(message);
        return null;
    }

    @Override
    public boolean isReady() {
        return this.clientReady();
    }

    @SideOnly(value=Side.CLIENT)
    private boolean clientReady() {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            return Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityId) != null;
        }
        return false;
    }

    @Override
    public void onDelayedMessage() {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityId);
            if (entity != null) {
                IEntitySkinCapability skinCapability = EntitySkinCapability.get(entity);
                if (skinCapability != null) {
                    EntitySkinCapability.ENTITY_SKIN_CAP.getStorage().readNBT(EntitySkinCapability.ENTITY_SKIN_CAP, (Object)skinCapability, null, (NBTBase)this.compound);
                }
            } else {
                ModLogger.log(Level.WARN, String.format("Failed to get entity with %d when updating IEntitySkinCapability.", this.entityId));
            }
        }
    }
}

