/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.skin.cubes;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.common.skin.cubes.Cube;
import moe.plushie.armourers_workshop.common.skin.cubes.CubeGlass;
import moe.plushie.armourers_workshop.common.skin.cubes.CubeGlassGlowing;
import moe.plushie.armourers_workshop.common.skin.cubes.CubeGlowing;
import moe.plushie.armourers_workshop.common.skin.cubes.ICube;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.block.Block;

public final class CubeRegistry {
    public static CubeRegistry INSTANCE;
    private ArrayList<ICube> cubeList = new ArrayList();

    public static void init() {
        INSTANCE = new CubeRegistry();
        INSTANCE.registerCubes();
    }

    public ICube getCubeFormId(byte id) {
        if (id >= 0 && id < this.cubeList.size()) {
            return this.cubeList.get(id);
        }
        return null;
    }

    public byte getTotalCubes() {
        return (byte)this.cubeList.size();
    }

    private void registerCube(ICube cube) {
        this.cubeList.add(cube);
        ModLogger.log("Registering equipment cube - id:" + cube.getId() + " name:" + cube.getClass().getSimpleName());
    }

    public void registerCubes() {
        this.registerCube(new Cube());
        this.registerCube(new CubeGlowing());
        this.registerCube(new CubeGlass());
        this.registerCube(new CubeGlassGlowing());
    }

    public boolean isBuildingBlock(Block block) {
        for (int i = 0; i < this.cubeList.size(); ++i) {
            if (this.cubeList.get(i).getMinecraftBlock() != block) continue;
            return true;
        }
        return false;
    }

    public ICube getCubeFromBlock(Block block) {
        for (int i = 0; i < this.cubeList.size(); ++i) {
            if (this.cubeList.get(i).getMinecraftBlock() != block) continue;
            return this.cubeList.get(i);
        }
        return null;
    }
}

