/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.skin.type;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.IPoint3D;
import moe.plushie.armourers_workshop.api.common.IRectangle3D;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.api.common.skin.Point3D;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinProperties;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinPartType;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinPartTypeTextured;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.model.bake.ColouredFace;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.skin.cubes.CubeMarkerData;
import moe.plushie.armourers_workshop.common.skin.data.SkinCubeData;
import moe.plushie.armourers_workshop.common.skin.data.SkinPart;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractSkinPartTypeBase
implements ISkinPartType {
    private ISkinType baseType;
    protected IRectangle3D buildingSpace;
    protected IRectangle3D guideSpace;
    protected IPoint3D offset;

    public AbstractSkinPartTypeBase(ISkinType baseType) {
        this.baseType = baseType;
    }

    @Override
    public IRectangle3D getBuildingSpace() {
        return this.buildingSpace;
    }

    @Override
    public IRectangle3D getGuideSpace() {
        return this.guideSpace;
    }

    @Override
    public IPoint3D getOffset() {
        return this.offset;
    }

    @Override
    public String getRegistryName() {
        return this.baseType.getRegistryName() + "." + this.getPartName();
    }

    @Override
    public int getMinimumMarkersNeeded() {
        return 0;
    }

    @Override
    public int getMaximumMarkersNeeded() {
        return 0;
    }

    @Override
    public boolean isPartRequired() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IPoint3D getItemRenderOffset() {
        return new Point3D(0, 0, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRectangle3D getItemRenderTextureBounds() {
        return null;
    }

    @Override
    public boolean isModelOverridden(ISkinProperties skinProps) {
        return false;
    }

    @Override
    public boolean isOverlayOverridden(ISkinProperties skinProps) {
        return false;
    }

    @Override
    public SkinPart makeDummyPaintPart(int[] paintData) {
        if (!(this instanceof ISkinPartTypeTextured)) {
            return null;
        }
        BufferedImage image = new BufferedImage(64, 32, 2);
        for (int ix = 0; ix < 64; ++ix) {
            for (int iy = 0; iy < 32; ++iy) {
                int paintColour = paintData[ix + iy * 64];
                image.setRGB(ix, iy, paintColour);
            }
        }
        SkinCubeData cubeData = new SkinCubeData();
        cubeData.setCubeCount(this.guideSpace.getWidth() * this.guideSpace.getHeight() * this.guideSpace.getDepth());
        int i = 0;
        for (int ix = 0; ix < this.guideSpace.getWidth(); ++ix) {
            for (int iy = 0; iy < this.guideSpace.getHeight(); ++iy) {
                for (int iz = 0; iz < this.guideSpace.getDepth(); ++iz) {
                    byte x = (byte)(ix - this.guideSpace.getWidth() - this.guideSpace.getX());
                    byte y = (byte)(iy - this.guideSpace.getHeight() - this.guideSpace.getY());
                    byte z = (byte)(iz - this.guideSpace.getDepth() - this.guideSpace.getZ());
                    cubeData.setCubeLocation(i, x, y, z);
                    for (int side = 0; side < 6; ++side) {
                        byte[] rgbt = ColouredFace.getColourFromTexture(x, y, z, (byte)0, (byte)0, (byte)0, (byte)side, image, (ISkinPartTypeTextured)((Object)this), true);
                        cubeData.setCubeColour(i, side, rgbt[0], rgbt[1], rgbt[2]);
                        IPaintType paintType = PaintTypeRegistry.getInstance().getPaintTypeFormByte(rgbt[3]);
                        if (paintType == PaintTypeRegistry.PAINT_TYPE_NONE) {
                            paintType = PaintTypeRegistry.PAINT_TYPE_NONE;
                        }
                        cubeData.setCubePaintType(i, side, (byte)paintType.getId());
                    }
                    ++i;
                }
            }
        }
        return new SkinPart(cubeData, this, new ArrayList<CubeMarkerData>());
    }
}

