/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.tileentities.property;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.common.capability.wardrobe.ExtraColours;
import moe.plushie.armourers_workshop.common.data.type.BipedRotations;
import moe.plushie.armourers_workshop.common.data.type.TextureType;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityHologramProjector;
import moe.plushie.armourers_workshop.common.tileentities.property.TileProperty;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import org.apache.logging.log4j.Level;

public final class TilePropertyManager {
    public static TilePropertyManager INSTANCE = new TilePropertyManager();
    private final HashMap<String, ITypeSerializer<NBTTagCompound>> typeSerializers = new HashMap();

    private TilePropertyManager() {
        this.typeSerializers.put(Boolean.class.getName(), new BooleanSerializer());
        this.typeSerializers.put(Integer.class.getName(), new IntegerSerializer());
        this.typeSerializers.put(Float.class.getName(), new FloatSerializer());
        this.typeSerializers.put(String.class.getName(), new StringSerializer());
        this.typeSerializers.put(GameProfile.class.getName(), new GameProfileSerializer());
        this.typeSerializers.put(BipedRotations.class.getName(), new BipedRotationsSerializer());
        this.typeSerializers.put(ExtraColours.class.getName(), new ExtraColoursSerializer());
        this.typeSerializers.put(TextureType.class.getName(), new TextureTypeSerializer());
        this.typeSerializers.put(TileEntityHologramProjector.PowerMode.class.getName(), new PowerModeSerializer());
    }

    public NBTTagCompound writePropToCompound(TileProperty<?> tileProperty, NBTTagCompound compound) {
        if (tileProperty.get() != null) {
            String typeKey = tileProperty.getType().getName();
            ITypeSerializer<NBTTagCompound> serializer = this.typeSerializers.get(typeKey);
            if (serializer != null) {
                serializer.writeType(tileProperty, compound);
            } else {
                ModLogger.log(Level.ERROR, "Could not find TypeSerializer when writing for type: " + typeKey);
            }
        }
        return compound;
    }

    public void readPropFromCompound(TileProperty<?> tileProperty, NBTTagCompound compound) {
        String typeKey = tileProperty.getType().getName();
        ITypeSerializer<NBTTagCompound> serializer = this.typeSerializers.get(typeKey);
        if (serializer != null) {
            serializer.readType(tileProperty, compound);
        } else {
            ModLogger.log(Level.ERROR, "Could not find TypeSerializer when reading for type: " + typeKey);
        }
    }

    private static interface ITypeSerializer<TAR_TYPE> {
        public void readType(TileProperty<?> var1, TAR_TYPE var2);

        public void writeType(TileProperty<?> var1, TAR_TYPE var2);
    }

    private static class PowerModeSerializer
    implements ITypeSerializer<NBTTagCompound> {
        private PowerModeSerializer() {
        }

        @Override
        public void readType(TileProperty<?> tileProperty, NBTTagCompound source) {
            if (source.func_150297_b(tileProperty.getKey(), 8)) {
                try {
                    TileEntityHologramProjector.PowerMode pm = TileEntityHologramProjector.PowerMode.valueOf(source.func_74779_i(tileProperty.getKey()));
                    tileProperty.loadType((Object)pm);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void writeType(TileProperty<?> tileProperty, NBTTagCompound target) {
            TileEntityHologramProjector.PowerMode pm = (TileEntityHologramProjector.PowerMode)((Object)tileProperty.get());
            target.func_74778_a(tileProperty.getKey(), pm.name());
        }
    }

    private static class TextureTypeSerializer
    implements ITypeSerializer<NBTTagCompound> {
        private TextureTypeSerializer() {
        }

        @Override
        public void readType(TileProperty<?> tileProperty, NBTTagCompound source) {
            if (source.func_150297_b(tileProperty.getKey(), 8)) {
                try {
                    TextureType tt = TextureType.valueOf(source.func_74779_i(tileProperty.getKey()));
                    tileProperty.loadType((Object)tt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void writeType(TileProperty<?> tileProperty, NBTTagCompound target) {
            TextureType tt = (TextureType)((Object)tileProperty.get());
            target.func_74778_a(tileProperty.getKey(), tt.name());
        }
    }

    private static class ExtraColoursSerializer
    implements ITypeSerializer<NBTTagCompound> {
        private ExtraColoursSerializer() {
        }

        @Override
        public void readType(TileProperty<?> tileProperty, NBTTagCompound source) {
            if (source.func_150297_b(tileProperty.getKey(), 10)) {
                NBTTagCompound compound = source.func_74775_l(tileProperty.getKey());
                ExtraColours extraColours = (ExtraColours)tileProperty.get();
                for (IExtraColours.ExtraColourType colourType : IExtraColours.ExtraColourType.values()) {
                    extraColours.setColour(colourType, compound.func_74762_e(colourType.name().toLowerCase()));
                }
            }
        }

        @Override
        public void writeType(TileProperty<?> tileProperty, NBTTagCompound target) {
            NBTTagCompound compound = new NBTTagCompound();
            ExtraColours extraColours = (ExtraColours)tileProperty.get();
            for (IExtraColours.ExtraColourType colourType : IExtraColours.ExtraColourType.values()) {
                compound.func_74768_a(colourType.name().toLowerCase(), extraColours.getColour(colourType));
            }
            target.func_74782_a(tileProperty.getKey(), (NBTBase)compound);
        }
    }

    private static class BipedRotationsSerializer
    implements ITypeSerializer<NBTTagCompound> {
        private BipedRotationsSerializer() {
        }

        @Override
        public void readType(TileProperty<?> tileProperty, NBTTagCompound source) {
            if (source.func_150297_b(tileProperty.getKey(), 10)) {
                BipedRotations rotations = (BipedRotations)tileProperty.get();
                rotations.loadNBTData(source.func_74775_l(tileProperty.getKey()));
            }
        }

        @Override
        public void writeType(TileProperty<?> tileProperty, NBTTagCompound target) {
            BipedRotations rotations = (BipedRotations)tileProperty.get();
            target.func_74782_a(tileProperty.getKey(), (NBTBase)rotations.saveNBTData(new NBTTagCompound()));
        }
    }

    private static class GameProfileSerializer
    implements ITypeSerializer<NBTTagCompound> {
        private GameProfileSerializer() {
        }

        @Override
        public void readType(TileProperty<?> tileProperty, NBTTagCompound source) {
            if (source.func_150297_b(tileProperty.getKey(), 10)) {
                GameProfile gameProfile = NBTUtil.func_152459_a((NBTTagCompound)source.func_74775_l(tileProperty.getKey()));
                tileProperty.loadType(gameProfile);
            }
        }

        @Override
        public void writeType(TileProperty<?> tileProperty, NBTTagCompound target) {
            NBTTagCompound compound = NBTUtil.func_180708_a((NBTTagCompound)new NBTTagCompound(), (GameProfile)((GameProfile)tileProperty.get()));
            target.func_74782_a(tileProperty.getKey(), (NBTBase)compound);
        }
    }

    private static class StringSerializer
    implements ITypeSerializer<NBTTagCompound> {
        private StringSerializer() {
        }

        @Override
        public void readType(TileProperty<?> tileProperty, NBTTagCompound source) {
            if (source.func_150297_b(tileProperty.getKey(), 8)) {
                tileProperty.loadType(source.func_74779_i(tileProperty.getKey()));
            }
        }

        @Override
        public void writeType(TileProperty<?> tileProperty, NBTTagCompound target) {
            target.func_74778_a(tileProperty.getKey(), (String)tileProperty.get());
        }
    }

    private static class FloatSerializer
    implements ITypeSerializer<NBTTagCompound> {
        private FloatSerializer() {
        }

        @Override
        public void readType(TileProperty<?> tileProperty, NBTTagCompound source) {
            if (source.func_150297_b(tileProperty.getKey(), 5)) {
                tileProperty.loadType(Float.valueOf(source.func_74760_g(tileProperty.getKey())));
            }
        }

        @Override
        public void writeType(TileProperty<?> tileProperty, NBTTagCompound target) {
            target.func_74776_a(tileProperty.getKey(), ((Float)tileProperty.get()).floatValue());
        }
    }

    private static class IntegerSerializer
    implements ITypeSerializer<NBTTagCompound> {
        private IntegerSerializer() {
        }

        @Override
        public void readType(TileProperty<?> tileProperty, NBTTagCompound source) {
            if (source.func_150297_b(tileProperty.getKey(), 3)) {
                tileProperty.loadType(source.func_74762_e(tileProperty.getKey()));
            }
        }

        @Override
        public void writeType(TileProperty<?> tileProperty, NBTTagCompound target) {
            target.func_74768_a(tileProperty.getKey(), ((Integer)tileProperty.get()).intValue());
        }
    }

    private static class BooleanSerializer
    implements ITypeSerializer<NBTTagCompound> {
        private BooleanSerializer() {
        }

        @Override
        public void readType(TileProperty<?> tileProperty, NBTTagCompound source) {
            if (source.func_150297_b(tileProperty.getKey(), 1)) {
                tileProperty.loadType(source.func_74767_n(tileProperty.getKey()));
            }
        }

        @Override
        public void writeType(TileProperty<?> tileProperty, NBTTagCompound target) {
            target.func_74757_a(tileProperty.getKey(), ((Boolean)tileProperty.get()).booleanValue());
        }
    }
}

