/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import moe.plushie.armourers_workshop.api.common.ISkinNBTUtils;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDescriptor;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SkinNBTUtils
implements ISkinNBTUtils {
    public static final SkinNBTUtils INSTANCE = new SkinNBTUtils();

    private SkinNBTUtils() {
    }

    @Override
    public void setSkinDescriptor(ItemStack itemStack, ISkinDescriptor skinDescriptor) {
        if (itemStack.func_190926_b() | skinDescriptor == null) {
            return;
        }
        SkinNBTHelper.addSkinDataToStack(itemStack, (SkinDescriptor)skinDescriptor);
    }

    @Override
    public ISkinDescriptor getSkinDescriptor(ItemStack itemStack) {
        if (!itemStack.func_190926_b()) {
            return SkinNBTHelper.getSkinDescriptorFromStack(itemStack);
        }
        return null;
    }

    @Override
    public void removeSkinDescriptor(ItemStack itemStack) {
        if (!itemStack.func_190926_b()) {
            SkinNBTHelper.removeSkinDataFromStack(itemStack);
        }
    }

    @Override
    public boolean hasSkinDescriptor(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        return SkinNBTHelper.stackHasSkinData(itemStack);
    }

    @Override
    public void setSkinDescriptor(NBTTagCompound compound, ISkinDescriptor skinDescriptor) {
        if (compound.func_82582_d() | skinDescriptor == null) {
            return;
        }
        SkinNBTHelper.addSkinDataToStack(compound, (SkinDescriptor)skinDescriptor);
    }

    @Override
    public ISkinDescriptor getSkinDescriptor(NBTTagCompound compound) {
        if (compound == null) {
            return null;
        }
        return SkinNBTHelper.getSkinDescriptork(compound);
    }

    @Override
    public void removeSkinDescriptor(NBTTagCompound compound) {
        if (compound == null) {
            return;
        }
        SkinNBTHelper.removeSkinData(compound);
    }

    @Override
    public boolean hasSkinDescriptor(NBTTagCompound compound) {
        if (compound != null) {
            return SkinNBTHelper.compoundHasSkinData(compound);
        }
        return false;
    }
}

