/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.asm;

import net.teamfruit.emojicord.asm.ASMDeobfNames;
import net.teamfruit.emojicord.asm.lib.ASMValidate;
import net.teamfruit.emojicord.asm.lib.ClassName;
import net.teamfruit.emojicord.asm.lib.DescHelper;
import net.teamfruit.emojicord.asm.lib.INodeTreeTransformer;
import net.teamfruit.emojicord.asm.lib.MethodMatcher;
import net.teamfruit.emojicord.asm.lib.VisitorHelper;
import net.teamfruit.emojicord.compat.CompatBaseVersion;
import net.teamfruit.emojicord.compat.CompatVersion;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class GuiScreenInputEventTransform
implements INodeTreeTransformer {
    @Override
    public ClassName getClassName() {
        if (CompatVersion.version().older(CompatBaseVersion.V13)) {
            return ClassName.of("net.minecraft.client.gui.GuiScreen");
        }
        return ClassName.of("net.minecraft.client.gui.screen.Screen");
    }

    @Override
    public ClassNode apply(ClassNode node) {
        ASMValidate validator = ASMValidate.create(this.getSimpleName());
        validator.test("handleInput", CompatVersion.version().older(CompatBaseVersion.V7));
        validator.test("handleInput.onMouseInput", CompatVersion.version().older(CompatBaseVersion.V7));
        validator.test("handleInput.onKeyboardInput", CompatVersion.version().older(CompatBaseVersion.V7));
        if (CompatVersion.version().older(CompatBaseVersion.V7)) {
            MethodMatcher matcher = new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Void.TYPE, new Object[0]), ASMDeobfNames.GuiScreenHandleInput);
            node.methods.stream().filter(matcher).forEach(method -> {
                MethodMatcher matcher0 = new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Void.TYPE, new Object[0]), ASMDeobfNames.GuiScreenHandleMouseInput);
                VisitorHelper.stream(method.instructions).filter(matcher0.insnMatcher()).forEach(marker -> {
                    LabelNode label = new LabelNode();
                    InsnList insertion = new InsnList();
                    insertion.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    insertion.add((AbstractInsnNode)new MethodInsnNode(184, ClassName.of("net.teamfruit.emojicord.compat.MouseInputEvent$Pre").getBytecodeName(), "onMouseInput", DescHelper.toDescMethod(Boolean.TYPE, this.getClassName()), false));
                    insertion.add((AbstractInsnNode)new JumpInsnNode(154, label));
                    method.instructions.insertBefore(marker.getPrevious(), insertion);
                    insertion = new InsnList();
                    insertion.add((AbstractInsnNode)label);
                    method.instructions.insert(marker, insertion);
                    validator.check("handleInput.onMouseInput");
                });
                matcher0 = new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Void.TYPE, new Object[0]), ASMDeobfNames.GuiScreenHandleKeyboardInput);
                VisitorHelper.stream(method.instructions).filter(matcher0.insnMatcher()).forEach(marker -> {
                    LabelNode label = new LabelNode();
                    InsnList insertion = new InsnList();
                    insertion.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    insertion.add((AbstractInsnNode)new MethodInsnNode(184, ClassName.of("net.teamfruit.emojicord.compat.KeyboardInputEvent$Pre").getBytecodeName(), "onKeyboardInput", DescHelper.toDescMethod(Boolean.TYPE, this.getClassName()), false));
                    insertion.add((AbstractInsnNode)new JumpInsnNode(154, label));
                    method.instructions.insertBefore(marker.getPrevious(), insertion);
                    insertion = new InsnList();
                    insertion.add((AbstractInsnNode)label);
                    method.instructions.insert(marker, insertion);
                    validator.check("handleInput.onKeyboardInput");
                });
                validator.check("handleInput");
            });
        }
        validator.validate();
        return node;
    }
}

