/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.emoji;

import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.teamfruit.emojicord.Locations;
import net.teamfruit.emojicord.emoji.StandardEmojiIdDictionary;
import net.teamfruit.emojicord.util.Base64Utils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class EmojiId {
    public final EmojiIdNode node = new EmojiIdNode();

    public abstract String getId();

    public abstract String getType();

    public File getCache() {
        return new File(Locations.instance.getCacheDirectory(), String.format("%s/%s", this.getType(), this.getCacheName()));
    }

    public abstract String getRemote();

    public String getCacheName() {
        return this.getId();
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("emojicord", String.format("textures/emojis/%s/%s", this.getType(), this.getCacheName()));
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getType());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmojiId)) {
            return false;
        }
        EmojiId other = (EmojiId)obj;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getType(), other.getType());
    }

    public String toString() {
        return "EmojiId [id=" + this.getId() + ", type=" + this.getType() + "]";
    }

    public static class DiscordEmojiId
    extends EmojiId {
        private final long id;

        private DiscordEmojiId(long id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return Long.toString(this.id);
        }

        @Override
        public String getType() {
            return "discord";
        }

        @Override
        public String getRemote() {
            return "https://cdn.discordapp.com/emojis/" + this.getId();
        }

        public String getEncodedId() {
            return Base64Utils.encode(this.id);
        }

        @Nullable
        public static EmojiId fromDecimalId(long id) {
            return new DiscordEmojiId(id);
        }

        @Nullable
        public static EmojiId fromDecimalId(String id) {
            if (!NumberUtils.isDigits((String)id)) {
                return null;
            }
            return DiscordEmojiId.fromDecimalId(NumberUtils.toLong((String)id));
        }

        @Nullable
        public static EmojiId fromEncodedId(String id) {
            try {
                return new DiscordEmojiId(Base64Utils.decode(id));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }

    public static class StandardEmojiId
    extends EmojiId {
        private final String url;
        private final String cache;

        public StandardEmojiId(String url, String cache) {
            this.url = url;
            this.cache = cache;
        }

        @Override
        public String getId() {
            return this.url;
        }

        @Override
        public String getCacheName() {
            return StringUtils.replace((String)this.cache, (String)":", (String)".");
        }

        @Override
        public String getType() {
            return "standard";
        }

        @Override
        public String getRemote() {
            return this.getId();
        }

        @Nullable
        public static EmojiId fromAlias(String id) {
            return (EmojiId)StandardEmojiIdDictionary.instance.aliasDictionary.get((Object)id);
        }

        @Nullable
        public static EmojiId fromUtf(String surrogates) {
            return (EmojiId)StandardEmojiIdDictionary.instance.utfDictionary.get((Object)surrogates);
        }
    }

    public static class Node<T> {
        public final T value;
        public Node<T> prev;

        public Node(T value) {
            this.value = value;
        }

        public void linkPrev(Node<T> insert) {
            this.prev = insert;
        }

        public int countPrev() {
            int count = 0;
            if (this.prev != null) {
                Node<T> i = this;
                while (i.prev != null) {
                    ++count;
                    i = i.prev;
                }
            }
            return count;
        }
    }

    public class EmojiIdNode
    extends Node<EmojiId> {
        public EmojiIdNode() {
            super(EmojiId.this);
        }

        public String getUniqueName(String name) {
            int count = this.countPrev();
            if (count > 0) {
                return name + "~" + count;
            }
            return name;
        }
    }
}

