/*
 * Decompiled with CFR 0.152.
 */
package com.driga.jmodelloader.obj.armor;

import com.driga.jmodelloader.obj.armor.ItemCustomArmor;
import com.driga.jmodelloader.obj.armor.model.ArmorBinding;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum ArmorRegistry {
    Instance;

    private static final Logger log;
    private final Map<String, ItemArmor.ArmorMaterial> armorMaterialMap = new HashMap<String, ItemArmor.ArmorMaterial>();
    private final Map<String, ItemCustomArmor> armorMap = new HashMap<String, ItemCustomArmor>();
    private final Map<String, ArmorBinding> bindingMap = new HashMap<String, ArmorBinding>();

    public void registerAll(IForgeRegistry<Item> registry) {
        for (Map.Entry<String, ItemCustomArmor> entry : this.armorMap.entrySet()) {
            String s = entry.getKey();
            ItemCustomArmor itemCustomArmor = entry.getValue();
            registry.register((IForgeRegistryEntry)itemCustomArmor);
        }
    }

    public void registerAllModels() {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            for (String binding : this.bindingMap.keySet()) {
                ItemCustomArmor customArmor = this.armorMap.get(binding);
                customArmor.setArmorBinding(this.bindingMap.get(binding));
            }
        }
    }

    public void registerNewArmor(String name, ItemCustomArmor itemCustomArmor) {
        this.armorMap.put(name, itemCustomArmor);
    }

    public void registerModel(String name, ArmorBinding armorBinding) {
        this.bindingMap.put(name, armorBinding);
    }

    public Map<String, ItemArmor.ArmorMaterial> getArmorMaterialMap() {
        return this.armorMaterialMap;
    }

    public Map<String, ItemCustomArmor> getArmorMap() {
        return this.armorMap;
    }

    public Map<String, ArmorBinding> getBindingMap() {
        return this.bindingMap;
    }

    static {
        log = LogManager.getLogger(ArmorRegistry.class);
    }
}

