/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.wardrobe.tab;

import java.awt.Color;
import java.awt.image.BufferedImage;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.api.common.capability.IEntitySkinCapability;
import moe.plushie.armourers_workshop.api.common.capability.IWardrobeCap;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiIconButton;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTabPanel;
import moe.plushie.armourers_workshop.client.gui.style.GuiResourceManager;
import moe.plushie.armourers_workshop.client.gui.style.GuiStyle;
import moe.plushie.armourers_workshop.client.gui.wardrobe.GuiWardrobe;
import moe.plushie.armourers_workshop.client.render.ModRenderHelper;
import moe.plushie.armourers_workshop.common.TextureHelper;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.painting.PaintingHelper;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTabWardrobeColourSettings
extends GuiTabPanel {
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("armourers_workshop:textures/gui/wardrobe/wardrobe-1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("armourers_workshop:textures/gui/wardrobe/wardrobe-2.png");
    private static final ResourceLocation GUI_JSON = new ResourceLocation("armourers_workshop:gui/wardrobe.json");
    private static final ResourceLocation TEXTURE_BUTTONS = new ResourceLocation("armourers_workshop:textures/gui/_controls/buttons.png");
    private final GuiStyle guiStyle;
    private EntityPlayer entityPlayer;
    private IEntitySkinCapability skinCapability;
    private IWardrobeCap wardrobeCapability;
    private IExtraColours.ExtraColourType selectingColourType = null;
    private Color selectingColour = null;
    private int colourPadding = 29;
    private IExtraColours.ExtraColourType[] coloursLeft = new IExtraColours.ExtraColourType[]{IExtraColours.ExtraColourType.SKIN, IExtraColours.ExtraColourType.HAIR, IExtraColours.ExtraColourType.EYE};
    private IExtraColours.ExtraColourType[] coloursRight = new IExtraColours.ExtraColourType[]{IExtraColours.ExtraColourType.MISC_1, IExtraColours.ExtraColourType.MISC_2, IExtraColours.ExtraColourType.MISC_3, IExtraColours.ExtraColourType.MISC_4};
    private Color[] colours;
    private GuiIconButton[] buttonsSelect;
    private GuiIconButton[] buttonsClear;
    private GuiIconButton[] buttonsAuto;
    String guiName = "wardrobe.tab.colour_settings";

    public GuiTabWardrobeColourSettings(int tabId, GuiScreen parent, EntityPlayer entityPlayer, IEntitySkinCapability skinCapability, IWardrobeCap wardrobeCapability) {
        super(tabId, parent, false);
        this.guiStyle = GuiResourceManager.getGuiJsonInfo(GUI_JSON);
        this.entityPlayer = entityPlayer;
        this.skinCapability = skinCapability;
        this.wardrobeCapability = wardrobeCapability;
        this.getColours();
    }

    @Override
    public void initGui(int xPos, int yPos, int width, int height) {
        int i;
        super.initGui(xPos, yPos, width, height);
        this.buttonsSelect = new GuiIconButton[this.coloursLeft.length + this.coloursRight.length];
        this.buttonsClear = new GuiIconButton[this.coloursLeft.length + this.coloursRight.length];
        this.buttonsAuto = new GuiIconButton[3];
        for (i = 0; i < this.buttonsSelect.length; ++i) {
            this.buttonsSelect[i] = i < this.coloursLeft.length ? new GuiIconButton(this.parent, 0, 98, 35 + i * this.colourPadding, 16, 16, TEXTURE_BUTTONS) : new GuiIconButton(this.parent, 0, 193, 35 + i * this.colourPadding - this.coloursLeft.length * this.colourPadding, 16, 16, TEXTURE_BUTTONS);
            this.buttonsSelect[i].setHoverText(GuiHelper.getLocalizedControlName(this.guiName, "button." + IExtraColours.ExtraColourType.values()[i].toString().toLowerCase() + ".select", new Object[0]));
            this.buttonsSelect[i].setIconLocation(144, 192, 16, 16).setDrawButtonBackground(false);
            this.buttonList.add(this.buttonsSelect[i]);
        }
        for (i = 0; i < this.buttonsClear.length; ++i) {
            this.buttonsClear[i] = i < this.coloursLeft.length ? new GuiIconButton(this.parent, 0, 115, 35 + i * this.colourPadding, 16, 16, TEXTURE_BUTTONS) : new GuiIconButton(this.parent, 0, 210, 35 + i * this.colourPadding - this.coloursLeft.length * this.colourPadding, 16, 16, TEXTURE_BUTTONS);
            this.buttonsClear[i].setHoverText(GuiHelper.getLocalizedControlName(this.guiName, "button." + IExtraColours.ExtraColourType.values()[i].toString().toLowerCase() + ".clear", new Object[0]));
            this.buttonsClear[i].setIconLocation(208, 160, 16, 16).setDrawButtonBackground(false);
            this.buttonList.add(this.buttonsClear[i]);
        }
        for (i = 0; i < this.buttonsAuto.length; ++i) {
            this.buttonsAuto[i] = i < this.coloursLeft.length ? new GuiIconButton(this.parent, 0, 132, 35 + i * this.colourPadding, 16, 16, TEXTURE_BUTTONS) : new GuiIconButton(this.parent, 0, 227, 35 + i * this.colourPadding - this.coloursLeft.length * this.colourPadding, 16, 16, TEXTURE_BUTTONS);
            this.buttonsAuto[i].setHoverText(GuiHelper.getLocalizedControlName(this.guiName, "button." + IExtraColours.ExtraColourType.values()[i].toString().toLowerCase() + ".auto", new Object[0]));
            this.buttonsAuto[i].setIconLocation(144, 208, 16, 16).setDrawButtonBackground(false);
            this.buttonList.add(this.buttonsAuto[i]);
        }
    }

    private void getColours() {
        IExtraColours extraColours = this.wardrobeCapability.getExtraColours();
        this.colours = new Color[IExtraColours.ExtraColourType.values().length];
        for (int i = 0; i < this.colours.length; ++i) {
            this.colours[i] = new Color(extraColours.getColour(IExtraColours.ExtraColourType.values()[i]), true);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (button == 0 & this.selectingColourType != null) {
            byte[] newColour = PaintingHelper.intToBytes(this.selectingColour.getRGB());
            newColour[3] = (byte)PaintTypeRegistry.PAINT_TYPE_NORMAL.getId();
            this.wardrobeCapability.getExtraColours().setColourBytes(this.selectingColourType, newColour);
            this.wardrobeCapability.sendUpdateToServer();
            this.selectingColourType = null;
            for (int i = 0; i < this.buttonsSelect.length; ++i) {
                this.buttonsSelect[i].setPressed(false);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        int i;
        for (i = 0; i < this.buttonsSelect.length; ++i) {
            if (button != this.buttonsSelect[i]) continue;
            this.selectingColourType = IExtraColours.ExtraColourType.values()[i];
            this.buttonsSelect[i].setPressed(true);
        }
        for (i = 0; i < this.buttonsAuto.length; ++i) {
            if (button != this.buttonsAuto[i]) continue;
            int newColour = this.autoColour((AbstractClientPlayer)this.entityPlayer, IExtraColours.ExtraColourType.values()[i]);
            this.wardrobeCapability.getExtraColours().setColour(IExtraColours.ExtraColourType.values()[i], newColour);
            this.wardrobeCapability.sendUpdateToServer();
        }
        for (i = 0; i < this.buttonsClear.length; ++i) {
            if (button != this.buttonsClear[i]) continue;
            this.wardrobeCapability.getExtraColours().setColour(IExtraColours.ExtraColourType.values()[i], 0);
        }
    }

    @Override
    public void drawBackgroundLayer(float partialTickTime, int mouseX, int mouseY) {
        int i;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (i = 0; i < this.coloursLeft.length; ++i) {
            this.drawColourDisplay(83, 36 + this.colourPadding * i, this.colours[i]);
        }
        for (i = 0; i < this.coloursRight.length; ++i) {
            this.drawColourDisplay(178, 36 + this.colourPadding * i, this.colours[i + this.coloursLeft.length]);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.field_71446_o.func_110577_a(TEXTURE_1);
        this.func_73729_b(this.x, this.y + 152, 0, 152, 256, 98);
        this.mc.field_71446_o.func_110577_a(TEXTURE_2);
        this.func_73729_b(this.x + 256, this.y + 152, 0, 152, 22, 98);
    }

    private void drawColourDisplay(int x, int y, Color colour) {
        float r = (float)colour.getRed() / 255.0f;
        float g = (float)colour.getGreen() / 255.0f;
        float b = (float)colour.getBlue() / 255.0f;
        float t = (float)colour.getAlpha() / 255.0f;
        this.drawColourDisplay(x, y, r, g, b, t);
    }

    private void drawColourDisplay(int x, int y, float r, float g, float b, float t) {
        if (t != 0.0f) {
            this.func_73729_b(this.x + x, this.y + y, 242, 180, 14, 14);
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
            this.func_73729_b(this.x + x + 1, this.y + y + 1, 243, 181, 12, 12);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            this.func_73729_b(this.x + x, this.y + y, 242, 166, 14, 14);
        }
    }

    @Override
    public void drawForegroundLayer(int mouseX, int mouseY, float partialTickTime) {
        int i;
        super.drawForegroundLayer(mouseX, mouseY, partialTickTime);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179117_G();
        for (i = 0; i < this.coloursLeft.length; ++i) {
            this.fontRenderer.func_78276_b(GuiHelper.getLocalizedControlName(this.guiName, "label." + this.coloursLeft[i].toString().toLowerCase(), new Object[0]), 83, 26 + i * this.colourPadding, this.guiStyle.getColour("text"));
        }
        for (i = 0; i < this.coloursRight.length; ++i) {
            this.fontRenderer.func_78276_b(GuiHelper.getLocalizedControlName(this.guiName, "label." + this.coloursRight[i].toString().toLowerCase(), new Object[0]), 178, 26 + i * this.colourPadding, this.guiStyle.getColour("text"));
        }
        this.fontRenderer.func_78276_b(GuiHelper.getLocalizedControlName(this.guiName, "label.palette", new Object[0]), 6, 157, this.guiStyle.getColour("text"));
        this.getColours();
        if (this.selectingColour != null & this.selectingColourType != null) {
            this.colours[this.selectingColourType.ordinal()] = this.selectingColour;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-this.x), (double)(-this.y), (double)0.0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ModRenderHelper.enableAlphaBlend();
        if (this.selectingColourType != null) {
            this.selectingColour = ((GuiWardrobe)this.parent).drawPlayerPreview(this.x, this.y, mouseX, mouseY, true);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ModRenderHelper.enableAlphaBlend();
            ((GuiWardrobe)this.parent).drawPlayerPreview(this.x, this.y, mouseX, mouseY, false);
        }
        GL11.glPopMatrix();
        for (i = 0; i < this.buttonList.size(); ++i) {
            GuiButton button = (GuiButton)this.buttonList.get(i);
            if (!(button instanceof GuiIconButton)) continue;
            ((GuiIconButton)button).drawRollover(this.mc, mouseX - this.x, mouseY - this.y);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public int autoColour(AbstractClientPlayer player, IExtraColours.ExtraColourType type) {
        Color c;
        int iy;
        int ix;
        BufferedImage playerTexture = TextureHelper.getBufferedImageSkin(player);
        if (playerTexture == null) {
            return 0;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        if (type == IExtraColours.ExtraColourType.SKIN) {
            for (ix = 0; ix < 2; ++ix) {
                for (iy = 0; iy < 1; ++iy) {
                    c = new Color(playerTexture.getRGB(ix + 11, iy + 13));
                    r += c.getRed();
                    g += c.getGreen();
                    b += c.getBlue();
                }
            }
            r /= 2;
            g /= 2;
            b /= 2;
        }
        if (type == IExtraColours.ExtraColourType.HAIR) {
            for (ix = 0; ix < 2; ++ix) {
                for (iy = 0; iy < 1; ++iy) {
                    c = new Color(playerTexture.getRGB(ix + 11, iy + 3));
                    r += c.getRed();
                    g += c.getGreen();
                    b += c.getBlue();
                }
            }
            r /= 2;
            g /= 2;
            b /= 2;
        }
        if (type == IExtraColours.ExtraColourType.EYE) {
            Color c1 = new Color(playerTexture.getRGB(10, 13));
            Color c2 = new Color(playerTexture.getRGB(13, 13));
            r += c1.getRed();
            g += c1.getGreen();
            b += c1.getBlue();
            r += c2.getRed();
            g += c2.getGreen();
            b += c2.getBlue();
            r /= 2;
            g /= 2;
            b /= 2;
        }
        return new Color(r, g, b).getRGB();
    }
}

