/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.guidebook;

import moe.plushie.armourers_workshop.client.guidebook.IBook;
import moe.plushie.armourers_workshop.client.guidebook.IBookPage;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class BookPageBase
implements IBookPage {
    protected static final ResourceLocation bookPageTexture = new ResourceLocation("armourers_workshop:textures/gui/guide_book/guide-book-page.png");
    protected static final int TEXT_COLOUR = -16777216;
    public static final int PAGE_TEXTURE_WIDTH = 118;
    public static final int PAGE_TEXTURE_HEIGHT = 165;
    public static final int PAGE_MARGIN_LEFT = 10;
    public static final int PAGE_MARGIN_TOP = 7;
    protected static final int PAGE_PADDING_LEFT = 5;
    protected static final int PAGE_PADDING_TOP = 5;
    protected final IBook parentBook;

    public BookPageBase(IBook parentBook) {
        this.parentBook = parentBook;
    }

    protected void renderStringCenter(FontRenderer fontRenderer, String text, int y) {
        int contentWidth = 59;
        int stringWidth = fontRenderer.func_78256_a(text) / 2;
        int xCenter = 52 - fontRenderer.func_78256_a(text) / 2;
        fontRenderer.func_78279_b(text, contentWidth - stringWidth, y, 118, -14013910);
    }

    protected void drawPageTitleAndNumber(FontRenderer fontRenderer, int pageNumber) {
        String chapterTitle = this.parentBook.getChapterFromPageNumber(pageNumber).getUnlocalizedName();
        chapterTitle = I18n.func_135052_a((String)(chapterTitle + ".name"), (Object[])new Object[0]);
        this.renderStringCenter(fontRenderer, chapterTitle, 5);
        this.renderStringCenter(fontRenderer, pageNumber + " - " + this.parentBook.getTotalNumberOfPages(), 160 - fontRenderer.field_78288_b);
    }

    protected void drawTestRec(int x, int y, int width, int height) {
        double zLevel = 0.0;
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderTestRec(int x, int y, int width, int height, float r, float g, float b) {
        double zLevel = 0.0;
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }
}

