/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.addons;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.api.common.capability.IWardrobeCap;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDescriptor;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.client.render.SkinModelRenderHelper;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.common.addons.ModAddon;
import moe.plushie.armourers_workshop.common.capability.entityskin.EntitySkinCapability;
import moe.plushie.armourers_workshop.common.capability.wardrobe.ExtraColours;
import moe.plushie.armourers_workshop.common.capability.wardrobe.WardrobeCap;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDye;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.skin.entity.SkinnableEntity;
import moe.plushie.armourers_workshop.common.skin.entity.SkinnableEntityRegisty;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelHumanoidHead;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.ModelSkeletonHead;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class AddonHauntedAstolfoBeanPlushie
extends ModAddon {
    private static final String ENTITY_CLASS_NAME = "moriyashiine.hauntedastolfobeanplushie.entity.EntityHauntedAstolfoBeanPlushie";

    public AddonHauntedAstolfoBeanPlushie() {
        super("hauntedastolfobeanplushie", "Haunted Astolfo Bean Plushie");
    }

    @Override
    public void init() {
        ModLogger.log("Haunted Astolfo Bean Plushie mod detected! - Applying bulge to mannequins.");
        SkinnableEntityRegisty.INSTANCE.registerEntity(new SkinnableEntityCustomEntity());
    }

    @SideOnly(value=Side.CLIENT)
    public static class SkinLayerRendererBeanPlushie
    implements LayerRenderer {
        private final Class<? extends EntityLivingBase> entityClass;
        private final RenderLivingBase renderLivingBase;
        private ModelRenderer head = null;
        private ModelRenderer headwear = null;

        public SkinLayerRendererBeanPlushie(Class<? extends EntityLivingBase> entityClass, RenderLivingBase renderLivingBase) {
            this.entityClass = entityClass;
            this.renderLivingBase = renderLivingBase;
            try {
                ModelHumanoidHead modelHead = (ModelHumanoidHead)renderLivingBase.func_177087_b();
                this.head = (ModelRenderer)ReflectionHelper.getPrivateValue(ModelSkeletonHead.class, (Object)modelHead, (String[])new String[]{"field_82896_a", "skeletonHead"});
                this.headwear = (ModelRenderer)ReflectionHelper.getPrivateValue(ModelHumanoidHead.class, (Object)modelHead, (String[])new String[]{"field_178717_b", "head"});
            }
            catch (Exception e) {
                ModLogger.log(Level.WARN, "Failed to get model parts for moriyashiine.hauntedastolfobeanplushie.entity.EntityHauntedAstolfoBeanPlushie");
                e.printStackTrace();
            }
            if (this.head != null & this.headwear != null) {
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public void onRenderLivingPre(RenderLivingEvent.Pre event) {
            if (!event.getEntity().getClass().equals(this.entityClass)) {
                return;
            }
            EntitySkinCapability skinCapability = (EntitySkinCapability)EntitySkinCapability.get((Entity)event.getEntity());
            if (skinCapability == null) {
                return;
            }
            if (skinCapability.hideHead) {
                this.head.field_78807_k = true;
            }
            if (skinCapability.hideHead | skinCapability.hideHeadOverlay) {
                this.headwear.field_78807_k = true;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public void onRenderLivingPost(RenderLivingEvent.Post event) {
            if (!event.getEntity().getClass().equals(this.entityClass)) {
                return;
            }
            this.head.field_78807_k = false;
            this.headwear.field_78807_k = false;
        }

        public void func_177141_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            EntitySkinCapability skinCapability = (EntitySkinCapability)EntitySkinCapability.get((Entity)entitylivingbaseIn);
            if (skinCapability == null) {
                return;
            }
            skinCapability.hideHead = false;
            double distance = Minecraft.func_71410_x().field_71439_g.func_70011_f(entitylivingbaseIn.field_70165_t, entitylivingbaseIn.field_70163_u, entitylivingbaseIn.field_70161_v);
            if (distance > (double)ConfigHandlerClient.renderDistanceSkin) {
                return;
            }
            ISkinType[] skinTypes = skinCapability.getValidSkinTypes();
            SkinModelRenderHelper modelRenderer = SkinModelRenderHelper.INSTANCE;
            IExtraColours extraColours = ExtraColours.EMPTY_COLOUR;
            IWardrobeCap wardrobe = WardrobeCap.get((Entity)entitylivingbaseIn);
            if (wardrobe != null) {
                extraColours = wardrobe.getExtraColours();
            }
            GlStateManager.func_179091_B();
            for (int i = 0; i < skinTypes.length; ++i) {
                ISkinType skinType = skinTypes[i];
                for (int skinIndex = 0; skinIndex < skinCapability.getSlotCountForSkinType(skinType); ++skinIndex) {
                    Skin skin;
                    ISkinDescriptor skinDescriptor = skinCapability.getSkinDescriptor(skinType, skinIndex);
                    if (skinDescriptor == null || (skin = ClientSkinCache.INSTANCE.getSkin(skinDescriptor)) == null) continue;
                    if (SkinProperties.PROP_MODEL_OVERRIDE_HEAD.getValue(skin.getProperties()).booleanValue()) {
                        skinCapability.hideHead = true;
                    }
                    if (SkinProperties.PROP_MODEL_HIDE_OVERLAY_HEAD.getValue(skin.getProperties()).booleanValue()) {
                        skinCapability.hideHeadOverlay = true;
                    }
                    SkinDye dye = new SkinDye(wardrobe.getDye());
                    for (int dyeIndex = 0; dyeIndex < 8; ++dyeIndex) {
                        if (!skinDescriptor.getSkinDye().haveDyeInSlot(dyeIndex)) continue;
                        dye.addDye(dyeIndex, skinDescriptor.getSkinDye().getDyeColour(dyeIndex));
                    }
                    GlStateManager.func_179094_E();
                    this.head.field_78807_k = true;
                    if (this.head != null) {
                        GL11.glRotated((double)Math.toDegrees(this.head.field_78808_h), (double)0.0, (double)0.0, (double)1.0);
                        GL11.glRotated((double)Math.toDegrees(this.head.field_78796_g), (double)0.0, (double)1.0, (double)0.0);
                        GL11.glRotated((double)Math.toDegrees(this.head.field_78795_f), (double)1.0, (double)0.0, (double)0.0);
                    }
                    SkinModelRenderHelper.INSTANCE.modelHelperDummy.render(null, skin, null, true, dye, null, true, 0.0, true);
                    GlStateManager.func_179121_F();
                }
            }
            GlStateManager.func_179101_C();
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    public static class SkinnableEntityCustomEntity
    extends SkinnableEntity {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void addRenderLayer(RenderManager renderManager) {
            Render renderer = renderManager.func_78715_a(this.getEntityClass());
            if (renderer != null && renderer instanceof RenderLivingBase) {
                SkinLayerRendererBeanPlushie rendererBeanPlushie = new SkinLayerRendererBeanPlushie(this.getEntityClass(), (RenderLivingBase)renderer);
                if (rendererBeanPlushie != null) {
                    ((RenderLivingBase)renderer).func_177094_a((LayerRenderer)rendererBeanPlushie);
                }
            } else {
                ModLogger.log(Level.WARN, "Failed to get renderer for moriyashiine.hauntedastolfobeanplushie.entity.EntityHauntedAstolfoBeanPlushie");
            }
        }

        public Class<? extends EntityLivingBase> getEntityClass() {
            try {
                return Class.forName(AddonHauntedAstolfoBeanPlushie.ENTITY_CLASS_NAME);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public void getValidSkinTypes(ArrayList<ISkinType> skinTypes) {
            skinTypes.add(SkinTypeRegistry.skinHead);
        }

        @Override
        public int getSlotsForSkinType(ISkinType skinType) {
            return 1;
        }

        @Override
        public boolean canUseWandOfStyle(EntityPlayer user) {
            return true;
        }
    }
}

