/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.items;

import moe.plushie.armourers_workshop.common.holiday.Holiday;
import moe.plushie.armourers_workshop.common.holiday.ModHolidays;
import moe.plushie.armourers_workshop.common.init.items.AbstractModItem;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.utils.NBTHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="armourers_workshop")
public class ItemGiftSack
extends AbstractModItem {
    public static final String TAG_COLOUR_1 = "colour1";
    public static final String TAG_COLOUR_2 = "colour2";
    public static final String TAG_GIFT_ITEM = "giftItem";
    public static final String TAG_HOLIDAY = "holiday";

    public ItemGiftSack() {
        super("gift-sack");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            super.func_150895_a(tab, items);
            for (Holiday holiday : ModHolidays.getHolidays()) {
                if (!holiday.hasGiftSack()) continue;
                items.add((Object)holiday.getGiftSack());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(ItemStack stack, int tintIndex) {
        if (tintIndex == 0 && stack.func_77942_o() && stack.func_77978_p().func_150297_b(TAG_COLOUR_1, 3)) {
            return stack.func_77978_p().func_74762_e(TAG_COLOUR_1);
        }
        if (tintIndex == 1 && stack.func_77942_o() && stack.func_77978_p().func_150297_b(TAG_COLOUR_2, 3)) {
            return stack.func_77978_p().func_74762_e(TAG_COLOUR_2);
        }
        if (tintIndex == 1) {
            return 0x333333;
        }
        return 0xFFFFFF;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemStack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && itemStack.func_77942_o()) {
            ItemStack giftStack;
            Holiday holiday;
            ItemStack giftStack2;
            if (itemStack.func_77978_p().func_150297_b(TAG_GIFT_ITEM, 10) && !(giftStack2 = NBTHelper.readStackfromNBT(itemStack.func_77978_p(), TAG_GIFT_ITEM)).func_190926_b()) {
                if (playerIn.field_71071_by.func_70441_a(giftStack2)) {
                    itemStack.func_190918_g(1);
                } else {
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("chat.armourersworkshop:inventoryFull", new Object[0]));
                }
            }
            if (itemStack.func_77978_p().func_150297_b(TAG_HOLIDAY, 8) && (holiday = ModHolidays.getHoliday(itemStack.func_77978_p().func_74779_i(TAG_HOLIDAY))) != null && !(giftStack = holiday.getGift(playerIn)).func_190926_b()) {
                if (playerIn.field_71071_by.func_70441_a(giftStack)) {
                    itemStack.func_190918_g(1);
                } else {
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("chat.armourersworkshop:inventoryFull", new Object[0]));
                }
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
    }

    public static ItemStack createStack(int colour1, int colour2, Holiday holiday) {
        ItemStack stack = new ItemStack(ModItems.GIFT_SACK);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a(TAG_COLOUR_1, colour1);
        stack.func_77978_p().func_74768_a(TAG_COLOUR_2, colour2);
        stack.func_77978_p().func_74778_a(TAG_HOLIDAY, holiday.getName());
        return stack;
    }

    public static ItemStack createStack(int colour1, int colour2, ItemStack gift) {
        ItemStack stack = new ItemStack(ModItems.GIFT_SACK);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a(TAG_COLOUR_1, colour1);
        stack.func_77978_p().func_74768_a(TAG_COLOUR_2, colour2);
        NBTHelper.writeStackToNBT(stack.func_77978_p(), TAG_GIFT_ITEM, gift);
        return stack;
    }
}

