/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.network.messages.client;

import io.netty.buffer.ByteBuf;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.api.common.painting.IPantableBlock;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.world.undo.UndoManager;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageClientToolPaintBlock
implements IMessage,
IMessageHandler<MessageClientToolPaintBlock, IMessage> {
    private int x;
    private int y;
    private int z;
    private EnumFacing facing;
    private byte[] rgbt = new byte[4];

    public MessageClientToolPaintBlock() {
    }

    public MessageClientToolPaintBlock(BlockPos pos, EnumFacing facing, byte[] rgbt) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.facing = facing;
        this.rgbt = rgbt;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte((int)((byte)this.facing.ordinal()));
        buf.writeBytes(this.rgbt);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.facing = EnumFacing.field_82609_l[buf.readByte()];
        buf.readBytes(this.rgbt);
    }

    public IMessage onMessage(MessageClientToolPaintBlock message, MessageContext ctx) {
        BlockPos pos;
        World world;
        Block block;
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (player != null && player.func_130014_f_() != null && (block = (world = player.func_130014_f_()).func_180495_p(pos = new BlockPos(message.x, message.y, message.z)).func_177230_c()) instanceof IPantableBlock) {
            UndoManager.begin((EntityPlayer)player);
            IPantableBlock paintable = (IPantableBlock)block;
            int oldColour = paintable.getColour((IBlockAccess)world, pos, message.facing);
            IPaintType oldPaintType = paintable.getPaintType((IBlockAccess)world, pos, message.facing);
            UndoManager.blockPainted((EntityPlayer)player, world, pos, oldColour, (byte)oldPaintType.getId(), message.facing);
            paintable.setColour((IBlockAccess)world, pos, message.rgbt, message.facing);
            paintable.setPaintType((IBlockAccess)world, pos, PaintTypeRegistry.getInstance().getPaintTypeFormByte(message.rgbt[3]), message.facing);
            UndoManager.end((EntityPlayer)player);
        }
        return null;
    }
}

