/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.painting.tool;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ToolOption<T> {
    private static final String TAG_TOOL_OPTIONS = "toolOptions";
    protected final String key;
    protected final T defaultValue;

    public ToolOption(String key, T defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue(ItemStack stack) {
        return (T)this.readFromNBT(stack, this.defaultValue);
    }

    public void setValue(ItemStack stack, T value) {
        this.writeToNBT(stack, value);
    }

    public String getOptionName() {
        return this.key;
    }

    public String getUnlocalisedlabel() {
        return "tooloption." + "armourers_workshop".toLowerCase() + ":" + this.getOptionName();
    }

    public String getLocalisedLabel() {
        return I18n.func_135052_a((String)this.getUnlocalisedlabel(), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract int getDisplayWidth();

    @SideOnly(value=Side.CLIENT)
    public abstract int getDisplayHeight();

    @SideOnly(value=Side.CLIENT)
    public abstract GuiButton getGuiControl(int var1, int var2, int var3, NBTTagCompound var4);

    @SideOnly(value=Side.CLIENT)
    public abstract void writeGuiControlToNBT(GuiButton var1, NBTTagCompound var2);

    public void writeToNBT(ItemStack stack, T value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        this.writeToNBT(stack.func_77978_p(), value);
    }

    protected void writeToNBT(NBTTagCompound compound, T value) {
        if (!compound.func_150297_b(TAG_TOOL_OPTIONS, 10)) {
            compound.func_74782_a(TAG_TOOL_OPTIONS, (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound optionsCompund = compound.func_74775_l(TAG_TOOL_OPTIONS);
        if (value instanceof String) {
            optionsCompund.func_74778_a(this.key, (String)value);
        }
        if (value instanceof Integer) {
            optionsCompund.func_74768_a(this.key, ((Integer)value).intValue());
        }
        if (value instanceof Double) {
            optionsCompund.func_74780_a(this.key, ((Double)value).doubleValue());
        }
        if (value instanceof Boolean) {
            optionsCompund.func_74757_a(this.key, ((Boolean)value).booleanValue());
        }
    }

    protected Object readFromNBT(ItemStack stack, T defaultValue) {
        return this.readFromNBT(stack.func_77978_p(), defaultValue);
    }

    protected Object readFromNBT(NBTTagCompound compound, T defaultValue) {
        if (compound == null) {
            return defaultValue;
        }
        if (!compound.func_150297_b(TAG_TOOL_OPTIONS, 10)) {
            return defaultValue;
        }
        NBTTagCompound optionsCompund = compound.func_74775_l(TAG_TOOL_OPTIONS);
        if (defaultValue instanceof String) {
            return optionsCompund.func_74779_i(this.key);
        }
        if (defaultValue instanceof Integer) {
            return optionsCompund.func_74762_e(this.key);
        }
        if (defaultValue instanceof Double) {
            return optionsCompund.func_74769_h(this.key);
        }
        if (defaultValue instanceof Boolean) {
            return optionsCompund.func_74767_n(this.key);
        }
        return defaultValue;
    }
}

