/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.proxies;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.ArmourersWorkshopApi;
import moe.plushie.armourers_workshop.common.addons.ModAddonManager;
import moe.plushie.armourers_workshop.common.capability.ModCapabilityManager;
import moe.plushie.armourers_workshop.common.config.ConfigHandler;
import moe.plushie.armourers_workshop.common.config.ConfigHandlerOverrides;
import moe.plushie.armourers_workshop.common.config.ConfigSynchronizeHandler;
import moe.plushie.armourers_workshop.common.crafting.CraftingManager;
import moe.plushie.armourers_workshop.common.init.blocks.ModBlocks;
import moe.plushie.armourers_workshop.common.init.entities.ModEntities;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.common.init.sounds.ModSounds;
import moe.plushie.armourers_workshop.common.inventory.ContainerSkinLibrary;
import moe.plushie.armourers_workshop.common.inventory.ModContainer;
import moe.plushie.armourers_workshop.common.library.CommonLibraryManager;
import moe.plushie.armourers_workshop.common.library.ILibraryCallback;
import moe.plushie.armourers_workshop.common.library.ILibraryManager;
import moe.plushie.armourers_workshop.common.library.LibraryFile;
import moe.plushie.armourers_workshop.common.library.LibraryFileType;
import moe.plushie.armourers_workshop.common.library.global.permission.PermissionSystem;
import moe.plushie.armourers_workshop.common.network.GuiHandler;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientGuiAdminPanel;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientGuiSkinLibraryCommand;
import moe.plushie.armourers_workshop.common.network.messages.server.MessageServerClientCommand;
import moe.plushie.armourers_workshop.common.network.messages.server.MessageServerLibrarySendSkin;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.permission.PermissionManager;
import moe.plushie.armourers_workshop.common.skin.SkinExtractor;
import moe.plushie.armourers_workshop.common.skin.advanced.AdvancedSkinRegistry;
import moe.plushie.armourers_workshop.common.skin.cache.CommonSkinCache;
import moe.plushie.armourers_workshop.common.skin.cubes.CubeRegistry;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.entity.SkinnableEntityRegisty;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.utils.ModLogger;
import moe.plushie.armourers_workshop.utils.SkinIOUtils;
import moe.plushie.armourers_workshop.utils.SkinNBTUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="armourers_workshop")
public class CommonProxy
implements ILibraryCallback {
    private File modConfigDirectory;
    private File instanceDirectory;
    private File modDirectory;
    private File skinLibraryDirectory;
    private PaintTypeRegistry paintTypeRegistry;
    private static ModItems modItems;
    private static ModBlocks modBlocks;
    private static ModSounds modSounds;
    public ILibraryManager libraryManager;
    private PermissionSystem permissionSystem;
    private AdvancedSkinRegistry advancedSkinRegistry;
    private ArrayList<LibraryFile> clearFiles = new ArrayList();

    public void preInit(FMLPreInitializationEvent event) {
        this.modConfigDirectory = new File(event.getSuggestedConfigurationFile().getParentFile(), "armourers_workshop");
        if (!this.modConfigDirectory.exists()) {
            this.modConfigDirectory.mkdirs();
        }
        ModAddonManager.preInit();
        ConfigHandler.init(new File(this.modConfigDirectory, "common.cfg"));
        ConfigHandlerOverrides.init(new File(this.modConfigDirectory, "overrides.cfg"));
        this.instanceDirectory = event.getSuggestedConfigurationFile().getParentFile().getParentFile();
        this.modDirectory = new File(this.instanceDirectory, "armourers_workshop");
        if (!this.modDirectory.exists()) {
            this.modDirectory.mkdir();
        }
        this.skinLibraryDirectory = new File(this.modDirectory, "skin-library");
        if (!this.skinLibraryDirectory.exists()) {
            this.skinLibraryDirectory.mkdir();
        }
        ModLogger.log("user home: " + System.getProperty("user.home"));
        ModEntities.registerEntities();
        SkinExtractor.extractSkins();
        this.paintTypeRegistry = new PaintTypeRegistry();
        SkinTypeRegistry.init();
        CubeRegistry.init();
        this.advancedSkinRegistry = new AdvancedSkinRegistry();
        modItems = new ModItems();
        modBlocks = new ModBlocks();
        modSounds = new ModSounds();
        SkinnableEntityRegisty.init();
        ModCapabilityManager.register();
        ReflectionHelper.setPrivateValue(ArmourersWorkshopApi.class, null, (Object)SkinNBTUtils.INSTANCE, (String[])new String[]{"skinNBTUtils"});
        ReflectionHelper.setPrivateValue(ArmourersWorkshopApi.class, null, (Object)SkinTypeRegistry.INSTANCE, (String[])new String[]{"skinTypeRegistry"});
        ReflectionHelper.setPrivateValue(ArmourersWorkshopApi.class, null, (Object)SkinnableEntityRegisty.INSTANCE, (String[])new String[]{"skinnableEntityRegisty"});
        ReflectionHelper.setPrivateValue(ArmourersWorkshopApi.class, null, (Object)this.paintTypeRegistry, (String[])new String[]{"paintTypeRegistry"});
    }

    public void initLibraryManager() {
        this.libraryManager = new CommonLibraryManager();
    }

    public void initRenderers() {
    }

    public void init(FMLInitializationEvent event) {
        modBlocks.registerTileEntities();
        CraftingManager.init();
        new GuiHandler();
        new ConfigSynchronizeHandler();
        PacketHandler.init();
        this.permissionSystem = new PermissionSystem();
        ModAddonManager.init();
        PermissionManager.registerPermissions();
    }

    public void postInit(FMLPostInitializationEvent event) {
        ModAddonManager.postInit();
        this.libraryManager.reloadLibrary();
    }

    public PermissionSystem getPermissionSystem() {
        return this.permissionSystem;
    }

    public void registerKeyBindings() {
    }

    public void receivedCommandFromSever(MessageServerClientCommand.CommandType command) {
    }

    public PaintTypeRegistry getPaintTypeRegistry() {
        return this.paintTypeRegistry;
    }

    public void receivedAdminPanelCommand(EntityPlayer player, MessageClientGuiAdminPanel.AdminPanelCommand command) {
        if (!(player.field_71070_bA instanceof ModContainer)) {
            ModLogger.log(Level.WARN, String.format("Player '%s' tried to run the admin command '%s' but don't have the admin panel open.", player.func_70005_c_(), command.toString()));
            return;
        }
        switch (command) {
            case RECOVER_SKINS: {
                SkinIOUtils.recoverSkins(player);
                break;
            }
            case RELOAD_LIBRARY: {
                ArmourersWorkshop.getProxy().getLibraryManager().reloadLibrary();
                break;
            }
            case UPDATE_SKINS: {
                SkinIOUtils.updateSkins(player);
                break;
            }
            case RELOAD_CACHE: {
                CommonSkinCache.INSTANCE.clearAll();
            }
        }
    }

    public void receivedSkinFromLibrary(String fileName, String filePath, Skin skin, MessageServerLibrarySendSkin.SendType sendType) {
    }

    public void skinLibraryCommand(EntityPlayerMP player, MessageClientGuiSkinLibraryCommand.SkinLibraryCommand command, LibraryFile file, boolean publicList) {
        if (!(player.field_71070_bA instanceof ContainerSkinLibrary)) {
            ModLogger.log(Level.WARN, String.format("Player '%s' tried to run the library command '%s' but don't have the library open.", player.func_70005_c_(), command.toString()));
            return;
        }
        switch (command) {
            case DELETE: {
                if (!publicList) {
                    File dir = new File(this.getSkinLibraryDirectory(), file.filePath);
                    dir = file.isDirectory() ? new File(dir, file.fileName + "/") : new File(dir, file.fileName + ".armour");
                    if (dir.isDirectory() != file.isDirectory()) break;
                    if (!SkinIOUtils.isInLibraryDir(dir)) {
                        ModLogger.log(Level.WARN, String.format("Player '%s' tried to delete the file/folder '%s' that is outside the library directory.", player.func_146103_bH().toString(), dir.getAbsolutePath()));
                        return;
                    }
                    if (!dir.exists()) break;
                    if (file.isDirectory()) {
                        try {
                            FileUtils.deleteDirectory((File)dir);
                            this.libraryManager.reloadLibrary();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    this.clearFiles.add(file);
                    ModLogger.log("deleting skin " + dir.getAbsolutePath());
                    dir.delete();
                    this.libraryManager.removeFileFromListType(file, LibraryFileType.SERVER_PRIVATE, (EntityPlayer)player);
                    this.libraryManager.reloadLibrary(this);
                    break;
                }
                ModLogger.log("public delete");
                break;
            }
            case NEW_FOLDER: {
                if (!publicList) {
                    File dir = new File(this.getSkinLibraryDirectory(), file.filePath);
                    if (!SkinIOUtils.isInLibraryDir(dir = new File(dir, file.fileName))) {
                        ModLogger.log(Level.WARN, String.format("Player '%s' tried to make the folder '%s' that is outside the library directory.", player.func_146103_bH().toString(), dir.getAbsolutePath()));
                        return;
                    }
                    if (!dir.exists()) {
                        dir.mkdir();
                    }
                    this.libraryManager.reloadLibrary();
                    ModLogger.log(String.format("making folder call %s in %s", file.fileName, file.filePath));
                    ModLogger.log("full path: " + dir.getAbsolutePath());
                    break;
                }
                ModLogger.log("public new folder");
            }
        }
    }

    @Override
    public void libraryReloaded(ILibraryManager libraryManager) {
        for (int i = 0; i < this.clearFiles.size(); ++i) {
            CommonSkinCache.INSTANCE.clearFileNameIdLink(this.clearFiles.get(i));
        }
    }

    public boolean isLocalPlayer(String username) {
        return false;
    }

    public boolean haveFullLocalProfile() {
        return false;
    }

    public GameProfile getLocalGameProfile() {
        return null;
    }

    public ILibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public File getModConfigDirectory() {
        return this.modConfigDirectory;
    }

    public File getInstanceDirectory() {
        return this.instanceDirectory;
    }

    public File getModDirectory() {
        return this.modDirectory;
    }

    public File getSkinLibraryDirectory() {
        return this.skinLibraryDirectory;
    }

    public File getGlobalSkinDatabaseDirectory() {
        return new File(this.modDirectory, "global-skin-database");
    }

    public AdvancedSkinRegistry getAdvancedSkinRegistry() {
        return this.advancedSkinRegistry;
    }

    @SubscribeEvent
    public MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }
}

