/*
 * Decompiled with CFR 0.152.
 */
package com.driga.jhud;

import com.driga.jhud.JHud;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class Hud {
    private ResourceLocation base = new ResourceLocation("jhud:textures/frame.png");
    private ResourceLocation mp = new ResourceLocation("jhud:textures/mp.png");
    private ResourceLocation hp = new ResourceLocation("jhud:textures/hp.png");
    private ResourceLocation mp_back = new ResourceLocation("jhud:textures/mp_back.png");
    private ResourceLocation hp_back = new ResourceLocation("jhud:textures/hp_back.png");
    private JHud jhud;
    public PlayerInfo info;

    public Hud(JHud jhud, PlayerInfo info) {
        this.jhud = jhud;
        this.info = info;
    }

    public void render() {
        double health = this.info.getHealth();
        double maxHealth = this.info.getMaxHeath();
        double mana = this.info.getMana();
        double maxMana = this.info.getMaxMana();
        FontRenderer fontRenderer = new FontRenderer(this.jhud.minecraft.field_71474_y, new ResourceLocation("jhud:textures/font/m.png"), this.jhud.minecraft.func_110434_K(), true);
        int healthWidth = (int)(180.0 * (health / maxHealth));
        int manaWidth = (int)(173.0 * (mana / maxMana));
        double x = this.rot(1920.0, 1.2, Double.valueOf(Minecraft.func_71410_x().field_71443_c));
        double y = this.rot(1080.0, 1.2, Double.valueOf(Minecraft.func_71410_x().field_71440_d));
        int lifePercentage = (int)this.rot(maxHealth, 100.0, health);
        String healthString = "- " + lifePercentage + "% -";
        int manaPercentage = (int)this.rot(maxMana, 100.0, mana);
        String manaString = "- " + manaPercentage + "% -";
        int tp = (int)this.info.tp;
        String tpString = tp + " TP";
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179139_a((double)x, (double)y, (double)0.0);
        this.jhud.minecraft.func_110434_K().func_110577_a(this.base);
        Gui.func_146110_a((int)5, (int)5, (float)0.0f, (float)0.0f, (int)268, (int)86, (float)268.0f, (float)86.0f);
        this.jhud.minecraft.func_110434_K().func_110577_a(this.hp_back);
        Gui.func_146110_a((int)86, (int)34, (float)0.0f, (float)0.0f, (int)178, (int)6, (float)178.0f, (float)6.0f);
        this.jhud.minecraft.func_110434_K().func_110577_a(this.hp);
        Gui.func_146110_a((int)85, (int)33, (float)0.0f, (float)0.0f, (int)healthWidth, (int)8, (float)180.0f, (float)8.0f);
        this.jhud.minecraft.func_110434_K().func_110577_a(this.mp_back);
        Gui.func_146110_a((int)88, (int)45, (float)0.0f, (float)0.0f, (int)173, (int)6, (float)173.0f, (float)6.0f);
        this.jhud.minecraft.func_110434_K().func_110577_a(this.mp);
        Gui.func_146110_a((int)88, (int)44, (float)0.0f, (float)0.0f, (int)manaWidth, (int)8, (float)173.0f, (float)8.0f);
        fontRenderer.func_78276_b(TextFormatting.BOLD + healthString, 150, 33, -1);
        fontRenderer.func_78276_b(TextFormatting.BOLD + manaString, 150, 44, -1);
        fontRenderer.func_78276_b(TextFormatting.BOLD + tpString, 140, 55, -1);
        GlStateManager.func_179121_F();
    }

    private double rot(Double var1, Double var2, Double var3) {
        double p0 = var2 * var3;
        double p1 = p0 / var1;
        return p1;
    }

    public static class PlayerInfo {
        private double health;
        private double maxHeath;
        private double mana;
        private double maxMana;
        private double tp;

        public PlayerInfo() {
            this.health = 20.0;
            this.maxHeath = 20.0;
            this.mana = 20.0;
            this.maxMana = 20.0;
            this.tp = 0.0;
        }

        public PlayerInfo(double health, double maxHeath, double mana, double maxMana, double tp) {
            this.health = health;
            this.maxHeath = maxHeath;
            this.mana = mana;
            this.maxMana = maxMana;
            this.tp = tp;
        }

        public double getHealth() {
            return this.health;
        }

        public void setHealth(double health) {
            this.health = health;
        }

        public double getMaxHeath() {
            return this.maxHeath;
        }

        public void setMaxHeath(double maxHeath) {
            this.maxHeath = maxHeath;
        }

        public double getMana() {
            return this.mana;
        }

        public void setMana(double mana) {
            this.mana = mana;
        }

        public double getMaxMana() {
            return this.maxMana;
        }

        public void setMaxMana(double maxMana) {
            this.maxMana = maxMana;
        }

        public double getTp() {
            return this.tp;
        }

        public void setTp(double tp) {
            this.tp = tp;
        }
    }
}

