/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;

public class VersionCheck {
    private static volatile Boolean updateCheckEnabled = JourneyMap.getInstance().coreProperties.checkUpdates.get();
    private static volatile Boolean versionIsCurrent = true;
    private static volatile Boolean versionIsChecked;
    private static volatile String versionAvailable;

    public static Boolean getVersionIsCurrent() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return versionIsCurrent;
    }

    public static Boolean getVersionIsChecked() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return versionIsChecked;
    }

    public static String getVersionAvailable() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return versionAvailable;
    }

    private static synchronized void checkVersion() {
        if (updateCheckEnabled.booleanValue()) {
            JourneyMap.getLogger().info("Checking for updated version: https://dl.dropboxusercontent.com/u/38077766/JourneyMap/journeymap-version.js");
            try {
                Boolean done;
                String inputLine;
                URL uri = URI.create("https://dl.dropboxusercontent.com/u/38077766/JourneyMap/journeymap-version.js").toURL();
                HttpsURLConnection connection = (HttpsURLConnection)uri.openConnection();
                connection.setConnectTimeout(3000);
                connection.setReadTimeout(3000);
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Referer", "http://journeymap.techbrew.net/?client=4.0.1");
                connection.setRequestProperty("Host", "localhost");
                connection.setRequestProperty("User-Agent", "Java/" + System.getProperty("java.version"));
                BufferedReader in = new BufferedReader(new InputStreamReader(uri.openStream()));
                StringBuffer sb = new StringBuffer();
                while (!((inputLine = in.readLine()) == null || (done = VersionCheck.checkLine(inputLine)) != null && done.booleanValue())) {
                }
                in.close();
                JourneyMap.getLogger().info("Version available online: " + versionAvailable);
            }
            catch (Throwable e) {
                JourneyMap.getLogger().log(Level.SEVERE, "Could not check version URL", e);
                versionIsChecked = false;
                versionIsCurrent = true;
                versionAvailable = "0";
                updateCheckEnabled = false;
            }
        } else {
            JourneyMap.getLogger().info("Update check disabled in properties file.");
            versionIsChecked = false;
            versionIsCurrent = true;
            versionAvailable = "0";
        }
    }

    private static Boolean checkLine(String line) {
        String version;
        if (line.startsWith("//") && line.contains("JM=") && (version = line.split("JM=")[1]) != null) {
            versionIsChecked = true;
            versionAvailable = version;
            if (version.compareTo("4.0.1") > 0) {
                versionIsCurrent = false;
            }
        }
        return versionIsChecked;
    }

    public static void launchWebsite() {
        String url = "http://journeymap.techbrew.net/";
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (Throwable e) {
            JourneyMap.getLogger().log(Level.SEVERE, "Could not launch browser with URL: " + url, LogFormatter.toString(e));
        }
    }
}

