/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.cartography;

import java.awt.Color;
import java.awt.Graphics2D;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.EnumSkyBlock;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.BaseRenderer;
import net.techbrew.journeymap.cartography.IChunkRenderer;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.RGB;

public class ChunkEndRenderer
extends BaseRenderer
implements IChunkRenderer {
    @Override
    public boolean render(Graphics2D g2D, ChunkMD chunkMd, boolean underground, Integer vSlice, ChunkMD.Set neighbors) {
        if (chunkMd.sliceSlopes == null) {
            chunkMd.sliceSlopes = new float[16][16];
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    float slope;
                    float h = chunkMd.getSlopeHeightValue(x, y);
                    float hN = y == 0 ? this.getBlockHeight(x, y, 0, -1, chunkMd, neighbors, h).floatValue() : (float)chunkMd.getSlopeHeightValue(x, y - 1);
                    float hW = x == 0 ? this.getBlockHeight(x, y, -1, 0, chunkMd, neighbors, h).floatValue() : (float)chunkMd.getSlopeHeightValue(x - 1, y);
                    chunkMd.sliceSlopes[x][y] = slope = (h / hN + h / hW) / 2.0f;
                }
            }
        }
        boolean chunkOk = false;
        int maxY = chunkMd.worldHeight;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                try {
                    float s;
                    Block block;
                    BlockMD blockMD;
                    int sliceMinY = Math.max((vSlice << 4) - 1, 0);
                    int sliceMaxY = maxY;
                    if (sliceMinY == sliceMaxY) {
                        sliceMaxY += 2;
                    }
                    Object metaId = null;
                    boolean hasAir = false;
                    int paintY = -1;
                    int lightLevel = -1;
                    for (int y = sliceMaxY; y > 0; --y) {
                        blockMD = BlockMD.getBlockMD(chunkMd, x, y, z);
                        if (!hasAir && y <= sliceMinY) break;
                        if (blockMD.isAir()) {
                            hasAir = true;
                            continue;
                        }
                        if (!hasAir || paintY != -1) continue;
                        paintY = y;
                        break;
                    }
                    if (paintY <= 0) {
                        this.paintBlock(x, z, Color.BLACK, g2D);
                        continue;
                    }
                    blockMD = BlockMD.getBlockMD(chunkMd, x, paintY, z);
                    lightLevel = chunkMd.getSavedLightValue(EnumSkyBlock.Block, x, paintY + 1, z);
                    if (lightLevel < 10) {
                        lightLevel += 3;
                    }
                    if ((block = blockMD.getBlock()) == Blocks.field_150357_h || block == Blocks.field_150343_Z) {
                        lightLevel = 15;
                    }
                    RGB color = blockMD.getColor(chunkMd, x, paintY, z);
                    float slope = chunkMd.sliceSlopes[x][z];
                    float sN = this.getBlockSlope(x, z, 0, -1, chunkMd, neighbors, slope, true).floatValue();
                    float sNW = this.getBlockSlope(x, z, -1, -1, chunkMd, neighbors, slope, true).floatValue();
                    float sW = this.getBlockSlope(x, z, -1, 0, chunkMd, neighbors, slope, true).floatValue();
                    float sAvg = (sN + sNW + sW) / 3.0f;
                    if (slope < 1.0f) {
                        if (slope <= sAvg) {
                            slope *= 0.6f;
                        } else if (slope > sAvg) {
                            slope = (slope + sAvg) / 2.0f;
                        }
                        s = Math.max(slope * 0.8f, 0.1f);
                        color.bevelSlope(s);
                    } else if (slope > 1.0f) {
                        if (sAvg > 1.0f && slope >= sAvg) {
                            slope *= 1.2f;
                        }
                        s = slope * 1.2f;
                        s = Math.min(s, 1.4f);
                        color.bevelSlope(s);
                    }
                    if (block == Blocks.field_150377_bs && lightLevel < 15) {
                        color.darken(Math.min(1.0f, (float)lightLevel * 1.0f / 14.0f));
                    }
                    g2D.setComposite(BlockUtils.OPAQUE);
                    g2D.setPaint(color.toColor());
                    g2D.fillRect(x, z, 1, 1);
                    chunkOk = true;
                    continue;
                }
                catch (Throwable t) {
                    this.paintBadBlock(x, vSlice, z, g2D);
                    String error = Constants.getMessageJMERR07("x,vSlice,z = " + x + "," + vSlice + "," + z + " : " + LogFormatter.toString(t));
                    JourneyMap.getLogger().severe(error);
                }
            }
        }
        return chunkOk;
    }
}

