/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.cartography;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;
import net.minecraft.world.EnumSkyBlock;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.BaseRenderer;
import net.techbrew.journeymap.cartography.IChunkRenderer;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.RGB;

public class ChunkStandardRenderer
extends BaseRenderer
implements IChunkRenderer {
    protected boolean caveGreySurface;
    protected boolean advancedSurfaceCheck;
    protected StatTimer renderSurfaceTimer;
    protected StatTimer renderSurfacePrepassTimer;

    public ChunkStandardRenderer() {
        this.caveGreySurface = JourneyMap.getInstance().coreProperties.caveGreySurface.get();
        this.advancedSurfaceCheck = JourneyMap.getInstance().coreProperties.advancedSurfaceCheck.get();
        this.renderSurfaceTimer = StatTimer.get("ChunkStandardRenderer.renderSurface");
        this.renderSurfacePrepassTimer = StatTimer.get("ChunkStandardRenderer.renderSurface-prepass");
    }

    @Override
    public boolean render(Graphics2D g2D, ChunkMD chunkMd, boolean underground, Integer vSlice, ChunkMD.Set neighbors) {
        if (chunkMd.surfaceSlopes == null) {
            this.initSurfaceSlopes(chunkMd, neighbors);
        }
        if (underground) {
            int hardSliceMaxY;
            int sliceMaxY;
            int sliceMinY;
            boolean ok = this.renderSurface(g2D, chunkMd, vSlice, neighbors, true);
            if (!ok) {
                JourneyMap.getLogger().fine("The surface chunk didn't paint: " + chunkMd.toString());
            }
            if ((sliceMinY = Math.max(vSlice << 4, 0)) >= (sliceMaxY = Math.min(hardSliceMaxY = (vSlice + 1 << 4) - 1, chunkMd.worldObj.func_72940_L()))) {
                sliceMaxY = sliceMinY + 2;
            }
            if (chunkMd.sliceSlopes == null) {
                this.initSliceSlopes(chunkMd, sliceMinY, sliceMaxY, neighbors);
            }
            if (!(ok = this.renderUnderground(g2D, chunkMd, vSlice, sliceMinY, sliceMaxY, neighbors))) {
                JourneyMap.getLogger().fine("The underground chunk didn't paint: " + chunkMd.toString());
            }
            return ok;
        }
        return this.renderSurface(g2D, chunkMd, vSlice, neighbors, false);
    }

    protected void initSurfaceSlopes(ChunkMD chunkMd, ChunkMD.Set neighbors) {
        chunkMd.surfaceSlopes = new float[16][16];
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                float slope;
                float h = chunkMd.getSlopeHeightValue(x, y);
                float hN = y == 0 ? this.getBlockHeight(x, y, 0, -1, chunkMd, neighbors, h).floatValue() : (float)chunkMd.getSlopeHeightValue(x, y - 1);
                float hW = x == 0 ? this.getBlockHeight(x, y, -1, 0, chunkMd, neighbors, h).floatValue() : (float)chunkMd.getSlopeHeightValue(x - 1, y);
                float hNW = this.getBlockHeight(x, y, -1, -1, chunkMd, neighbors, h).floatValue();
                chunkMd.surfaceSlopes[x][y] = slope = (h / hN + h / hW + h / hNW) / 3.0f;
            }
        }
    }

    protected void initSliceSlopes(ChunkMD chunkMd, int sliceMinY, int sliceMaxY, ChunkMD.Set neighbors) {
        chunkMd.sliceSlopes = new float[16][16];
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                float slope;
                float h = this.getHeightInSlice(chunkMd, x, z, sliceMinY, sliceMaxY);
                float hN = z == 0 ? this.getBlockHeight(x, z, 0, -1, chunkMd, neighbors, h, sliceMinY, sliceMaxY).floatValue() : (float)this.getHeightInSlice(chunkMd, x, z - 1, sliceMinY, sliceMaxY);
                float hW = x == 0 ? this.getBlockHeight(x, z, -1, 0, chunkMd, neighbors, h, sliceMinY, sliceMaxY).floatValue() : (float)this.getHeightInSlice(chunkMd, x - 1, z, sliceMinY, sliceMaxY);
                chunkMd.sliceSlopes[x][z] = slope = (h / hN + h / hW) / 2.0f;
            }
        }
    }

    protected RGB getBaseBlockColor(ChunkMD chunkMd, BlockMD blockMD, ChunkMD.Set neighbors, int x, int y, int z) {
        return blockMD.getColor(chunkMd, x, y, z);
    }

    protected boolean renderSurface(Graphics2D g2D, ChunkMD chunkMd, Integer vSlice, ChunkMD.Set neighbors, boolean cavePrePass) {
        StatTimer timer = cavePrePass ? this.renderSurfacePrepassTimer : this.renderSurfaceTimer;
        timer.start();
        g2D.setComposite(BlockUtils.OPAQUE);
        boolean chunkOk = false;
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                float diff;
                boolean useAlpha;
                BlockMD blockMD = null;
                boolean isUnderRoof = false;
                int standardY = Math.max(1, chunkMd.getHeightValue(x, z));
                int roofY = 0;
                int y = standardY;
                if (this.advancedSurfaceCheck && standardY < (roofY = Math.max(1, chunkMd.getAbsoluteHeightValue(x, z)))) {
                    for (int checkY = roofY; checkY > standardY; --checkY) {
                        blockMD = BlockMD.getBlockMD(chunkMd, x, checkY, z);
                        if (blockMD == null || !blockMD.isTransparentRoof()) continue;
                        isUnderRoof = true;
                        y = Math.max(standardY, checkY);
                        break;
                    }
                }
                do {
                    if ((blockMD = BlockMD.getBlockMD(chunkMd, x, y, z)) == null) {
                        this.paintBadBlock(x, y, z, g2D);
                        continue block1;
                    }
                    if (blockMD.isTransparentRoof()) {
                        --y;
                        continue;
                    }
                    if (!blockMD.isAir()) break;
                    --y;
                } while (y >= 0);
                if (blockMD == null) {
                    this.paintBadBlock(x, y, z, g2D);
                    continue;
                }
                RGB color = this.getBaseBlockColor(chunkMd, blockMD, neighbors, x, y, z);
                if (color == null) {
                    this.paintBadBlock(x, y, z, g2D);
                    continue;
                }
                boolean bl = useAlpha = blockMD.hasFlag(BlockUtils.Flag.Transparency) || blockMD.isWater();
                if (useAlpha) {
                    color = this.renderSurfaceAlpha(g2D, chunkMd, blockMD, neighbors, x, y, z);
                    chunkOk = true;
                } else {
                    if (!blockMD.hasFlag(BlockUtils.Flag.NoShadow)) {
                        this.surfaceSlopeColor(color, chunkMd, blockMD, neighbors, x, y, z);
                    }
                    if (cavePrePass && this.caveGreySurface) {
                        color.ghostSurface();
                    }
                    g2D.setPaint(color.toColor());
                    g2D.fillRect(x, z, 1, 1);
                    chunkOk = true;
                }
                if (isUnderRoof) {
                    while (roofY > y) {
                        blockMD = BlockMD.getBlockMD(chunkMd, x, roofY, z);
                        if (blockMD != null && !blockMD.isAir() && blockMD.isTransparentRoof()) {
                            g2D.setComposite(blockMD.getAlphaComposite());
                            g2D.setPaint(this.getBaseBlockColor(chunkMd, blockMD, neighbors, x, roofY, z).toColor());
                            g2D.fillRect(x, z, 1, 1);
                            g2D.setComposite(BlockUtils.OPAQUE);
                        }
                        --roofY;
                    }
                }
                if (cavePrePass) continue;
                int lightLevel = Math.max(1, chunkMd.getSavedLightValue(EnumSkyBlock.Block, x, y + 1, z));
                if (lightLevel < 15 && (double)(diff = Math.min(1.0f, (float)lightLevel / 15.0f + 0.1f)) != 1.0) {
                    color.moonlight(diff);
                }
                g2D.setPaint(color.toColor());
                g2D.fillRect(x + 16, z, 1, 1);
                chunkOk = true;
            }
        }
        timer.stop();
        return chunkOk;
    }

    protected RGB renderSurfaceAlpha(Graphics2D g2D, ChunkMD chunkMd, BlockMD blockMD, ChunkMD.Set neighbors, int x, int y, int z) {
        RGB color = this.getBaseBlockColor(chunkMd, blockMD, neighbors, x, y, z);
        if (blockMD.isWater()) {
            BlockMD bw = this.getBlock(x, y, z, -1, 0, chunkMd, neighbors, blockMD);
            BlockMD be = this.getBlock(x, y, z, 1, 0, chunkMd, neighbors, blockMD);
            BlockMD bn = this.getBlock(x, y, z, 0, -1, chunkMd, neighbors, blockMD);
            BlockMD bs = this.getBlock(x, y, z, 0, 1, chunkMd, neighbors, blockMD);
            HashSet<RGB> colors = new HashSet<RGB>(6);
            colors.add(color);
            if (bw.isWater()) {
                colors.add(this.getBaseBlockColor(chunkMd, bw, neighbors, x, y, z));
            }
            if (be.isWater()) {
                colors.add(this.getBaseBlockColor(chunkMd, be, neighbors, x, y, z));
            }
            if (bn.isWater()) {
                colors.add(this.getBaseBlockColor(chunkMd, bn, neighbors, x, y, z));
            }
            if (bs.isWater()) {
                colors.add(this.getBaseBlockColor(chunkMd, bs, neighbors, x, y, z));
            }
            if (!colors.isEmpty()) {
                color = RGB.average(colors);
            }
        }
        this.paintDepth(chunkMd, blockMD, x, y, z, g2D, false);
        return color;
    }

    protected void surfaceSlopeColor(RGB color, ChunkMD chunkMd, BlockMD blockMD, ChunkMD.Set neighbors, int x, int ignored, int z) {
        float sAvg;
        float sNW = 1.0f;
        float sSE = 1.0f;
        float sE = 1.0f;
        float sS = 1.0f;
        float slope = chunkMd.surfaceSlopes[x][z];
        if (!blockMD.isFoliage()) {
            float sN = this.getBlockSlope(x, z, 0, -1, chunkMd, neighbors, slope, false).floatValue();
            sNW = this.getBlockSlope(x, z, -1, -1, chunkMd, neighbors, slope, false).floatValue();
            float sW = this.getBlockSlope(x, z, -1, 0, chunkMd, neighbors, slope, false).floatValue();
            sAvg = (sN + sNW + sW) / 3.0f;
        } else {
            float sN = this.getBlockSlope(x, z, 0, -1, chunkMd, neighbors, slope, false).floatValue();
            sS = this.getBlockSlope(x, z, 0, 1, chunkMd, neighbors, slope, false).floatValue();
            float sW = this.getBlockSlope(x, z, -1, 0, chunkMd, neighbors, slope, false).floatValue();
            sE = this.getBlockSlope(x, z, 1, 0, chunkMd, neighbors, slope, false).floatValue();
            sAvg = (sN + sS + sW + sE) / 4.0f;
        }
        float bevel = 1.0f;
        if (slope < 1.0f) {
            if (slope <= sAvg) {
                slope *= 0.6f;
            } else if (slope > sAvg && !blockMD.isFoliage()) {
                slope = (slope + sAvg) / 2.0f;
            }
            bevel = Math.max(slope * 0.8f, 0.1f);
        } else if (slope > 1.0f) {
            if (sAvg > 1.0f && slope >= sAvg && !blockMD.isFoliage()) {
                slope *= 1.2f;
            }
            bevel = Math.min(slope * 1.2f, 1.4f);
        }
        if (bevel != 1.0f) {
            color.bevelSlope(bevel);
        }
    }

    protected boolean renderUnderground(Graphics2D g2D, ChunkMD chunkMd, int vSlice, int sliceMinY, int sliceMaxY, ChunkMD.Set neighbors) {
        StatTimer timer = StatTimer.get("ChunkStandardRenderer.renderUnderground");
        timer.start();
        boolean chunkOk = false;
        for (int z = 0; z < 16; ++z) {
            block3: for (int x = 0; x < 16; ++x) {
                int lightLevel = 0;
                try {
                    BlockMD blockMD;
                    int ceiling = BlockUtils.ceiling(chunkMd, x, sliceMaxY, z);
                    if (ceiling < 0) {
                        chunkOk = true;
                        continue;
                    }
                    if (BlockUtils.skyAbove(chunkMd, x, Math.min(ceiling, sliceMinY), z)) {
                        chunkOk = true;
                        this.paintDimSurface(x, z, g2D);
                        continue;
                    }
                    if (ceiling <= sliceMinY) {
                        chunkOk = true;
                        this.paintDimSurface(x, z, g2D);
                        continue;
                    }
                    boolean hasAir = BlockMD.getBlockMD(chunkMd, x, ceiling + 1, z).isAir();
                    boolean hasSolid = false;
                    int paintY = ceiling;
                    for (int y = ceiling; y >= 0; --y) {
                        blockMD = BlockMD.getBlockMD(chunkMd, x, y, z);
                        if (blockMD.isWater()) {
                            paintY = y;
                            this.paintDepth(chunkMd, BlockMD.getBlockMD(chunkMd, x, y, z), x, paintY, z, g2D, this.caveLighting);
                            chunkOk = true;
                            continue block3;
                        }
                        if (blockMD.isLava()) {
                            if (!hasAir) {
                                this.paintBlock(x, z, Color.black, g2D);
                                chunkOk = true;
                                continue block3;
                            }
                            if (!hasSolid || y >= sliceMinY) {
                                lightLevel = 15;
                                paintY = y;
                                break;
                            }
                        }
                        if (blockMD.isTorch()) {
                            hasAir = true;
                            paintY = y - 1;
                            lightLevel = chunkMd.getSavedLightValue(EnumSkyBlock.Block, x, y, z);
                            if (chunkMd.stub.func_76628_c(x, y, z) == 5) break;
                            continue;
                        }
                        if (blockMD.isAir()) {
                            hasAir = true;
                            continue;
                        }
                        if (blockMD.hasFlag(BlockUtils.Flag.Transparency)) {
                            paintY = y;
                            hasAir = true;
                            continue;
                        }
                        if (hasAir) {
                            paintY = y;
                            lightLevel = chunkMd.getSavedLightValue(EnumSkyBlock.Block, x, y + 1, z);
                            if (lightLevel > 0 || !this.caveLighting) break;
                            hasSolid = true;
                        }
                        if (y <= sliceMinY) break;
                    }
                    if (paintY < 0 || !hasAir || lightLevel < 1 && this.caveLighting) {
                        chunkOk = true;
                        this.paintBlock(x, z, Color.black, g2D);
                        continue;
                    }
                    blockMD = BlockMD.getBlockMD(chunkMd, x, paintY, z);
                    RGB color = this.getBaseBlockColor(chunkMd, blockMD, neighbors, x, paintY, z);
                    boolean keepflat = blockMD.hasFlag(BlockUtils.Flag.NoShadow);
                    if (!keepflat) {
                        float s;
                        float slope = chunkMd.sliceSlopes[x][z];
                        float sN = this.getBlockSlope(x, z, 0, -1, chunkMd, neighbors, slope, true).floatValue();
                        float sNW = this.getBlockSlope(x, z, -1, -1, chunkMd, neighbors, slope, true).floatValue();
                        float sW = this.getBlockSlope(x, z, -1, 0, chunkMd, neighbors, slope, true).floatValue();
                        float sAvg = (sN + sNW + sW) / 3.0f;
                        if (slope < 1.0f) {
                            if (slope <= sAvg) {
                                slope *= 0.6f;
                            } else if (slope > sAvg) {
                                slope = (slope + sAvg) / 2.0f;
                            }
                            s = Math.max(slope * 0.8f, 0.1f);
                            color.bevelSlope(s);
                        } else if (slope > 1.0f) {
                            if (sAvg > 1.0f && slope >= sAvg) {
                                slope *= 1.2f;
                            }
                            s = slope * 1.2f;
                            s = Math.min(s, 1.4f);
                            color.bevelSlope(s);
                        }
                    }
                    if (this.caveLighting && lightLevel < 15) {
                        float factor = Math.min(1.0f, (float)lightLevel / 16.0f);
                        color.darken(factor);
                    }
                    this.paintBlock(x, z, color.toColor(), g2D);
                    chunkOk = true;
                    continue;
                }
                catch (Throwable t) {
                    timer.cancel();
                    this.paintBadBlock(x, vSlice, z, g2D);
                    String error = Constants.getMessageJMERR07("x,vSlice,z = " + x + "," + vSlice + "," + z + " : " + LogFormatter.toString(t));
                    JourneyMap.getLogger().severe(error);
                }
            }
        }
        timer.stop();
        return chunkOk;
    }

    protected void paintDimSurface(int x, int z, Graphics2D g2D) {
        if (!this.caveGreySurface) {
            g2D.setComposite(BlockUtils.SLIGHTLYCLEAR);
            g2D.setColor(Color.black);
            g2D.fillRect(x, z, 1, 1);
            g2D.setComposite(BlockUtils.OPAQUE);
        }
    }

    protected void paintDepth(ChunkMD chunkMd, BlockMD blockMD, int x, int y, int z, Graphics2D g2D, boolean useLighting) {
        BlockMD lowerBlock;
        Stack<BlockMD> stack = new Stack<BlockMD>();
        stack.push(blockMD);
        int maxDepth = 5;
        int down = y;
        while (down > 0 && (lowerBlock = BlockMD.getBlockMD(chunkMd, x, --down, z)) != null) {
            stack.push(lowerBlock);
            if (lowerBlock.isAir()) {
                ++maxDepth;
            }
            if (lowerBlock.getAlpha() != 1.0f && y - down <= maxDepth) continue;
            break;
        }
        boolean isWater = blockMD.isWater();
        RGB color = this.getBaseBlockColor(chunkMd, (BlockMD)stack.peek(), null, x, y, z);
        if (useLighting) {
            this.adjustColorForDepth(chunkMd, color, x, down + 1, z);
        } else if (isWater) {
            float factor = 0.68f;
            color.darken(factor);
        }
        g2D.setComposite(BlockUtils.OPAQUE);
        g2D.setPaint(color.toColor());
        g2D.fillRect(x, z, 1, 1);
        if (((BlockMD)stack.peek()).getBlock() != blockMD.getBlock()) {
            stack.pop();
            ArrayList<RGB> colors = new ArrayList<RGB>();
            colors.add(color);
            while (!stack.isEmpty()) {
                BlockMD lowerBlock2 = (BlockMD)stack.pop();
                if (lowerBlock2.isAir()) continue;
                color = this.getBaseBlockColor(chunkMd, lowerBlock2, null, x, y, z);
                if (useLighting) {
                    this.adjustColorForDepth(chunkMd, color, x, ++down, z);
                } else if (isWater) {
                    float factor = 0.7f;
                    color.darken(factor);
                }
                colors.add(color);
            }
            g2D.setComposite(BlockUtils.OPAQUE);
            g2D.setPaint(RGB.average(colors).toColor());
            g2D.fillRect(x, z, 1, 1);
        }
    }

    protected void adjustColorForDepth(ChunkMD chunkMd, RGB color, int x, int y, int z) {
        float diff;
        int lightLevel = Math.max(0, chunkMd.getSavedLightValue(EnumSkyBlock.Block, x, y, z));
        if (lightLevel < 15 && (double)(diff = Math.min(1.0f, (float)lightLevel / 15.0f + 0.05f)) != 1.0) {
            color.moonlight(diff);
        }
    }

    protected int getHeightInSlice(ChunkMD chunkMd, int x, int z, int sliceMinY, int sliceMaxY) {
        return BlockUtils.ceiling(chunkMd, x, sliceMaxY, z) + 1;
    }

    protected Float getBlockHeight(int x, int z, int offsetX, int offsetz, ChunkMD currentChunk, ChunkMD.Set neighbors, float defaultVal, int sliceMinY, int sliceMaxY) {
        int newX = x + offsetX;
        int newZ = z + offsetz;
        if (newX == -1) {
            newX = 15;
        } else if (newX == 16) {
            newX = 0;
        }
        if (newZ == -1) {
            newZ = 15;
        } else if (newZ == 16) {
            newZ = 0;
        }
        ChunkMD chunk = this.getChunk(x, z, offsetX, offsetz, currentChunk, neighbors);
        if (chunk != null) {
            return Float.valueOf(this.getHeightInSlice(chunk, newX, newZ, sliceMinY, sliceMaxY));
        }
        return Float.valueOf(defaultVal);
    }
}

