/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.io.nbt;

import java.io.DataInputStream;
import java.io.File;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.ChunkMD;

public class ChunkLoader {
    private static Logger logger = JourneyMap.getLogger();

    public static ChunkMD getChunkStubFromDisk(int chunkX, int chunkZ, File worldDir, World world) {
        Chunk chunk = ChunkLoader.getChunkFromDisk(chunkX, chunkZ, worldDir, world);
        if (chunk == null) {
            return null;
        }
        return new ChunkMD(chunk, true, world, true);
    }

    public static ChunkMD getChunkStubFromMemory(int chunkX, int chunkZ, World world) {
        Chunk chunk = ChunkLoader.getChunkFromMemory(chunkX, chunkZ, world);
        if (chunk != null) {
            return new ChunkMD(chunk, (Boolean)true, world);
        }
        return null;
    }

    public static ChunkMD refreshChunkStubFromMemory(ChunkMD chunkMD, World world) {
        Chunk chunk = ChunkLoader.getChunkFromMemory(chunkMD.coord.field_77276_a, chunkMD.coord.field_77275_b, world);
        if (chunk != null) {
            chunkMD.stub.updateFrom(chunk);
            return chunkMD;
        }
        return null;
    }

    public static ChunkMD getChunkStubFromMemory(int chunkX, int chunkZ, Minecraft minecraft) {
        Chunk chunk = ChunkLoader.getChunkFromMemory(chunkX, chunkZ, (World)minecraft.field_71441_e);
        if (chunk != null) {
            return new ChunkMD(chunk, (Boolean)true, (World)minecraft.field_71441_e);
        }
        return null;
    }

    public static Chunk getChunkFromMemory(int chunkX, int chunkZ, World world) {
        Chunk theChunk;
        Chunk result = null;
        if (world.func_72863_F().func_73149_a(chunkX, chunkZ) && !((theChunk = world.func_72964_e(chunkX, chunkZ)) instanceof EmptyChunk) && theChunk.field_76636_d && !theChunk.func_76621_g()) {
            result = theChunk;
        }
        return result;
    }

    public static Chunk getChunkFromDisk(int chunkX, int chunkZ, File worldDir, World world) {
        Chunk chunk = null;
        if (chunk == null) {
            try {
                NBTTagCompound chunkNBT;
                DataInputStream dis = RegionFileCache.func_76549_c((File)worldDir, (int)chunkX, (int)chunkZ);
                if (dis != null && (chunkNBT = CompressedStreamTools.func_74794_a((DataInputStream)dis)) != null && (chunk = ChunkLoader.checkedReadChunkFromNBT(world, chunkX, chunkZ, chunkNBT)) != null) {
                    chunk.func_76590_a();
                    chunk.func_76603_b();
                }
            }
            catch (Throwable t) {
                logger.severe("Error getting chunk from RegionFile: " + LogFormatter.toString(t));
            }
        }
        return chunk;
    }

    protected static Chunk checkedReadChunkFromNBT(World world, int chunkX, int chunkZ, NBTTagCompound par4NBTTagCompound) {
        int par2 = chunkX;
        int par3 = chunkZ;
        if (!par4NBTTagCompound.func_74764_b("Level")) {
            logger.severe("Chunk file at " + par2 + "," + par3 + " is missing level data, skipping");
            return null;
        }
        if (!par4NBTTagCompound.func_74775_l("Level").func_74764_b("Sections")) {
            logger.severe("Chunk file at " + par2 + "," + par3 + " is missing block data, skipping");
            return null;
        }
        Chunk var5 = ChunkLoader.readChunkFromNBT(world, par4NBTTagCompound.func_74775_l("Level"));
        if (!var5.func_76600_a(par2, par3)) {
            logger.severe("Chunk file at " + par2 + "," + par3 + " is in the wrong location; relocating. (Expected " + par2 + ", " + par3 + ", got " + var5.field_76635_g + ", " + var5.field_76647_h + ")");
            par4NBTTagCompound.func_74768_a("xPos", par2);
            par4NBTTagCompound.func_74768_a("zPos", par3);
            var5 = ChunkLoader.readChunkFromNBT(world, par4NBTTagCompound.func_74775_l("Level"));
        }
        return var5;
    }

    private static Chunk readChunkFromNBT(World par1World, NBTTagCompound par2NBTTagCompound) {
        int i = par2NBTTagCompound.func_74762_e("xPos");
        int j = par2NBTTagCompound.func_74762_e("zPos");
        Chunk chunk = new Chunk(par1World, i, j);
        chunk.field_76634_f = par2NBTTagCompound.func_74759_k("HeightMap");
        chunk.field_76646_k = par2NBTTagCompound.func_74767_n("TerrainPopulated");
        chunk.field_150814_l = par2NBTTagCompound.func_74767_n("LightPopulated");
        chunk.field_111204_q = par2NBTTagCompound.func_74763_f("InhabitedTime");
        NBTTagList nbttaglist = par2NBTTagCompound.func_150295_c("Sections", 10);
        int b0 = 16;
        ExtendedBlockStorage[] aextendedblockstorage = new ExtendedBlockStorage[b0];
        boolean flag = !par1World.field_73011_w.field_76576_e;
        for (int k = 0; k < nbttaglist.func_74745_c(); ++k) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(k);
            byte b1 = nbttagcompound1.func_74771_c("Y");
            ExtendedBlockStorage extendedblockstorage = new ExtendedBlockStorage(b1 << 4, flag);
            extendedblockstorage.func_76664_a(nbttagcompound1.func_74770_j("Blocks"));
            if (nbttagcompound1.func_150297_b("Add", 7)) {
                extendedblockstorage.func_76673_a(new NibbleArray(nbttagcompound1.func_74770_j("Add"), 4));
            }
            extendedblockstorage.func_76668_b(new NibbleArray(nbttagcompound1.func_74770_j("Data"), 4));
            extendedblockstorage.func_76659_c(new NibbleArray(nbttagcompound1.func_74770_j("BlockLight"), 4));
            if (flag) {
                extendedblockstorage.func_76666_d(new NibbleArray(nbttagcompound1.func_74770_j("SkyLight"), 4));
            }
            extendedblockstorage.func_76672_e();
            aextendedblockstorage[b1] = extendedblockstorage;
        }
        chunk.func_76602_a(aextendedblockstorage);
        if (par2NBTTagCompound.func_150297_b("Biomes", 7)) {
            chunk.func_76616_a(par2NBTTagCompound.func_74770_j("Biomes"));
        }
        return chunk;
    }
}

