/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class JMThreadFactory
implements ThreadFactory {
    final ThreadGroup group;
    static final AtomicInteger threadNumber = new AtomicInteger(1);
    static final String namePrefix = "JM-";
    final String name;

    public JMThreadFactory(String name) {
        this.name = namePrefix + name;
        SecurityManager securitymanager = System.getSecurityManager();
        this.group = securitymanager == null ? Thread.currentThread().getThreadGroup() : securitymanager.getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String fullName = this.name + "-" + threadNumber.getAndIncrement();
        Thread thread = new Thread(this.group, runnable, fullName);
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }
}

