/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.map;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.VersionCheck;
import net.techbrew.journeymap.io.MapSaver;
import net.techbrew.journeymap.log.ChatLog;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.MapOverlayState;
import net.techbrew.journeymap.properties.FullMapProperties;
import net.techbrew.journeymap.task.MapRegionTask;
import net.techbrew.journeymap.task.SaveMapTask;
import net.techbrew.journeymap.ui.Button;
import net.techbrew.journeymap.ui.ButtonList;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.map.AutoMapConfirmation;
import net.techbrew.journeymap.ui.map.MapOverlay;

public class MapOverlayActions
extends JmUI {
    Button buttonAutomap;
    Button buttonSave;
    Button buttonClose;
    Button buttonBrowser;
    Button buttonCheck;

    public MapOverlayActions() {
        super(Constants.getString("MapOverlay.actions"));
    }

    @Override
    public void func_73866_w_() {
        this.field_146292_n.clear();
        String on = Constants.getString("MapOverlay.on");
        String off = Constants.getString("MapOverlay.off");
        this.buttonSave = new Button(ButtonEnum.Save, Constants.getString("MapOverlay.save_map"));
        this.buttonClose = new Button(ButtonEnum.Close, Constants.getString("MapOverlay.close"));
        this.buttonBrowser = new Button(ButtonEnum.Browser, Constants.getString("MapOverlay.use_browser"));
        this.buttonBrowser.setEnabled(JourneyMap.getInstance().webMapProperties.enabled.get());
        this.buttonAutomap = new Button((Enum)ButtonEnum.Automap, Constants.getString("MapOverlay.automap_title", on), Constants.getString("MapOverlay.automap_title", off), true);
        this.buttonAutomap.setEnabled(Minecraft.func_71410_x().func_71356_B());
        this.buttonCheck = new Button(ButtonEnum.Check, Constants.getString("MapOverlay.update_check"));
        this.field_146292_n.add(this.buttonAutomap);
        this.field_146292_n.add(this.buttonSave);
        this.field_146292_n.add(this.buttonCheck);
        this.field_146292_n.add(this.buttonBrowser);
        new ButtonList(this.field_146292_n).equalizeWidths(this.getFontRenderer());
        this.field_146292_n.add(this.buttonClose);
    }

    @Override
    protected void layoutButtons() {
        if (this.field_146292_n.isEmpty()) {
            this.func_73866_w_();
        }
        this.buttonSave.setEnabled(!JourneyMap.getInstance().isTaskManagerEnabled(MapRegionTask.Manager.class));
        int hgap = 4;
        int vgap = 3;
        int bx = this.field_146294_l / 2;
        int by = this.field_146295_m / 4;
        this.buttonAutomap.leftOf(bx - 2).setY(by);
        this.buttonBrowser.rightOf(this.buttonAutomap, 4).setY(by);
        this.buttonSave.below(this.buttonAutomap, 3).leftOf(bx - 2);
        this.buttonCheck.below(this.buttonBrowser, 3).rightOf(this.buttonSave, 4);
        this.buttonClose.below(this.buttonSave, 12).centerHorizontalOn(bx);
    }

    protected void func_146284_a(GuiButton guibutton) {
        ButtonEnum id = ButtonEnum.values()[guibutton.field_146127_k];
        switch (id) {
            case Save: {
                this.save();
                UIManager.getInstance().openMap();
                break;
            }
            case Close: {
                UIManager.getInstance().openMap();
                break;
            }
            case Browser: {
                MapOverlayActions.launchLocalhost();
                UIManager.getInstance().openMap();
                break;
            }
            case Automap: {
                UIManager.getInstance().open(AutoMapConfirmation.class);
                break;
            }
            case Check: {
                VersionCheck.launchWebsite();
                UIManager.getInstance().openMap();
            }
        }
    }

    public static void launchLocalhost() {
        String url = "http://localhost:" + JourneyMap.getInstance().webMapProperties.port.get();
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (IOException e) {
            JourneyMap.getLogger().log(Level.SEVERE, "Could not launch browser with URL: " + url + ": " + LogFormatter.toString(e));
        }
    }

    void save() {
        FullMapProperties mapProperties = JourneyMap.getInstance().fullMapProperties;
        MapOverlayState state = MapOverlay.state();
        boolean showCaves = JourneyMap.getInstance().fullMapProperties.showCaves.get();
        Constants.MapType mapType = state.getMapType(showCaves);
        Integer vSlice = state.getMapType(showCaves) == Constants.MapType.underground ? state.getVSlice() : null;
        MapSaver mapSaver = new MapSaver(state.getWorldDir(), mapType, vSlice, state.getDimension());
        if (mapSaver.isValid()) {
            JourneyMap.getInstance().toggleTask(SaveMapTask.Manager.class, true, mapSaver);
            ChatLog.announceI18N("MapOverlay.save_filename", mapSaver.getSaveFileName());
        }
        this.close();
    }

    @Override
    protected void func_73869_a(char c, int i) {
        switch (i) {
            case 1: {
                UIManager.getInstance().openMap();
            }
        }
    }

    private static enum ButtonEnum {
        Automap,
        Check,
        Save,
        Browser,
        Close;

    }
}

