/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.map.layer;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.BlockCoordIntPair;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.ui.map.layer.BlockInfoLayer;
import net.techbrew.journeymap.ui.map.layer.WaypointLayer;

public class LayerDelegate {
    private List<DrawStep> drawSteps = new ArrayList<DrawStep>();
    private List<Layer> layers = new ArrayList<Layer>();

    public LayerDelegate() {
        this.layers.add(new BlockInfoLayer());
        this.layers.add(new WaypointLayer());
    }

    public void onMouseMove(Minecraft mc, double mouseX, double mouseY, int gridWidth, int gridHeight, BlockCoordIntPair blockCoord) {
        this.drawSteps.clear();
        for (Layer layer : this.layers) {
            try {
                this.drawSteps.addAll(layer.onMouseMove(mc, mouseX, mouseY, gridWidth, gridHeight, blockCoord));
            }
            catch (Exception e) {
                JourneyMap.getLogger().severe(LogFormatter.toString(e));
            }
        }
    }

    public void onMouseClicked(Minecraft mc, double mouseX, double mouseY, int gridWidth, int gridHeight, BlockCoordIntPair blockCoord, int mouseButton) {
        this.drawSteps.clear();
        for (Layer layer : this.layers) {
            try {
                this.drawSteps.addAll(layer.onMouseClick(mc, mouseX, mouseY, gridWidth, gridHeight, blockCoord));
            }
            catch (Exception e) {
                JourneyMap.getLogger().severe(LogFormatter.toString(e));
            }
        }
    }

    public List<DrawStep> getDrawSteps() {
        return this.drawSteps;
    }

    public static interface Layer {
        public List<DrawStep> onMouseMove(Minecraft var1, double var2, double var4, int var6, int var7, BlockCoordIntPair var8);

        public List<DrawStep> onMouseClick(Minecraft var1, double var2, double var4, int var6, int var7, BlockCoordIntPair var8);
    }
}

