/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.minimap;

import java.awt.Color;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.properties.MiniMapProperties;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;

public class DisplayVars {
    static final MiniMapProperties miniMapProperties = JourneyMap.getInstance().miniMapProperties;
    final Position position;
    final Shape shape;
    final TextureImpl borderTexture;
    final TextureImpl maskTexture;
    final float drawScale;
    final double fontScale;
    final int displayWidth;
    final int displayHeight;
    final ScaledResolution scaledResolution;
    final double minimapSize;
    final double textureX;
    final double textureY;
    final double minimapOffset;
    final double translateX;
    final double translateY;
    final double marginX;
    final double marginY;
    final double scissorX;
    final double scissorY;
    final double viewPortPadX;
    final double viewPortPadY;
    final boolean showFps;
    final LabelVars labelFps;
    final LabelVars labelLocation;
    final LabelVars labelBiome;
    boolean forceUnicode;

    DisplayVars(Minecraft mc, Shape shape, Position position, double labelFontScale) {
        this.scaledResolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        this.forceUnicode = JourneyMap.getInstance().miniMapProperties.forceUnicode.get();
        this.showFps = JourneyMap.getInstance().miniMapProperties.showFps.get();
        this.shape = shape;
        this.position = position;
        this.displayWidth = mc.field_71443_c;
        this.displayHeight = mc.field_71440_d;
        boolean useFontShadow = false;
        boolean wasUnicode = mc.field_71466_p.func_82883_a();
        boolean useUnicode = this.forceUnicode || wasUnicode;
        this.fontScale = labelFontScale * (double)(useUnicode ? 2 : 1);
        double labelHeight = (double)DrawUtil.getLabelHeight(mc.field_71466_p, false) * (useUnicode ? 0.7 : 1.0) * this.fontScale;
        double bottomTextureYMargin = 0.0;
        boolean labelsOutside = false;
        boolean scissorFps = true;
        boolean scissorLocation = false;
        boolean scissorBiome = true;
        double yOffsetFps = 4.0;
        double yOffsetBiome = -3.0;
        double yOffsetLocation = yOffsetBiome + -labelHeight;
        DrawUtil.VAlign valignFps = DrawUtil.VAlign.Below;
        DrawUtil.VAlign valignLocation = DrawUtil.VAlign.Above;
        DrawUtil.VAlign valignBiome = DrawUtil.VAlign.Above;
        float textureScale = DisplayVars.miniMapProperties.textureSmall.get() ? 0.75f : 1.0f;
        switch (shape) {
            case LargeCircle: {
                this.drawScale = 1.0f * textureScale;
                this.borderTexture = TextureCache.instance().getMinimapLargeCircle();
                this.maskTexture = TextureCache.instance().getMinimapLargeCircleMask();
                this.minimapSize = 512.0;
                this.marginX = 3.0;
                this.marginY = 3.0;
                this.viewPortPadX = 5.0;
                this.viewPortPadY = 5.0;
                if (this.fontScale == 1.0) {
                    bottomTextureYMargin = 10.0;
                    break;
                }
                bottomTextureYMargin = 20.0;
                break;
            }
            case SmallCircle: {
                this.drawScale = 1.0f * textureScale;
                this.borderTexture = TextureCache.instance().getMinimapSmallCircle();
                this.maskTexture = TextureCache.instance().getMinimapSmallCircleMask();
                this.minimapSize = 256.0;
                this.marginX = 2.0;
                this.marginY = 2.0;
                this.viewPortPadX = 5.0;
                this.viewPortPadY = 5.0;
                if (this.fontScale == 1.0) {
                    bottomTextureYMargin = 14.0;
                    break;
                }
                bottomTextureYMargin = 24.0;
                break;
            }
            case LargeSquare: {
                this.drawScale = 1.0f * textureScale;
                this.borderTexture = TextureCache.instance().getMinimapLargeSquare();
                this.maskTexture = null;
                this.minimapSize = 512.0;
                this.marginX = 0.0;
                this.marginY = 0.0;
                this.viewPortPadX = 5.0;
                this.viewPortPadY = 5.0;
                yOffsetFps = 5.0;
                yOffsetLocation = -5.0;
                yOffsetBiome = yOffsetLocation - labelHeight;
                break;
            }
            case SmallSquare: {
                this.drawScale = 1.0f * textureScale;
                this.borderTexture = TextureCache.instance().getMinimapSmallSquare();
                this.maskTexture = null;
                this.minimapSize = 128.0;
                this.marginX = 0.0;
                this.marginY = 0.0;
                this.viewPortPadX = 2.0;
                this.viewPortPadY = 2.0;
                valignLocation = DrawUtil.VAlign.Below;
                valignBiome = DrawUtil.VAlign.Below;
                yOffsetFps = 3.0;
                yOffsetLocation = 1.0;
                yOffsetBiome = yOffsetLocation + labelHeight;
                scissorLocation = false;
                scissorBiome = false;
                labelsOutside = true;
                break;
            }
            default: {
                this.drawScale = 1.0f * textureScale;
                this.borderTexture = TextureCache.instance().getMinimapMediumSquare();
                this.maskTexture = null;
                this.minimapSize = 256.0;
                this.marginX = 0.0;
                this.marginY = 0.0;
                this.viewPortPadX = 4.0;
                this.viewPortPadY = 5.0;
                yOffsetFps = 5.0;
                yOffsetLocation = -5.0;
                yOffsetBiome = yOffsetLocation - labelHeight;
            }
        }
        this.minimapOffset = this.minimapSize * 0.5;
        switch (position) {
            case BottomRight: {
                this.textureX = (double)(mc.field_71443_c - this.borderTexture.width) - this.marginX;
                this.textureY = (double)(mc.field_71440_d - this.borderTexture.height) - this.marginY - bottomTextureYMargin;
                this.translateX = (double)(mc.field_71443_c / 2) - this.minimapOffset;
                this.translateY = (double)(mc.field_71440_d / 2) - this.minimapOffset - bottomTextureYMargin;
                this.scissorX = (double)mc.field_71443_c - this.minimapSize - this.marginX;
                this.scissorY = this.marginY + bottomTextureYMargin;
                if (!labelsOutside) break;
                yOffsetLocation = -this.minimapSize;
                valignLocation = DrawUtil.VAlign.Above;
                valignBiome = DrawUtil.VAlign.Above;
                yOffsetBiome = yOffsetLocation - labelHeight;
                break;
            }
            case TopLeft: {
                this.textureX = this.marginX;
                this.textureY = this.marginY;
                this.translateX = (double)(-(mc.field_71443_c / 2)) + this.minimapOffset;
                this.translateY = (double)(-(mc.field_71440_d / 2)) + this.minimapOffset;
                this.scissorX = this.marginX;
                this.scissorY = (double)mc.field_71440_d - this.minimapSize - this.marginY;
                break;
            }
            case BottomLeft: {
                this.textureX = this.marginX;
                this.textureY = (double)(mc.field_71440_d - this.borderTexture.height) - this.marginY - bottomTextureYMargin;
                this.translateX = (double)(-(mc.field_71443_c / 2)) + this.minimapOffset;
                this.translateY = (double)(mc.field_71440_d / 2) - this.minimapOffset - bottomTextureYMargin;
                this.scissorX = this.marginX;
                this.scissorY = this.marginY + bottomTextureYMargin;
                if (!labelsOutside) break;
                yOffsetLocation = -this.minimapSize;
                valignLocation = DrawUtil.VAlign.Above;
                valignBiome = DrawUtil.VAlign.Above;
                yOffsetBiome = yOffsetLocation - labelHeight;
                break;
            }
            default: {
                this.textureX = (double)(mc.field_71443_c - this.borderTexture.width) + this.marginX;
                this.textureY = this.marginY;
                this.translateX = (double)(mc.field_71443_c / 2) - this.minimapOffset;
                this.translateY = (double)(-(mc.field_71440_d / 2)) + this.minimapOffset;
                this.scissorX = (double)mc.field_71443_c - this.minimapSize - this.marginX;
                this.scissorY = (double)mc.field_71440_d - this.minimapSize - this.marginY;
            }
        }
        double centerX = this.textureX + this.minimapSize / 2.0;
        double topY = this.textureY;
        double bottomY = this.textureY + this.minimapSize;
        this.labelFps = new LabelVars(centerX, topY + yOffsetFps, DrawUtil.HAlign.Center, valignFps, this.fontScale, scissorFps, false);
        this.labelLocation = new LabelVars(centerX, bottomY + yOffsetLocation, DrawUtil.HAlign.Center, valignLocation, this.fontScale, scissorLocation, false);
        this.labelBiome = new LabelVars(centerX, bottomY + yOffsetBiome, DrawUtil.HAlign.Center, valignBiome, this.fontScale, scissorBiome, false);
    }

    class LabelVars {
        final double x;
        final double y;
        DrawUtil.HAlign hAlign;
        DrawUtil.VAlign vAlign;
        final double fontScale;
        final boolean scissor;
        final boolean fontShadow;

        private LabelVars(double x, double y, DrawUtil.HAlign hAlign, DrawUtil.VAlign vAlign, double fontScale, boolean scissor, boolean fontShadow) {
            this.x = x;
            this.y = y;
            this.hAlign = hAlign;
            this.vAlign = vAlign;
            this.fontScale = fontScale;
            this.scissor = scissor;
            this.fontShadow = fontShadow;
        }

        void draw(String text, Color bgColor, int bgAlpha, Color color, int alpha) {
            boolean isUnicode = false;
            FontRenderer fontRenderer = null;
            if (DisplayVars.this.forceUnicode && !(isUnicode = (fontRenderer = Minecraft.func_71410_x().field_71466_p).func_82883_a())) {
                fontRenderer.func_78264_a(true);
            }
            DrawUtil.drawLabel(text, this.x, this.y, this.hAlign, this.vAlign, bgColor, bgAlpha, color, alpha, this.fontScale, this.fontShadow);
            if (DisplayVars.this.forceUnicode && !isUnicode) {
                fontRenderer.func_78264_a(false);
            }
        }
    }

    public static enum Shape {
        SmallSquare("MiniMap.shape_smallsquare"),
        MediumSquare("MiniMap.shape_mediumsquare"),
        LargeSquare("MiniMap.shape_largesquare"),
        SmallCircle("MiniMap.shape_smallcircle"),
        LargeCircle("MiniMap.shape_largecircle");

        public final String label;
        public static Shape[] Enabled;

        private Shape(String label) {
            this.label = label;
        }

        public static Shape getPreferred() {
            Shape shape = null;
            try {
                shape = DisplayVars.miniMapProperties.shape.get();
            }
            catch (IllegalArgumentException e) {
                JourneyMap.getLogger().warning("Not a valid minimap shape in : " + miniMapProperties.getFile());
            }
            if (shape == null) {
                shape = MediumSquare;
                DisplayVars.miniMapProperties.shape.set(shape);
                miniMapProperties.save();
            }
            return shape;
        }

        public static Shape safeValueOf(String name) {
            Shape value = null;
            try {
                value = Shape.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                JourneyMap.getLogger().warning("Not a valid minimap shape: " + name);
            }
            if (value == null || !value.isEnabled()) {
                value = MediumSquare;
            }
            return value;
        }

        public boolean isEnabled() {
            return Arrays.binarySearch((Object[])Enabled, (Object)this) >= 0;
        }

        static {
            Enabled = new Shape[]{SmallSquare, MediumSquare, LargeSquare};
        }
    }

    public static enum Position {
        TopRight("MiniMap.position_topright"),
        BottomRight("MiniMap.position_bottomright"),
        BottomLeft("MiniMap.position_bottomleft"),
        TopLeft("MiniMap.position_topleft");

        public final String label;

        public static Position getPreferred() {
            Position position = null;
            try {
                position = DisplayVars.miniMapProperties.position.get();
            }
            catch (IllegalArgumentException e) {
                JourneyMap.getLogger().warning("Not a valid minimap position in : " + miniMapProperties.getFile());
            }
            if (position == null) {
                position = TopRight;
                DisplayVars.miniMapProperties.position.set(position);
                miniMapProperties.save();
            }
            return position;
        }

        public static Position safeValueOf(String name) {
            Position value = null;
            try {
                value = Position.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                JourneyMap.getLogger().warning("Not a valid minimap position: " + name);
            }
            if (value == null) {
                value = TopRight;
            }
            return value;
        }

        private Position(String label) {
            this.label = label;
        }
    }
}

