/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.waypoint;

import java.awt.Color;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.command.CmdTeleportWaypoint;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.ui.Button;
import net.techbrew.journeymap.ui.ButtonList;
import net.techbrew.journeymap.ui.ScrollPane;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.map.MapOverlay;
import net.techbrew.journeymap.ui.waypoint.WaypointManager;
import net.techbrew.journeymap.waypoint.WaypointStore;

public class WaypointManagerItem
implements ScrollPane.Scrollable {
    final FontRenderer fontRenderer;
    final WaypointManager manager;
    int x;
    int y;
    int width;
    int internalWidth;
    Integer distance;
    Waypoint waypoint;
    Button buttonEnable;
    Button buttonRemove;
    Button buttonEdit;
    Button buttonFind;
    Button buttonTeleport;
    int hgap = 4;
    ButtonList buttonListLeft;
    ButtonList buttonListRight;
    static Color background = new Color(20, 20, 20);
    static Color backgroundHover = new Color(40, 40, 40);

    public WaypointManagerItem(Waypoint waypoint, FontRenderer fontRenderer, WaypointManager manager) {
        int id = 0;
        this.waypoint = waypoint;
        this.fontRenderer = fontRenderer;
        this.manager = manager;
        String on = Constants.getString("MapOverlay.on");
        String off = Constants.getString("MapOverlay.off");
        this.buttonEnable = new Button(id++, on, off, true);
        this.buttonEnable.setToggled(waypoint.isEnable());
        this.buttonFind = new Button(id++, Constants.getString("Waypoint.find"));
        this.buttonTeleport = new Button(id++, Constants.getString("Waypoint.teleport"));
        this.buttonTeleport.setDrawButton(manager.canUserTeleport);
        this.buttonTeleport.setEnabled(manager.canUserTeleport);
        this.buttonListLeft = new ButtonList(this.buttonEnable, this.buttonFind, this.buttonTeleport);
        this.buttonListLeft.setHeights(manager.rowHeight);
        this.buttonListLeft.fitWidths(fontRenderer);
        this.buttonEdit = new Button(id++, Constants.getString("Waypoint.edit"));
        this.buttonRemove = new Button(id++, Constants.getString("Waypoint.remove"));
        this.buttonListRight = new ButtonList(this.buttonEdit, this.buttonRemove);
        this.buttonListRight.setHeights(manager.rowHeight);
        this.buttonListRight.fitWidths(fontRenderer);
        this.internalWidth = fontRenderer.func_78263_a('X') * 32;
        this.internalWidth += Math.max(manager.colLocation, manager.colName);
        this.internalWidth += this.buttonListLeft.getWidth(this.hgap);
        this.internalWidth += this.buttonListRight.getWidth(this.hgap);
        this.internalWidth += 10;
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getFitWidth(FontRenderer fr) {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.manager.rowHeight;
    }

    @Override
    public void drawPartialScrollable(Minecraft mc, int x, int y, int width, int height) {
        DrawUtil.drawRectangle(this.x, this.y, this.width, this.manager.rowHeight, background, 100);
    }

    @Override
    public void drawScrollable(Minecraft mc, int mouseX, int mouseY) {
        if (this.waypoint == null) {
            return;
        }
        boolean hover = this.manager.isSelected(this) || mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.manager.rowHeight;
        this.buttonListLeft.setOptions(true, hover, true);
        this.buttonListRight.setOptions(true, hover, true);
        Color color = hover ? backgroundHover : background;
        int alpha = hover ? 255 : 100;
        DrawUtil.drawRectangle(this.x, this.y, this.width, this.manager.rowHeight, color, alpha);
        int margin = this.manager.getMargin();
        this.drawWaypoint(this.x + margin + this.manager.colWaypoint, this.y + this.manager.rowHeight / 2);
        this.drawLabels(mc, this.x + margin, this.y, null);
        this.buttonFind.setEnabled(this.waypoint.isInPlayerDimension());
        this.buttonTeleport.setEnabled(this.waypoint.isTeleportReady());
        this.buttonListRight.layoutHorizontal(this.x + this.width - margin, this.y, false, this.hgap).draw(mc, mouseX, mouseY);
        this.buttonListLeft.layoutHorizontal(this.buttonListRight.getLeftX() - this.hgap * 2, this.y, false, this.hgap).draw(mc, mouseX, mouseY);
    }

    protected void drawLabels(Minecraft mc, int x, int y, Color color) {
        boolean waypointValid;
        if (this.waypoint == null) {
            return;
        }
        boolean bl = waypointValid = this.waypoint.isEnable() && this.waypoint.isInPlayerDimension();
        if (color == null) {
            color = waypointValid ? this.waypoint.getSafeColor() : Color.GRAY;
        }
        int yOffset = 1 + (this.manager.rowHeight - mc.field_71466_p.field_78288_b) / 2;
        mc.field_71466_p.func_78261_a(String.format("%sm", this.getDistance()), x + this.manager.colLocation, y + yOffset, color.getRGB());
        String name = waypointValid ? this.waypoint.getName() : EnumChatFormatting.STRIKETHROUGH + this.waypoint.getName();
        mc.field_71466_p.func_78261_a(name, x + this.manager.colName, y + yOffset, color.getRGB());
    }

    protected void drawWaypoint(int x, int y) {
        TextureImpl wpTexture = this.waypoint.getTexture();
        DrawUtil.drawColoredImage(wpTexture, 255, this.waypoint.getColor(), x, y - wpTexture.height / 2);
    }

    protected void enableWaypoint(boolean enable) {
        this.buttonEnable.setToggled(enable);
        this.waypoint.setEnable(enable);
    }

    protected int getButtonEnableCenterX() {
        return this.buttonEnable.getX() + this.buttonEnable.getWidth() / 2;
    }

    @Override
    public void clickScrollable(Minecraft mc, int mouseX, int mouseY) {
        if (this.waypoint == null) {
            return;
        }
        if (this.buttonRemove.mouseOver(mouseX, mouseY)) {
            this.manager.removeWaypoint(this);
            this.waypoint = null;
        } else if (this.buttonEnable.mouseOver(mouseX, mouseY)) {
            this.buttonEnable.toggle();
            this.waypoint.setEnable(this.buttonEnable.getToggled());
            if (this.waypoint.isDirty()) {
                WaypointStore.instance().save(this.waypoint);
            }
        } else if (this.buttonEdit.mouseOver(mouseX, mouseY)) {
            UIManager.getInstance().openWaypointEditor(this.waypoint, false, WaypointManager.class);
        } else if (this.buttonFind.isEnabled() && this.buttonFind.mouseOver(mouseX, mouseY)) {
            UIManager.getInstance().openMap(this.waypoint);
        } else if (this.manager.canUserTeleport.booleanValue() && this.buttonTeleport.mouseOver(mouseX, mouseY)) {
            new CmdTeleportWaypoint(this.waypoint).run();
            MapOverlay.state().follow = true;
            UIManager.getInstance().closeAll();
            return;
        }
    }

    public int getDistance() {
        return this.distance == null ? 0 : this.distance;
    }

    public int getDistanceTo(EntityPlayer player) {
        if (this.distance == null) {
            this.distance = (int)player.func_70666_h(1.0f).func_72438_d(this.waypoint.getPosition());
        }
        return this.distance;
    }

    static class DistanceComparator
    extends Sort {
        EntityPlayer player;

        public DistanceComparator(EntityPlayer player, boolean ascending) {
            super(ascending);
            this.player = player;
        }

        @Override
        public int compare(WaypointManagerItem o1, WaypointManagerItem o2) {
            double dist1 = o1.getDistanceTo(this.player);
            double dist2 = o2.getDistanceTo(this.player);
            if (this.ascending) {
                return Double.compare(dist1, dist2);
            }
            return Double.compare(dist2, dist1);
        }
    }

    static class NameComparator
    extends Sort {
        public NameComparator(boolean ascending) {
            super(ascending);
        }

        @Override
        public int compare(WaypointManagerItem o1, WaypointManagerItem o2) {
            if (this.ascending) {
                return o1.waypoint.getName().compareTo(o2.waypoint.getName());
            }
            return o2.waypoint.getName().compareTo(o1.waypoint.getName());
        }
    }

    static abstract class Sort
    implements Comparator<WaypointManagerItem> {
        boolean ascending;

        Sort(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.ascending ? 1 : 0;
        }
    }
}

