/*
 * Decompiled with CFR 0.152.
 */
package se.rupy.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import se.rupy.http.Chain;
import se.rupy.http.Daemon;
import se.rupy.http.Deploy;
import se.rupy.http.Failure;
import se.rupy.http.Input;
import se.rupy.http.Output;
import se.rupy.http.Query;
import se.rupy.http.Reply;
import se.rupy.http.Service;
import se.rupy.http.Session;
import se.rupy.http.Worker;

public class Event
extends Throwable
implements Chain.Link {
    public static final boolean LOG = true;
    static int READ = 1;
    static int WRITE = 4;
    static int VERBOSE = 1;
    static int DEBUG = 2;
    private static char[] BASE_24 = new char[]{'B', 'C', 'D', 'F', 'G', 'H', 'J', 'K', 'M', 'P', 'Q', 'R', 'T', 'V', 'W', 'X', 'Y', '2', '3', '4', '6', '7', '8', '9'};
    static Mime MIME = new Mime();
    private SocketChannel channel;
    private SelectionKey key;
    private Query query;
    private Reply reply;
    private Session session;
    private Daemon daemon;
    private Worker worker;
    private int index;
    private int interest;
    private String remote;
    private boolean close;
    private long touch;

    protected Event(Daemon daemon, SelectionKey key, int index) throws IOException {
        this.touch();
        this.channel = ((ServerSocketChannel)key.channel()).accept();
        this.channel.configureBlocking(false);
        this.daemon = daemon;
        this.index = index;
        this.query = new Query(this);
        this.reply = new Reply(this);
        key = this.channel.register(key.selector(), READ, this);
        key.selector().wakeup();
        this.key = key;
    }

    protected int interest() {
        return this.interest;
    }

    protected void interest(int interest) {
        this.interest = interest;
    }

    public Daemon daemon() {
        return this.daemon;
    }

    public Query query() {
        return this.query;
    }

    public Reply reply() {
        return this.reply;
    }

    public Session session() {
        return this.session;
    }

    public String remote() {
        return this.remote;
    }

    public boolean close() {
        return this.close;
    }

    public Worker worker() {
        return this.worker;
    }

    @Override
    public int index() {
        return this.index;
    }

    protected void close(boolean close) {
        this.close = close;
    }

    protected void worker(Worker worker) {
        this.worker = worker;
        try {
            this.register(READ);
        }
        catch (CancelledKeyException e) {
            this.disconnect(e);
        }
    }

    protected SocketChannel channel() {
        return this.channel;
    }

    protected void log(Object o) {
        this.log(o, DEBUG);
    }

    protected void log(Object o, int level) {
        if (o instanceof Exception && this.daemon.debug) {
            this.daemon.out.print("[" + (this.worker == null ? "*" : "" + this.worker.index()) + "-" + this.index + "] ");
            ((Exception)o).printStackTrace(this.daemon.out);
        } else if (this.daemon.debug || this.daemon.verbose && level == VERBOSE) {
            this.daemon.out.println("[" + (this.worker == null ? "*" : "" + this.worker.index()) + "-" + this.index + "] " + o);
        }
    }

    public long big(String key) {
        return this.query.big(key);
    }

    public int medium(String key) {
        return this.query.medium(key);
    }

    public short small(String key) {
        return this.query.small(key);
    }

    public byte tiny(String key) {
        return this.query.tiny(key);
    }

    public boolean bit(String key) {
        return this.query.bit(key, true);
    }

    public String string(String key) {
        return this.query.string(key);
    }

    public Input input() {
        return this.query.input();
    }

    public Output output() throws IOException {
        return this.reply.output();
    }

    protected void read() throws IOException {
        this.touch();
        if (!this.query.headers()) {
            this.disconnect(null);
        }
        this.remote = this.address();
        if (this.query.version() == null || !this.query.version().equalsIgnoreCase("HTTP/1.1")) {
            this.reply.code("505 Not Supported");
        } else if (!(this.service(this.daemon.chain(this.query)) || this.content() || this.service(this.daemon.chain("null")))) {
            this.reply.code("404 Not Found");
            this.reply.output().print("<pre>'" + this.query.path() + "' was not found.</pre>");
        }
        this.finish();
    }

    protected String address() {
        String remote = this.query.header("x-forwarded-for");
        if (remote == null) {
            InetSocketAddress address = (InetSocketAddress)this.channel.socket().getRemoteSocketAddress();
            remote = address.getAddress().getHostAddress();
        }
        this.log("remote " + remote, VERBOSE);
        return remote;
    }

    protected boolean content() throws IOException {
        Deploy.Stream stream = this.daemon.content(this.query);
        if (stream == null) {
            return false;
        }
        String type = MIME.content(this.query.path(), "application/octet-stream");
        this.reply.type(type);
        this.reply.modified(stream.date());
        if (this.query.modified() == 0L || this.query.modified() < this.reply.modified()) {
            Deploy.pipe(stream.input(), this.reply.output(stream.length()));
            this.log("content " + type, VERBOSE);
        } else {
            this.reply.code("304 Not Modified");
        }
        return true;
    }

    protected boolean service(Chain chain) throws IOException {
        if (chain == null) {
            return false;
        }
        try {
            chain.filter(this);
        }
        catch (Failure f) {
            throw f;
        }
        catch (Event e) {
        }
        catch (Exception e) {
            this.log(e);
            this.daemon.error(this, e);
            StringWriter trace = new StringWriter();
            PrintWriter print = new PrintWriter(trace);
            e.printStackTrace(print);
            this.reply.code("500 Internal Server Error");
            this.reply.output().print("<pre>" + trace.toString() + "</pre>");
        }
        return true;
    }

    protected void write() throws IOException {
        this.touch();
        this.service(this.daemon.chain(this.query));
        this.finish();
    }

    private void finish() throws IOException {
        String log = this.daemon.access(this);
        this.reply.done();
        this.query.done();
        if (log != null) {
            this.daemon.access(log, this.reply.push());
        }
    }

    protected void register() throws IOException {
        if (this.interest != this.key.interestOps()) {
            this.log((this.interest == READ ? "read" : "write") + " prereg " + this.interest + " " + this.key.interestOps() + " " + this.key.readyOps(), DEBUG);
            this.key = this.channel.register(this.key.selector(), this.interest, this);
            this.log((this.interest == READ ? "read" : "write") + " postreg " + this.interest + " " + this.key.interestOps() + " " + this.key.readyOps(), DEBUG);
        }
        this.key.selector().wakeup();
        this.log((this.interest == READ ? "read" : "write") + " wakeup", DEBUG);
    }

    protected void register(int interest) {
        this.interest(interest);
        try {
            if (this.channel.isOpen()) {
                this.register();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected int block(Block block) throws Exception {
        long max = System.currentTimeMillis() + (long)this.daemon.delay;
        while (System.currentTimeMillis() < max) {
            this.register();
            int available = block.fill(true);
            if (available > 0) {
                long delay = (long)this.daemon.delay - (max - System.currentTimeMillis());
                this.log("delay " + delay + " " + available, VERBOSE);
                return available;
            }
            Thread.yield();
            this.worker.snooze(10L);
            this.key.selector().wakeup();
        }
        throw new Exception("IO timeout. (" + this.daemon.delay + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect(Exception e) {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.key != null) {
                this.key.cancel();
            }
            if (this.session != null) {
                this.session.remove(this);
            }
            if (this.daemon.debug) {
                this.log("disconnect " + e);
                if (e != null) {
                    e.printStackTrace();
                }
            }
            this.daemon.error(this, e);
        }
        catch (Exception de) {
            de.printStackTrace(this.daemon.out);
        }
        finally {
            this.daemon.events.remove(new Integer(this.index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void session(final Service service) throws Exception {
        Serializable i;
        String key = Event.cookie(this.query.header("cookie"), "key");
        if (key == null && this.query.method() == 1) {
            this.query.parse();
            String cookie = this.query.string("cookie");
            String string = key = cookie.length() > 0 ? cookie : null;
        }
        if (key != null) {
            this.session = (Session)this.daemon.session().get(key);
            if (this.session != null) {
                this.log("old key " + key, VERBOSE);
                this.session.add(this);
                this.session.touch();
                return;
            }
        }
        int index = 0;
        if (this.daemon.host) {
            i = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Integer(service.index());
                }
            }, this.daemon.control);
            index = i;
        } else {
            index = service.index();
        }
        if (index == 0 && !this.push()) {
            this.session = new Session(this.daemon);
            this.session.add(service);
            this.session.add(this);
            this.session.key(key);
            if (this.session.key() == null) {
                do {
                    key = Event.random(this.daemon.cookie);
                } while (this.daemon.session().get(key) != null);
                this.session.key(key);
            }
            i = this.daemon.session();
            synchronized (i) {
                this.log("new key " + this.session.key(), VERBOSE);
                this.daemon.session().put(this.session.key(), this.session);
            }
        }
        try {
            service.session(this.session, 1);
        }
        catch (Exception e) {
            e.printStackTrace(this.daemon.out);
        }
    }

    protected static String cookie(String cookie, String key) {
        String value = null;
        if (cookie != null) {
            StringTokenizer tokenizer = new StringTokenizer(cookie, " ");
            while (tokenizer.hasMoreTokens()) {
                String part = tokenizer.nextToken();
                int equals = part.indexOf("=");
                if (equals <= -1 || !part.substring(0, equals).equals(key)) continue;
                String subpart = part.substring(equals + 1);
                int index = subpart.indexOf(";");
                if (index > 0) {
                    value = subpart.substring(0, index);
                    continue;
                }
                value = subpart;
            }
        }
        return value;
    }

    public static String random(int length) {
        Random random = new Random();
        StringBuffer buffer = new StringBuffer();
        while (buffer.length() < length) {
            buffer.append(BASE_24[Math.abs(random.nextInt() % 24)]);
        }
        return buffer.toString();
    }

    @Override
    public String toString() {
        return String.valueOf(this.index);
    }

    public boolean push() {
        return this.reply.output.push();
    }

    public void touch() {
        this.touch = System.currentTimeMillis();
        if (this.worker != null) {
            this.worker.touch();
        }
    }

    protected long last() {
        return this.touch;
    }

    public void hold() throws IOException {
        this.reply.output.push = true;
    }

    static {
        READ = 1;
        WRITE = 4;
    }

    static class Mime
    extends Properties {
        public Mime() {
            try {
                this.load(Mime.class.getResourceAsStream("mime.txt"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        String content(String path, String fail) {
            int index = path.lastIndexOf(46) + 1;
            if (index > 0) {
                return this.getProperty(path.substring(index), fail);
            }
            return fail;
        }
    }

    static interface Block {
        public int fill(boolean var1) throws IOException;
    }
}

