/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability$Update;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.AbilityAttribute;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.AbilityProjectile;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityExplosion;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.network.PacketAbilitySync;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.api.telemetry.WyTelemetry;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketShounenScream;

public class Ability {
    protected AbilityProjectile projectile;
    protected String originalDisplayName = "n/a";
    protected AbilityAttribute attr;
    protected boolean isOnCooldown = false;
    protected boolean isCharging = false;
    protected boolean isRepeating = false;
    protected boolean passiveActive = false;
    protected boolean isDisabled = false;
    private int ticksForCooldown;
    private int ticksForCharge;
    private int ticksForRepeater;
    private int ticksForRepeaterFreq;
    private int currentSpawn = 0;

    public Ability(AbilityAttribute abilityAttribute) {
        this.attr = new AbilityAttribute(abilityAttribute);
        this.ticksForCooldown = this.attr.getAbilityCooldown();
        this.ticksForCharge = this.attr.getAbilityCharges();
        this.ticksForRepeater = this.attr.getAbilityCooldown();
        this.ticksForRepeaterFreq = this.attr.getAbilityRepeaterFrequency();
        this.originalDisplayName = this.attr.getAbilityDisplayName();
    }

    public AbilityAttribute getAttribute() {
        return this.attr;
    }

    public void use(EntityPlayer entityPlayer) {
        if (!this.isOnCooldown) {
            Object object;
            if (this.projectile != null) {
                if (this.attr.isRepeater()) {
                    this.startRepeater(entityPlayer);
                } else {
                    entityPlayer.field_70170_p.func_72838_d((Entity)this.projectile);
                }
            }
            if (this.attr.getPotionEffectsForUser() != null) {
                for (PotionEffect potionEffect : this.attr.getPotionEffectsForUser()) {
                    entityPlayer.func_70690_d(new PotionEffect(potionEffect));
                }
            }
            if (this.attr.getPotionEffectsForAoE() != null) {
                for (PotionEffect potionEffect : this.attr.getPotionEffectsForAoE()) {
                    for (EntityLivingBase entityLivingBase : WyHelper.getEntitiesNear((Entity)entityPlayer, (double)this.attr.getEffectRadius())) {
                        entityLivingBase.func_70690_d(new PotionEffect(potionEffect));
                    }
                }
            }
            if (this.attr.getAbilityCharges() <= 0 && this.attr.getAbilityExplosionPower() > 0) {
                object = WyHelper.newExplosion((Entity)entityPlayer, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, this.attr.getAbilityExplosionPower());
                ((AbilityExplosion)object).setDamageOwner(false);
                ((AbilityExplosion)object).setFireAfterExplosion(this.attr.canAbilityExplosionSetFire());
                ((AbilityExplosion)object).setDestroyBlocks(this.attr.canAbilityExplosionDestroyBlocks());
                ((AbilityExplosion)object).doExplosion();
            }
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                WyTelemetry.addAbilityStat(this.getAttribute().getAbilityTexture(), this.getAttribute().getAttributeName(), 1);
            }
            object = ExtendedEntityData.get((EntityLivingBase)entityPlayer);
            AbilityProperties abilityProperties = AbilityProperties.get(entityPlayer);
            ((ExtendedEntityData)object).setTempPreviousAbility(WyHelper.getFancyName(this.attr.getAttributeName()));
            if (!this.attr.isPassive()) {
                this.sendShounenScream(entityPlayer);
            }
            this.duringRepeater(entityPlayer);
            this.startCooldown();
            WyNetworkHelper.sendTo(new PacketAbilitySync(abilityProperties), (EntityPlayerMP)entityPlayer);
            new Ability$Update(this, entityPlayer, this.attr).start();
        }
    }

    public void duringRepeater(EntityPlayer entityPlayer) {
        if (this.isRepeating) {
            try {
                if (!entityPlayer.field_70170_p.field_72995_K && this.currentSpawn % this.ticksForRepeaterFreq == 0) {
                    entityPlayer.field_70170_p.func_72838_d((Entity)((Object)((Object)this.projectile)).getClass().getDeclaredConstructor(World.class, EntityLivingBase.class, AbilityAttribute.class).newInstance(entityPlayer.field_70170_p, entityPlayer, this.attr));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++this.currentSpawn;
        }
    }

    protected void startRepeater(EntityPlayer entityPlayer) {
        this.isRepeating = true;
    }

    public boolean isRepeating() {
        return this.isRepeating;
    }

    public void passive(EntityPlayer entityPlayer) {
        if (!this.isOnCooldown) {
            if (this.passiveActive) {
                this.passiveActive = false;
                WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(entityPlayer)), (EntityPlayerMP)entityPlayer);
                if (this.attr.getPotionEffectsForUser() != null) {
                    for (PotionEffect potionEffect : this.attr.getPotionEffectsForUser()) {
                        entityPlayer.func_82170_o(potionEffect.func_76456_a());
                    }
                }
                this.endPassive(entityPlayer);
            } else {
                this.passiveActive = true;
                WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(entityPlayer)), (EntityPlayerMP)entityPlayer);
                if (this.attr.getPotionEffectsForUser() != null) {
                    for (PotionEffect potionEffect : this.attr.getPotionEffectsForUser()) {
                        entityPlayer.func_70690_d(new PotionEffect(potionEffect.func_76456_a(), Integer.MAX_VALUE, potionEffect.func_76458_c(), true));
                    }
                }
                this.sendShounenScream(entityPlayer);
                this.startPassive(entityPlayer);
                new Ability$Update(this, entityPlayer, this.attr).start();
            }
        }
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void disable(EntityPlayer entityPlayer, boolean bl) {
        this.isDisabled = bl;
        WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(entityPlayer)), (EntityPlayerMP)entityPlayer);
    }

    public void endPassive(EntityPlayer entityPlayer) {
        if (this.attr.getPotionEffectsForUser() != null) {
            for (PotionEffect potionEffect : this.attr.getPotionEffectsForUser()) {
                entityPlayer.func_82170_o(potionEffect.func_76456_a());
            }
        }
    }

    public void startPassive(EntityPlayer entityPlayer) {
    }

    public void duringPassive(EntityPlayer entityPlayer, int n) {
    }

    public boolean isPassiveActive() {
        return this.passiveActive;
    }

    public void setPassiveActive(boolean bl) {
        this.passiveActive = bl;
    }

    public void setChargeActive(boolean bl) {
        this.isCharging = bl;
    }

    public void setCooldownActive(boolean bl) {
        this.isOnCooldown = bl;
    }

    public void duringCharging(EntityPlayer entityPlayer, int n) {
    }

    public void startCharging(EntityPlayer entityPlayer) {
        if (!this.isOnCooldown) {
            this.sendShounenScream(entityPlayer, 1);
            this.isCharging = true;
            WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(entityPlayer)), (EntityPlayerMP)entityPlayer);
            new Ability$Update(this, entityPlayer, this.attr).start();
        }
    }

    public void endCharging(EntityPlayer entityPlayer) {
        this.isCharging = false;
        this.isOnCooldown = true;
        if (entityPlayer instanceof EntityPlayerMP) {
            WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(entityPlayer)), (EntityPlayerMP)entityPlayer);
        }
        if (this.projectile != null) {
            if (this.attr.isRepeater()) {
                this.startRepeater(entityPlayer);
            } else {
                entityPlayer.field_70170_p.func_72838_d((Entity)this.projectile);
            }
        }
        this.sendShounenScream(entityPlayer, 2);
        if (this.attr.getAbilityExplosionPower() > 0) {
            entityPlayer.field_70170_p.func_72885_a((Entity)entityPlayer, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, (float)this.attr.getAbilityExplosionPower(), this.attr.canAbilityExplosionSetFire(), MainConfig.enableGriefing ? this.attr.canAbilityExplosionDestroyBlocks() : false);
        }
        if (!WyHelper.isDevBuild() && !entityPlayer.field_71075_bZ.field_75098_d) {
            WyTelemetry.addAbilityStat(this.getAttribute().getAbilityTexture(), this.getAttribute().getAttributeName(), 1);
        }
        new Ability$Update(this, entityPlayer, this.attr).start();
    }

    public boolean isCharging() {
        return this.isCharging;
    }

    public boolean isOnCooldown() {
        return this.isOnCooldown;
    }

    public void duringCooldown(EntityPlayer entityPlayer, int n) {
    }

    public void hitEntity(EntityPlayer entityPlayer, EntityLivingBase entityLivingBase) {
        if (this.attr.getPotionEffectsForHit() != null) {
            for (PotionEffect potionEffect : this.attr.getPotionEffectsForHit()) {
                entityLivingBase.func_70690_d(new PotionEffect(potionEffect.func_76456_a(), potionEffect.func_76459_b(), potionEffect.func_76458_c(), true));
            }
        }
        if (this.attr.getAbilityExplosionPower() > 0) {
            entityPlayer.field_70170_p.func_72885_a((Entity)entityLivingBase, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v, (float)this.attr.getAbilityExplosionPower(), this.attr.canAbilityExplosionSetFire(), MainConfig.enableGriefing ? this.attr.canAbilityExplosionDestroyBlocks() : false);
        }
        this.passiveActive = false;
        this.startCooldown();
        WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(entityPlayer)), (EntityPlayerMP)entityPlayer);
        entityLivingBase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)entityPlayer), this.attr.getPunchDamage() * ExtendedEntityData.get((EntityLivingBase)entityPlayer).getDamageMultiplier());
        new Ability$Update(this, entityPlayer, this.attr).start();
    }

    protected void startCooldown() {
        this.isOnCooldown = true;
    }

    protected void startExtUpdate(EntityPlayer entityPlayer) {
        WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(entityPlayer)), (EntityPlayerMP)entityPlayer);
        new Ability$Update(this, entityPlayer, this.attr).start();
    }

    public void startUpdate(EntityPlayer entityPlayer) {
        this.setCooldownActive(true);
        if (entityPlayer instanceof EntityPlayerMP) {
            WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(entityPlayer)), (EntityPlayerMP)entityPlayer);
        }
        new Ability$Update(this, entityPlayer, this.attr).start();
    }

    protected void sendShounenScream(EntityPlayer entityPlayer) {
        this.sendShounenScream(entityPlayer, 0);
    }

    protected void sendShounenScream(EntityPlayer entityPlayer, int n) {
        if (MainConfig.enableAnimeScreaming) {
            WyNetworkHelper.sendToAllAround(new PacketShounenScream(entityPlayer.func_70005_c_(), this.attr.getAbilityDisplayName(), n), entityPlayer.field_71093_bK, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, 15.0);
        }
    }

    public void reset() {
        this.isOnCooldown = false;
        this.isCharging = false;
        this.isRepeating = false;
        this.passiveActive = false;
    }

    static /* synthetic */ int access$002(Ability ability, int n) {
        ability.ticksForCooldown = n;
        return ability.ticksForCooldown;
    }

    static /* synthetic */ int access$102(Ability ability, int n) {
        ability.ticksForCharge = n;
        return ability.ticksForCharge;
    }

    static /* synthetic */ int access$000(Ability ability) {
        return ability.ticksForCooldown;
    }

    static /* synthetic */ int access$010(Ability ability) {
        return ability.ticksForCooldown--;
    }

    static /* synthetic */ int access$210(Ability ability) {
        return ability.ticksForRepeater--;
    }

    static /* synthetic */ int access$200(Ability ability) {
        return ability.ticksForRepeater;
    }

    static /* synthetic */ int access$202(Ability ability, int n) {
        ability.ticksForRepeater = n;
        return ability.ticksForRepeater;
    }

    static /* synthetic */ int access$302(Ability ability, int n) {
        ability.currentSpawn = n;
        return ability.currentSpawn;
    }

    static /* synthetic */ int access$100(Ability ability) {
        return ability.ticksForCharge;
    }

    static /* synthetic */ int access$110(Ability ability) {
        return ability.ticksForCharge--;
    }
}

