/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api.abilities;

import java.awt.Color;
import net.minecraft.client.model.ModelBase;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.EffectType;

public class AbilityAttribute {
    private String attributeName;
    private String abilityDisplayName = "n/a";
    private String abilityTexture = "n/a";
    private boolean abilityExplosionHasFire = true;
    private boolean abilityExplosionCanBreakBlocks = true;
    private boolean abilityIsChargeable;
    private boolean abilityIsRepeater;
    private boolean abilityIsPassive;
    private boolean abilityIsPunch;
    private boolean abilityIsFreePassive;
    private boolean abilityStopCharging;
    private int abilityCooldown;
    private int abilityMaxCharge;
    private int abilityRepeaterTime = 6;
    private int abilityRepeaterFreq = 1;
    private int abilityExplosionPower;
    private float abilityPunchDamage = 1.0f;
    private boolean projectileMoveThroughBlocks;
    private boolean projectileExplosionHasFire = true;
    private boolean projectileExplosionCanBreakBlocks = true;
    private boolean projectileIsPhysical = false;
    private int projectileTicks = 60;
    private int projectileExplosionPower;
    private float projectileAlpha = 255.0f;
    private float projectileDamage = 1.0f;
    private float projectileSpeed = 1.5f;
    private double projectileXRotation;
    private double projectileYRotation;
    private double projectileZRotation;
    private Color projectileColor = Color.decode("#FFFFFF");
    private double[] projectileScale = new double[]{1.0, 1.0, 1.0};
    private double[] projectileCollisionSize = new double[]{0.25, 0.25, 0.25};
    private double[] projectileModelOffset = new double[]{0.0, 0.0, 0.0};
    private ResourceLocation projectileTexture;
    private ModelBase projectileModel;
    private int potionEffectAoeRadius;
    private PotionEffect[] potionEffectsForProjectile;
    private PotionEffect[] potionEffectsForUser;
    private PotionEffect[] potionEffectsForAoE;
    private PotionEffect[] potionEffectsForHit;

    public AbilityAttribute() {
    }

    public AbilityAttribute(String string) {
        this.abilityDisplayName = this.attributeName = string;
        this.abilityTexture = WyHelper.getFancyName(this.attributeName);
    }

    public AbilityAttribute(AbilityAttribute abilityAttribute) {
        this.attributeName = abilityAttribute.attributeName;
        this.abilityIsChargeable = abilityAttribute.abilityIsChargeable;
        this.abilityIsRepeater = abilityAttribute.abilityIsRepeater;
        this.abilityIsPassive = abilityAttribute.abilityIsPassive;
        this.abilityIsPunch = abilityAttribute.abilityIsPunch;
        this.abilityStopCharging = abilityAttribute.abilityStopCharging;
        this.abilityIsFreePassive = abilityAttribute.abilityIsFreePassive;
        this.abilityCooldown = abilityAttribute.abilityCooldown;
        this.projectileTicks = abilityAttribute.projectileTicks;
        this.projectileSpeed = abilityAttribute.projectileSpeed;
        this.abilityExplosionPower = abilityAttribute.abilityExplosionPower;
        this.projectileExplosionPower = abilityAttribute.projectileExplosionPower;
        this.potionEffectAoeRadius = abilityAttribute.potionEffectAoeRadius;
        this.abilityMaxCharge = abilityAttribute.abilityMaxCharge;
        this.abilityRepeaterTime = abilityAttribute.abilityRepeaterTime;
        this.abilityRepeaterFreq = abilityAttribute.abilityRepeaterFreq;
        this.projectileMoveThroughBlocks = abilityAttribute.projectileMoveThroughBlocks;
        this.projectileExplosionHasFire = abilityAttribute.projectileExplosionHasFire;
        this.projectileExplosionCanBreakBlocks = abilityAttribute.projectileExplosionCanBreakBlocks;
        this.abilityExplosionHasFire = abilityAttribute.abilityExplosionHasFire;
        this.abilityExplosionCanBreakBlocks = abilityAttribute.abilityExplosionCanBreakBlocks;
        this.projectileIsPhysical = abilityAttribute.projectileIsPhysical;
        this.projectileAlpha = abilityAttribute.projectileAlpha;
        this.projectileDamage = abilityAttribute.projectileDamage;
        this.projectileXRotation = abilityAttribute.projectileXRotation;
        this.projectileYRotation = abilityAttribute.projectileYRotation;
        this.projectileZRotation = abilityAttribute.projectileZRotation;
        this.abilityPunchDamage = abilityAttribute.abilityPunchDamage;
        this.projectileColor = abilityAttribute.projectileColor;
        this.projectileScale = abilityAttribute.projectileScale;
        this.projectileCollisionSize = abilityAttribute.projectileCollisionSize;
        this.projectileModelOffset = abilityAttribute.projectileModelOffset;
        this.projectileModel = abilityAttribute.projectileModel;
        this.potionEffectsForProjectile = abilityAttribute.potionEffectsForProjectile;
        this.potionEffectsForUser = abilityAttribute.potionEffectsForUser;
        this.potionEffectsForAoE = abilityAttribute.potionEffectsForAoE;
        this.potionEffectsForHit = abilityAttribute.potionEffectsForHit;
        this.projectileTexture = abilityAttribute.projectileTexture;
        this.abilityTexture = abilityAttribute.abilityTexture;
        this.abilityDisplayName = abilityAttribute.abilityDisplayName;
    }

    public AbilityAttribute setAttributeName(String string) {
        this.attributeName = string;
        return this;
    }

    public AbilityAttribute setAbilityCooldown(double d) {
        this.abilityCooldown = MathHelper.func_76143_f((double)(d * 20.0));
        return this;
    }

    public AbilityAttribute setAbilityCharges(int n) {
        this.abilityIsChargeable = true;
        this.abilityMaxCharge = n;
        return this;
    }

    public AbilityAttribute setAbilityCharges(int n, boolean bl) {
        this.abilityIsChargeable = true;
        this.abilityMaxCharge = n;
        this.abilityStopCharging = bl;
        return this;
    }

    public AbilityAttribute setAbilityExplosion(int n, boolean bl, boolean bl2) {
        this.abilityExplosionPower = n;
        this.abilityExplosionHasFire = bl;
        this.abilityExplosionCanBreakBlocks = bl2;
        return this;
    }

    public AbilityAttribute setAbilityExplosion(int n, boolean bl) {
        this.abilityExplosionPower = n;
        this.abilityExplosionHasFire = bl;
        return this;
    }

    public AbilityAttribute setAbilityExplosion(int n) {
        this.abilityExplosionPower = n;
        return this;
    }

    public AbilityAttribute setAbilityPassive() {
        this.abilityIsPassive = true;
        return this;
    }

    public AbilityAttribute setAbilityPassive(boolean bl) {
        this.abilityIsPassive = true;
        this.abilityIsFreePassive = bl;
        return this;
    }

    public AbilityAttribute setAbilityPunch() {
        this.abilityIsPassive = true;
        this.abilityIsPunch = true;
        return this;
    }

    public AbilityAttribute setAbilityPunch(float f) {
        this.abilityIsPassive = true;
        this.abilityIsPunch = true;
        this.abilityPunchDamage = f;
        return this;
    }

    public AbilityAttribute setAbilityRepeater() {
        this.abilityIsRepeater = true;
        this.abilityRepeaterTime = 6;
        this.abilityRepeaterFreq = 1;
        return this;
    }

    public AbilityAttribute setAbilityRepeater(int n) {
        this.abilityIsRepeater = true;
        this.abilityRepeaterTime = n;
        this.abilityRepeaterFreq = 1;
        return this;
    }

    public AbilityAttribute setAbilityRepeater(int n, int n2) {
        this.abilityIsRepeater = true;
        this.abilityRepeaterTime = n;
        this.abilityRepeaterFreq = n2;
        return this;
    }

    public AbilityAttribute setAbilityTexture(String string) {
        this.abilityTexture = string;
        return this;
    }

    public AbilityAttribute setAbilityDisplayName(String string) {
        this.abilityDisplayName = string;
        return this;
    }

    public AbilityAttribute setProjectileTicks(int n) {
        this.projectileTicks = n;
        return this;
    }

    public AbilityAttribute setProjectileDamage(float f) {
        this.projectileDamage = f;
        return this;
    }

    public AbilityAttribute setProjectileModel(ModelBase modelBase) {
        this.projectileModel = modelBase;
        return this;
    }

    public AbilityAttribute setProjectileColor(Color color) {
        this.projectileColor = color;
        return this;
    }

    public AbilityAttribute setProjectileColor(int n) {
        this.projectileColor = new Color(n);
        return this;
    }

    public AbilityAttribute setProjectileColor(String string) {
        this.projectileColor = string.contains("#") ? Color.decode(string) : Color.decode("#" + string);
        return this;
    }

    public AbilityAttribute setProjectileAlpha(float f) {
        this.projectileAlpha = f;
        return this;
    }

    public AbilityAttribute setProjectileSize(double d, double d2, double d3) {
        this.projectileScale = new double[]{d, d2, d3};
        return this;
    }

    public AbilityAttribute setProjectileSize(double[] dArray) {
        this.projectileScale = dArray;
        return this;
    }

    public AbilityAttribute setProjectileExplosion(int n, boolean bl, boolean bl2) {
        this.projectileExplosionPower = n;
        this.projectileExplosionHasFire = bl;
        this.projectileExplosionCanBreakBlocks = bl2;
        return this;
    }

    public AbilityAttribute setProjectileExplosion(int n, boolean bl) {
        this.projectileExplosionPower = n;
        this.projectileExplosionHasFire = bl;
        return this;
    }

    public AbilityAttribute setProjectileExplosion(int n) {
        this.projectileExplosionPower = n;
        return this;
    }

    public AbilityAttribute setProjectileSpeed(float f) {
        this.projectileSpeed = f;
        return this;
    }

    public AbilityAttribute setProjectileTexture(String string) {
        this.projectileTexture = new ResourceLocation("mineminenomi:textures/models/projectiles/" + string + ".png");
        return this;
    }

    public AbilityAttribute setProjectileXRotation(double d) {
        this.projectileXRotation = d;
        return this;
    }

    public AbilityAttribute setProjectileYRotation(double d) {
        this.projectileYRotation = d;
        return this;
    }

    public AbilityAttribute setProjectileZRotation(double d) {
        this.projectileZRotation = d;
        return this;
    }

    public AbilityAttribute setProjectileMoveThroughBlocks(boolean bl) {
        this.projectileMoveThroughBlocks = bl;
        return this;
    }

    public AbilityAttribute setProjectileCollisionSizes(double d) {
        this.projectileCollisionSize = new double[]{d, d, d};
        return this;
    }

    public AbilityAttribute setProjectileCollisionSizes(double d, double d2, double d3) {
        this.projectileCollisionSize = new double[]{d, d2, d3};
        return this;
    }

    public AbilityAttribute setModelOffsets(double d, double d2, double d3) {
        this.projectileModelOffset = new double[]{d, d2, d3};
        return this;
    }

    public AbilityAttribute setProjectilePhysical() {
        this.projectileIsPhysical = true;
        return this;
    }

    public AbilityAttribute addEffects(EffectType effectType, PotionEffect ... potionEffectArray) {
        if (effectType == EffectType.PROJECTILE) {
            this.potionEffectsForProjectile = potionEffectArray;
        }
        if (effectType == EffectType.USER) {
            this.potionEffectsForUser = potionEffectArray;
        }
        if (effectType == EffectType.AOE) {
            this.potionEffectsForAoE = potionEffectArray;
        }
        if (effectType == EffectType.HIT) {
            this.potionEffectsForHit = potionEffectArray;
        }
        return this;
    }

    public AbilityAttribute setEffectRadius(int n) {
        this.potionEffectAoeRadius = n;
        return this;
    }

    public int getAbilityCooldown() {
        return this.abilityCooldown;
    }

    public boolean isRepeater() {
        return this.abilityIsRepeater;
    }

    public boolean canStopChargeEarly() {
        return this.abilityStopCharging;
    }

    public boolean canAbilityBeCharged() {
        return this.abilityIsChargeable;
    }

    public int getAbilityExplosionPower() {
        return this.abilityExplosionPower;
    }

    public int getAbilityCharges() {
        return this.abilityMaxCharge;
    }

    public boolean canAbilityExplosionSetFire() {
        return this.abilityExplosionHasFire;
    }

    public boolean canAbilityExplosionDestroyBlocks() {
        return this.abilityExplosionCanBreakBlocks;
    }

    public boolean isPassive() {
        return this.abilityIsPassive;
    }

    public int getAbilityRepeaterTime() {
        return this.abilityRepeaterTime;
    }

    public int getAbilityRepeaterFrequency() {
        return this.abilityRepeaterFreq;
    }

    public boolean isPunch() {
        return this.abilityIsPunch;
    }

    public float getPunchDamage() {
        return this.abilityPunchDamage;
    }

    public String getAbilityTexture() {
        return this.abilityTexture;
    }

    public String getAbilityDisplayName() {
        return this.abilityDisplayName;
    }

    public boolean isAbilityFreePassive() {
        return this.abilityIsFreePassive;
    }

    public boolean hasProjectile() {
        return this.projectileTicks > 0 && this.projectileModel != null;
    }

    public int getProjectileTicks() {
        return this.projectileTicks;
    }

    public float getProjectileDamage() {
        return this.projectileDamage;
    }

    public Color getProjectileColor() {
        return this.projectileColor;
    }

    public ModelBase getProjectileModel() {
        return this.projectileModel;
    }

    public double[] getProjectileSize() {
        return this.projectileScale;
    }

    public float getProjectileSpeed() {
        return this.projectileSpeed;
    }

    public int getProjectileExplosionPower() {
        return this.projectileExplosionPower;
    }

    public boolean canProjectileExplosionSetFire() {
        return this.projectileExplosionHasFire;
    }

    public boolean canProjectileExplosionDestroyBlocks() {
        return this.projectileExplosionCanBreakBlocks;
    }

    public float getProjectileAlpha() {
        return this.projectileAlpha;
    }

    public ResourceLocation getProjectileTexture() {
        return this.projectileTexture;
    }

    public double getProjectileXRotation() {
        return this.projectileXRotation;
    }

    public double getProjectileYRotation() {
        return this.projectileYRotation;
    }

    public double getProjectileZRotation() {
        return this.projectileZRotation;
    }

    public boolean canProjectileMoveThroughBlocks() {
        return this.projectileMoveThroughBlocks;
    }

    public double[] getProjectileCollisionSizes() {
        return this.projectileCollisionSize;
    }

    public double[] getModelOffsets() {
        return this.projectileModelOffset;
    }

    public boolean isProjectilePhysical() {
        return this.projectileIsPhysical;
    }

    public PotionEffect[] getPotionEffectsForHit() {
        return this.potionEffectsForHit;
    }

    public PotionEffect[] getPotionEffectsForProjectile() {
        return this.potionEffectsForProjectile;
    }

    public PotionEffect[] getPotionEffectsForUser() {
        return this.potionEffectsForUser;
    }

    public PotionEffect[] getPotionEffectsForAoE() {
        return this.potionEffectsForAoE;
    }

    public int getEffectRadius() {
        return this.potionEffectAoeRadius;
    }

    public String getAttributeName() {
        return this.attributeName;
    }
}

