/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api.quests;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.network.PacketQuestSync;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.api.quests.QuestProperties;

public abstract class Quest {
    protected NBTTagCompound extraData;
    protected double questProgress;

    public abstract String getQuestID();

    public abstract String getQuestName();

    public abstract String[] getQuestDescription();

    public void startQuest(EntityPlayer entityPlayer) {
        WyHelper.sendMsgToPlayer(entityPlayer, EnumChatFormatting.GREEN + I18n.func_135052_a((String)("quest." + this.getQuestID() + ".name"), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"gui.quests.started", (Object[])new Object[0]));
    }

    public abstract boolean isPrimary();

    public abstract boolean isRepeatable();

    public void finishQuest(EntityPlayer entityPlayer) {
        QuestProperties questProperties = QuestProperties.get(entityPlayer);
        questProperties.removeQuestFromTracker(this);
        questProperties.addCompletedQuest(this);
        WyNetworkHelper.sendTo(new PacketQuestSync(questProperties), (EntityPlayerMP)entityPlayer);
        WyHelper.sendMsgToPlayer(entityPlayer, EnumChatFormatting.GREEN + I18n.func_135052_a((String)("quest." + this.getQuestID() + ".name"), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"gui.quests.completed", (Object[])new Object[0]));
    }

    public abstract boolean canStart(EntityPlayer var1);

    public boolean isFinished(EntityPlayer entityPlayer) {
        return this.questProgress >= this.getMaxProgress();
    }

    public double getProgress() {
        return this.questProgress;
    }

    public double getMaxProgress() {
        return 1.0;
    }

    public void setProgress(EntityPlayer entityPlayer, double d) {
        this.questProgress = d <= this.getMaxProgress() ? d : this.getMaxProgress();
    }

    public void alterProgress(EntityPlayer entityPlayer, double d) {
        this.questProgress = this.questProgress + d <= this.getMaxProgress() ? (this.questProgress += d) : this.getMaxProgress();
    }
}

