/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api.quests;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.quests.Quest;
import xyz.pixelatedw.MineMineNoMi3.api.quests.QuestManager;
import xyz.pixelatedw.MineMineNoMi3.lists.ListQuests;

public class QuestProperties
implements IExtendedEntityProperties {
    public static final String EXT_QUESTPROP_NAME = "mineminenomi_QuestIEEP";
    private final EntityPlayer thePlayer;
    private boolean hasPrimaryActive = false;
    private Quest[] questsList = new Quest[4];
    private Quest[] completedQuests = new Quest[2048];

    public QuestProperties(EntityPlayer entityPlayer) {
        this.thePlayer = entityPlayer;
    }

    public static final void register(EntityPlayer entityPlayer) {
        entityPlayer.registerExtendedProperties(EXT_QUESTPROP_NAME, (IExtendedEntityProperties)new QuestProperties(entityPlayer));
    }

    public static final QuestProperties get(EntityPlayer entityPlayer) {
        return (QuestProperties)entityPlayer.getExtendedProperties(EXT_QUESTPROP_NAME);
    }

    public void saveNBTData(NBTTagCompound nBTTagCompound) {
        int n;
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        nBTTagCompound2.func_74757_a("hasPrimaryActive", this.hasPrimaryActive);
        for (n = 0; n < this.questsList.length; ++n) {
            if (this.questsList[n] == null) continue;
            nBTTagCompound2.func_74778_a("inProgressQuest_" + n, this.questsList[n].getQuestID());
            nBTTagCompound2.func_74780_a("progressForQuest_" + n, this.questsList[n].getProgress());
            if (this.questsList[n].extraData == null) continue;
            nBTTagCompound2.func_74782_a("extraData_" + n, (NBTBase)this.questsList[n].extraData);
        }
        for (n = 0; n < this.completedQuests.length; ++n) {
            if (this.completedQuests[n] == null) continue;
            nBTTagCompound2.func_74778_a("completedQuest_" + n, this.completedQuests[n].getQuestID());
        }
        nBTTagCompound.func_74782_a(EXT_QUESTPROP_NAME, (NBTBase)nBTTagCompound2);
    }

    public void loadNBTData(NBTTagCompound nBTTagCompound) {
        int n;
        NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagCompound.func_74781_a(EXT_QUESTPROP_NAME);
        this.hasPrimaryActive = nBTTagCompound2.func_74767_n("hasPrimaryActive");
        try {
            for (n = 0; n < this.questsList.length; ++n) {
                Quest quest = this.questsList[n] = !nBTTagCompound2.func_74779_i("inProgressQuest_" + n).isEmpty() || QuestManager.instance().getQuestByNameFromList(ListQuests.allQuests, nBTTagCompound2.func_74779_i("inProgressQuest_" + n)) != null ? (Quest)QuestManager.instance().getQuestByNameFromList(ListQuests.allQuests, nBTTagCompound2.func_74779_i("inProgressQuest_" + n)).getClass().newInstance() : null;
                if (this.questsList[n] == null) continue;
                this.questsList[n].setProgress(this.thePlayer, nBTTagCompound2.func_74769_h("progressForQuest_" + n));
                this.questsList[n].extraData = (NBTTagCompound)nBTTagCompound2.func_74781_a("extraData_" + n);
            }
        }
        catch (Exception exception) {
            Logger.getGlobal().log(Level.SEVERE, "Quest is not registered correctly or could not be found in the master list !");
            exception.printStackTrace();
        }
        for (n = 0; n < this.completedQuests.length; ++n) {
            this.completedQuests[n] = !nBTTagCompound2.func_74779_i("completedQuest_" + n).isEmpty() || QuestManager.instance().getQuestByNameFromList(ListQuests.allQuests, nBTTagCompound2.func_74779_i("completedQuest_" + n)) != null ? QuestManager.instance().getQuestByNameFromList(ListQuests.allQuests, nBTTagCompound2.func_74779_i("completedQuest_" + n)) : null;
        }
    }

    public void init(Entity entity, World world) {
    }

    public boolean addQuestInTracker(Quest quest) {
        if (quest.isPrimary() && !this.hasPrimaryActive || !quest.isPrimary()) {
            for (int i = 0; i < this.questsList.length; ++i) {
                if (this.questsList[i] != null || this.hasQuestInTracker(quest)) continue;
                if (quest.isPrimary()) {
                    this.hasPrimaryActive = true;
                }
                this.questsList[i] = quest;
                return true;
            }
        }
        return false;
    }

    public boolean addCompletedQuest(Quest quest) {
        for (int i = 0; i < this.completedQuests.length; ++i) {
            if (this.completedQuests[i] != null || this.hasQuestCompleted(quest)) continue;
            this.completedQuests[i] = quest;
            return true;
        }
        return false;
    }

    public void removeQuestFromTracker(Quest quest) {
        for (int i = 0; i < this.questsList.length; ++i) {
            if (this.questsList[i] == null || !this.questsList[i].getQuestID().toLowerCase().equals(quest.getQuestID().toLowerCase())) continue;
            if (quest.isPrimary()) {
                this.hasPrimaryActive = false;
            }
            this.questsList[i] = null;
            break;
        }
    }

    public boolean hasQuestInTracker(Quest quest) {
        for (int i = 0; i < this.questsList.length; ++i) {
            if (this.questsList[i] == null || !this.questsList[i].getQuestID().toLowerCase().equals(quest.getQuestID().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public boolean hasQuestCompleted(Quest quest) {
        for (int i = 0; i < this.completedQuests.length; ++i) {
            if (this.completedQuests[i] == null || !this.completedQuests[i].getQuestID().toLowerCase().equals(quest.getQuestID().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public Quest getQuestFromTracker(Quest quest) {
        for (int i = 0; i < this.questsList.length; ++i) {
            if (this.questsList[i] == null || !this.questsList[i].getQuestID().toLowerCase().equals(quest.getQuestID().toLowerCase())) continue;
            return this.questsList[i];
        }
        return null;
    }

    public Quest getQuestIndexFromTracker(int n) {
        if (this.questsList[n] != null) {
            return this.questsList[n];
        }
        return null;
    }

    public Quest getPrimaryQuestFromTracker() {
        if (this.hasPrimaryActive) {
            for (int i = 0; i < this.questsList.length; ++i) {
                if (this.questsList[i] == null || !this.questsList[i].isPrimary()) continue;
                return this.questsList[i];
            }
        }
        return null;
    }

    public void alterQuestProgress(Quest quest, double d) {
        for (int i = 0; i < this.questsList.length; ++i) {
            if (this.questsList[i] == null || !this.questsList[i].getQuestID().toLowerCase().equals(quest.getQuestID().toLowerCase())) continue;
            this.questsList[i].alterProgress(this.thePlayer, d);
            break;
        }
    }

    public boolean hasPrimary() {
        return this.hasPrimaryActive;
    }

    public int questsInProgress() {
        int n = 0;
        for (int i = 0; i < this.questsList.length; ++i) {
            if (this.questsList[i] == null) continue;
            ++n;
        }
        return n;
    }

    public void clearQuestTracker() {
        for (int i = 0; i < this.questsList.length; ++i) {
            if (this.questsList[i] == null) continue;
            if (this.questsList[i].isPrimary()) {
                this.hasPrimaryActive = false;
            }
            this.questsList[i] = null;
        }
    }

    public void clearCompletedQuests() {
        for (int i = 0; i < this.completedQuests.length; ++i) {
            if (this.completedQuests[i] == null) continue;
            this.completedQuests[i] = null;
        }
    }
}

