/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.events;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.abilities.CyborgAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.FishKarateAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.RokushikiAbilities;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.api.telemetry.WyTelemetry;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.EntityNewMob;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.marines.MarineData;
import xyz.pixelatedw.MineMineNoMi3.events.customevents.BountyEvent;
import xyz.pixelatedw.MineMineNoMi3.events.customevents.DorikiEvent;
import xyz.pixelatedw.MineMineNoMi3.helpers.DevilFruitsHelper;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSync;

public class EventsOnGain {
    @SubscribeEvent
    public void onDorikiGained(DorikiEvent dorikiEvent) {
        if (dorikiEvent.props.isHuman()) {
            this.gainAbility(dorikiEvent.player, 500, RokushikiAbilities.SORU, false);
            this.gainAbility(dorikiEvent.player, 1500, RokushikiAbilities.TEKKAI, false);
            this.gainAbility(dorikiEvent.player, 3000, RokushikiAbilities.SHIGAN, false);
            this.gainAbility(dorikiEvent.player, 4500, RokushikiAbilities.GEPPO, false);
            this.gainAbility(dorikiEvent.player, 6000, RokushikiAbilities.KAMIE, false);
            this.gainAbility(dorikiEvent.player, 8500, RokushikiAbilities.RANKYAKU, false);
        } else if (dorikiEvent.props.isFishman()) {
            this.gainAbility(dorikiEvent.player, 800, FishKarateAbilities.UCHIMIZU, false);
            this.gainAbility(dorikiEvent.player, 2000, FishKarateAbilities.MURASAME, false);
            this.gainAbility(dorikiEvent.player, 2500, FishKarateAbilities.KACHIAGE_HAISOKU, false);
            this.gainAbility(dorikiEvent.player, 3000, FishKarateAbilities.SAMEHADA_SHOTEI, false);
            this.gainAbility(dorikiEvent.player, 7500, FishKarateAbilities.KARAKUSAGAWARA_SEIKEN, false);
        } else if (dorikiEvent.props.isCyborg()) {
            this.gainAbility(dorikiEvent.player, 0, CyborgAbilities.FRESH_FIRE, false);
            this.gainAbility(dorikiEvent.player, 0, CyborgAbilities.COLA_OVERDRIVE, false);
            this.gainAbility(dorikiEvent.player, 0, CyborgAbilities.STRONG_RIGHT, false);
            this.gainAbility(dorikiEvent.player, 0, CyborgAbilities.RADICAL_BEAM, false);
            this.gainAbility(dorikiEvent.player, 0, CyborgAbilities.COUP_DE_VENT, false);
        }
        if (dorikiEvent.player != null && MainConfig.enableExtraHearts) {
            IAttributeInstance iAttributeInstance = dorikiEvent.player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            if (dorikiEvent.props.getDoriki() / 100 <= 20) {
                dorikiEvent.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
            } else {
                dorikiEvent.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(dorikiEvent.props.getDoriki() / 100));
            }
        }
    }

    private void gainAbility(EntityPlayer entityPlayer, int n, Ability ability, boolean bl) {
        ExtendedEntityData extendedEntityData = ExtendedEntityData.get((EntityLivingBase)entityPlayer);
        AbilityProperties abilityProperties = AbilityProperties.get(entityPlayer);
        if (bl) {
            if (extendedEntityData.getDoriki() >= n && !abilityProperties.hasHakiAbility(ability) && !DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) {
                abilityProperties.addHakiAbility(ability);
            }
            if ((extendedEntityData.getDoriki() < n || DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) && abilityProperties.hasHakiAbility(ability)) {
                abilityProperties.removeHakiAbility(ability);
            }
        } else {
            if (extendedEntityData.getDoriki() >= n && !abilityProperties.hasRacialAbility(ability) && !DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) {
                abilityProperties.addRacialAbility(ability);
            }
            if ((extendedEntityData.getDoriki() < n || DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) && abilityProperties.hasRacialAbility(ability)) {
                abilityProperties.removeRacialAbility(ability);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent livingDeathEvent) {
        AbilityProperties abilityProperties;
        ExtendedEntityData extendedEntityData;
        EntityPlayer entityPlayer;
        if (livingDeathEvent.entity instanceof EntityPlayer) {
            entityPlayer = (EntityPlayer)livingDeathEvent.entity;
            extendedEntityData = ExtendedEntityData.get((EntityLivingBase)entityPlayer);
            abilityProperties = AbilityProperties.get(entityPlayer);
            for (int i = 0; i < 8; ++i) {
                if (abilityProperties.getAbilityFromSlot(i) == null) continue;
                abilityProperties.getAbilityFromSlot(i).reset();
            }
            WyNetworkHelper.sendTo(new PacketSync(extendedEntityData), (EntityPlayerMP)entityPlayer);
        }
        if (livingDeathEvent.source.func_76346_g() instanceof EntityPlayer) {
            entityPlayer = (EntityPlayer)livingDeathEvent.source.func_76346_g();
            extendedEntityData = ExtendedEntityData.get((EntityLivingBase)entityPlayer);
            abilityProperties = livingDeathEvent.entityLiving;
            IAttributeInstance iAttributeInstance = abilityProperties.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e);
            IAttributeInstance iAttributeInstance2 = abilityProperties.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
            int n = entityPlayer.field_70170_p.field_73012_v.nextInt(3) + 1;
            int n2 = 0;
            long l = 0L;
            double d = 0.0;
            boolean bl = false;
            if (abilityProperties instanceof EntityPlayer) {
                ExtendedEntityData extendedEntityData2 = ExtendedEntityData.get((EntityLivingBase)abilityProperties);
                d = extendedEntityData2.getDoriki() / 4 + n;
                l = extendedEntityData2.getBounty() / 2L + (long)n;
                n2 = extendedEntityData2.getBelly();
                bl = true;
            } else {
                if (extendedEntityData.isMarine() && abilityProperties instanceof MarineData) {
                    return;
                }
                if (abilityProperties instanceof EntityNewMob) {
                    EntityNewMob entityNewMob = (EntityNewMob)((Object)abilityProperties);
                    if (extendedEntityData.getDoriki() / 100 > entityNewMob.getDoriki()) {
                        if (MainConfig.enableMinimumDorikiPerKill) {
                            d = 1.0;
                        }
                    } else {
                        d = entityNewMob.getDoriki();
                    }
                    d *= MainConfig.modifierDorikiReward;
                    l = entityNewMob.getDoriki() * 2 + n;
                    n2 = entityNewMob.getBelly() + n;
                    if (!entityPlayer.field_70170_p.field_72995_K && !entityPlayer.field_71075_bZ.field_75098_d) {
                        WyTelemetry.addKillStat(WyHelper.getFancyName(abilityProperties.getClass().getSimpleName()).replace("entity", ""), abilityProperties.getClass().getSimpleName().replace("Entity", ""), 1);
                    }
                } else if (iAttributeInstance != null && iAttributeInstance2 != null) {
                    double d2 = iAttributeInstance.func_111126_e();
                    double d3 = iAttributeInstance2.func_111126_e();
                    d = (int)Math.round((d2 + d3) / 10.0 / Math.PI) + n;
                    l = (int)Math.round((d2 + d3) / 10.0) + n;
                    n2 = 1;
                    d *= MainConfig.modifierDorikiReward;
                } else {
                    d = 0.0;
                    l = 0L;
                    n2 = 1;
                }
                if (d > 0.0 && (double)extendedEntityData.getDoriki() + d <= 10000.0) {
                    extendedEntityData.alterDoriki((int)Math.round(d));
                    DorikiEvent dorikiEvent = new DorikiEvent(entityPlayer);
                    if (MinecraftForge.EVENT_BUS.post((Event)dorikiEvent)) {
                        return;
                    }
                }
                if ((extendedEntityData.isPirate() || extendedEntityData.isRevolutionary()) && l > 0L && extendedEntityData.getBounty() + l < 999999999L) {
                    extendedEntityData.alterBounty(l);
                    BountyEvent bountyEvent = new BountyEvent(entityPlayer, l);
                    if (MinecraftForge.EVENT_BUS.post((Event)bountyEvent)) {
                        return;
                    }
                }
                if (extendedEntityData.getBelly() + n2 < 999999999) {
                    extendedEntityData.alterBelly(n2);
                }
            }
            WyNetworkHelper.sendTo(new PacketSync(extendedEntityData), (EntityPlayerMP)entityPlayer);
        }
    }
}

