/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.helpers;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.abilities.CyborgAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.DoctorAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.FishKarateAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.HakiAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.RokushikiAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.SniperAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.SwordsmanAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.WeatherAbilities;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.api.quests.QuestProperties;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedWorldData;
import xyz.pixelatedw.MineMineNoMi3.events.customevents.DorikiEvent;
import xyz.pixelatedw.MineMineNoMi3.helpers.ItemsHelper;
import xyz.pixelatedw.MineMineNoMi3.items.AkumaNoMi;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;
import xyz.pixelatedw.MineMineNoMi3.lists.ListQuests;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketShounenScream;

public class DevilFruitsHelper {
    private static String[][] zoanModels = new String[][]{{"ushiushibison", "bison"}, {"toritoriphoenix", "phoenix"}, {"ushiushigiraffe", "giraffe"}};
    public static String[] flyingFruits = new String[]{"gasugasu", "sunasuna", "mokumoku"};
    private static HashMap blockRules = DevilFruitsHelper.createBlockRulesMap();

    private static HashMap createBlockRulesMap() {
        HashMap<String, List<Block>> hashMap = new HashMap<String, List<Block>>();
        hashMap.put("core", Arrays.asList(Blocks.field_150432_aD, Blocks.field_150403_cj, Blocks.field_150348_b, Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150354_m, Blocks.field_150322_A, Blocks.field_150372_bz, Blocks.field_150466_ao, Blocks.field_150376_bx, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150404_cg, Blocks.field_150414_aQ, ListMisc.Poison, ListMisc.DemonPoison, Blocks.field_150478_aa, Blocks.field_150429_aA, Blocks.field_150488_af, Blocks.field_150347_e, Blocks.field_150422_aJ, Blocks.field_150458_ak, Blocks.field_150396_be, Blocks.field_150457_bL, Blocks.field_150435_aG, Blocks.field_150351_n, ListMisc.SunaSand, ListMisc.WaxBlock));
        hashMap.put("air", Arrays.asList(Blocks.field_150350_a));
        hashMap.put("foliage", Arrays.asList(Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150392_bi, Blocks.field_150398_cm, Blocks.field_150327_N, Blocks.field_150328_O, Blocks.field_150395_bd, Blocks.field_150338_P, Blocks.field_150420_aW, Blocks.field_150337_Q, Blocks.field_150419_aX, Blocks.field_150329_H, Blocks.field_150469_bN, Blocks.field_150459_bM, Blocks.field_150434_aF, Blocks.field_150330_I));
        hashMap.put("ores", Arrays.asList(Blocks.field_150365_q, Blocks.field_150402_ci, Blocks.field_150482_ag, Blocks.field_150484_ah, Blocks.field_150366_p, Blocks.field_150339_S, Blocks.field_150369_x, Blocks.field_150368_y, Blocks.field_150450_ax, Blocks.field_150451_bX, Blocks.field_150352_o, Blocks.field_150340_R, ListMisc.KairosekiOre, ListMisc.KairosekiBlock));
        hashMap.put("liquids", Arrays.asList(Blocks.field_150355_j, Blocks.field_150358_i, Blocks.field_150353_l, Blocks.field_150356_k));
        return hashMap;
    }

    public static int getParticleSettingModifier(int n) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return 0;
        }
        int n2 = Math.abs(Minecraft.func_71410_x().field_71474_y.field_74362_aa - 2);
        switch (n2) {
            case 2: {
                return n;
            }
            case 1: {
                return n / 2;
            }
            case 0: {
                return 0;
            }
        }
        return n;
    }

    public static void sendShounenScream(EntityPlayer entityPlayer, String string, int n) {
        if (MainConfig.enableAnimeScreaming) {
            WyNetworkHelper.sendToAllAround(new PacketShounenScream(entityPlayer.func_70005_c_(), string, n), entityPlayer.field_71093_bK, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, 15.0);
        }
    }

    public static boolean canUseSwordsmanAbilities(EntityPlayer entityPlayer) {
        ExtendedEntityData extendedEntityData = ExtendedEntityData.get((EntityLivingBase)entityPlayer);
        Ability ability = AbilityProperties.get(entityPlayer).getAbilityFromName(ListAttributes.SPAR_CLAW.getAttributeName());
        return extendedEntityData.getUsedFruit().equalsIgnoreCase("supasupa") && ability != null && ability.isPassiveActive();
    }

    public static boolean checkForRestriction(EntityPlayer entityPlayer) {
        ExtendedWorldData extendedWorldData = ExtendedWorldData.get(entityPlayer.field_70170_p);
        if (extendedWorldData.isInsideRestrictedArea((int)entityPlayer.field_70165_t, (int)entityPlayer.field_70163_u, (int)entityPlayer.field_70161_v)) {
            WyHelper.sendMsgToPlayer(entityPlayer, "Cannot use abilites in a restricted area !");
            return true;
        }
        return false;
    }

    public static boolean isDevilFruitInWorld(World world, String string) {
        ExtendedWorldData extendedWorldData = ExtendedWorldData.get(world);
        return extendedWorldData.isDevilFruitInWorld(string);
    }

    public static boolean isDevilFruitInWorld(World world, AkumaNoMi akumaNoMi) {
        String string;
        if (akumaNoMi == null) {
            return true;
        }
        ExtendedWorldData extendedWorldData = ExtendedWorldData.get(world);
        return extendedWorldData.isDevilFruitInWorld(string = akumaNoMi.func_77658_a().substring(5).replace("nomi", "").replace(":", "").replace(",", "").replace("model", ""));
    }

    public static boolean isAffectedByWater(EntityLivingBase entityLivingBase) {
        Block block = entityLivingBase.field_70170_p.func_147439_a((int)entityLivingBase.field_70165_t, (int)entityLivingBase.field_70163_u - 1, (int)entityLivingBase.field_70161_v);
        Block block2 = entityLivingBase.field_70170_p.func_147439_a((int)entityLivingBase.field_70165_t, (int)entityLivingBase.field_70163_u - 2, (int)entityLivingBase.field_70161_v);
        return entityLivingBase.func_70055_a(Material.field_151586_h) || entityLivingBase.func_70026_G() && !entityLivingBase.func_70115_ae() && (block == Blocks.field_150355_j || block == Blocks.field_150358_i) && (block2 == Blocks.field_150355_j || block2 == Blocks.field_150358_i);
    }

    public static boolean isNearbyKairoseki(EntityPlayer entityPlayer) {
        return WyHelper.isBlockNearby((EntityLivingBase)entityPlayer, 4, ListMisc.KairosekiBlock, ListMisc.KairosekiOre, ListMisc.KairosekiBars) || ItemsHelper.hasKairosekiItem(entityPlayer) || entityPlayer.field_71071_by.func_146028_b(Item.func_150898_a((Block)ListMisc.KairosekiBlock)) || entityPlayer.field_71071_by.func_146028_b(Item.func_150898_a((Block)ListMisc.KairosekiOre)) || entityPlayer.field_71071_by.func_146028_b(Item.func_150898_a((Block)ListMisc.KairosekiBars)) || DevilFruitsHelper.isAffectedByWater((EntityLivingBase)entityPlayer);
    }

    public static void verifyAndGiveAbility(Ability ability, AbilityProperties abilityProperties) {
        if (!DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) {
            abilityProperties.addRacialAbility(ability);
        }
    }

    public static boolean verifyIfAbilityIsBanned(Ability ability) {
        for (String string : MainConfig.abilityRestrictions) {
            if (!WyHelper.getFancyName(string).contains(WyHelper.getFancyName(ability.getAttribute().getAttributeName()))) continue;
            return true;
        }
        return false;
    }

    public static void validateRacialMoves(EntityPlayer entityPlayer) {
        ExtendedEntityData extendedEntityData = ExtendedEntityData.get((EntityLivingBase)entityPlayer);
        AbilityProperties abilityProperties = AbilityProperties.get(entityPlayer);
        DorikiEvent dorikiEvent = new DorikiEvent(entityPlayer);
        if (MinecraftForge.EVENT_BUS.post((Event)dorikiEvent)) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (extendedEntityData.isHuman()) {
            for (Ability ability : RokushikiAbilities.abilitiesArray) {
                if (!abilityProperties.hasRacialAbility(ability) || DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) continue;
                arrayList.add(ability);
            }
        }
        if (extendedEntityData.isFishman()) {
            for (Ability ability : FishKarateAbilities.abilitiesArray) {
                if (!abilityProperties.hasRacialAbility(ability) || DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) continue;
                arrayList.add(ability);
            }
        }
        if (extendedEntityData.isCyborg()) {
            for (Ability ability : CyborgAbilities.abilitiesArray) {
                if (!abilityProperties.hasRacialAbility(ability) || DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) continue;
                arrayList.add(ability);
            }
        }
        abilityProperties.clearRacialAbilities();
        for (Ability ability : arrayList) {
            abilityProperties.addRacialAbility(ability);
        }
        arrayList.clear();
        for (Ability ability : HakiAbilities.abilitiesArray) {
            if (!abilityProperties.hasHakiAbility(ability) || DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) continue;
            arrayList.add(ability);
        }
        abilityProperties.clearHakiAbilities();
        for (Ability ability : arrayList) {
            abilityProperties.addHakiAbility(ability);
        }
    }

    public static void validateStyleMoves(EntityPlayer entityPlayer) {
        ExtendedEntityData extendedEntityData = ExtendedEntityData.get((EntityLivingBase)entityPlayer);
        QuestProperties questProperties = QuestProperties.get(entityPlayer);
        AbilityProperties abilityProperties = AbilityProperties.get(entityPlayer);
        if (extendedEntityData.isSwordsman()) {
            DevilFruitsHelper.verifyAndGiveAbility(SwordsmanAbilities.SHI_SHISHI_SONSON, abilityProperties);
            if (MainConfig.enableQuestProgression) {
                if (questProperties.hasQuestCompleted(ListQuests.swordsmanProgression04) && !DevilFruitsHelper.verifyIfAbilityIsBanned(SwordsmanAbilities.SANBYAKUROKUJU_POUND_HO)) {
                    abilityProperties.addRacialAbility(SwordsmanAbilities.SANBYAKUROKUJU_POUND_HO);
                }
            } else {
                DevilFruitsHelper.verifyAndGiveAbility(SwordsmanAbilities.SANBYAKUROKUJU_POUND_HO, abilityProperties);
                DevilFruitsHelper.verifyAndGiveAbility(SwordsmanAbilities.YAKKODORI, abilityProperties);
                DevilFruitsHelper.verifyAndGiveAbility(SwordsmanAbilities.OTATSUMAKI, abilityProperties);
            }
        } else if (extendedEntityData.isSniper()) {
            DevilFruitsHelper.verifyAndGiveAbility(SniperAbilities.KAEN_BOSHI, abilityProperties);
            if (!MainConfig.enableQuestProgression) {
                DevilFruitsHelper.verifyAndGiveAbility(SniperAbilities.KEMURI_BOSHI, abilityProperties);
                DevilFruitsHelper.verifyAndGiveAbility(SniperAbilities.RENPATSU_NAMARI_BOSHI, abilityProperties);
                DevilFruitsHelper.verifyAndGiveAbility(SniperAbilities.SAKURETSU_SABOTEN_BOSHI, abilityProperties);
            }
        } else if (extendedEntityData.isMedic()) {
            DevilFruitsHelper.verifyAndGiveAbility(DoctorAbilities.FIRST_AID, abilityProperties);
            DevilFruitsHelper.verifyAndGiveAbility(DoctorAbilities.MEDIC_BAG_EXPLOSION, abilityProperties);
            DevilFruitsHelper.verifyAndGiveAbility(DoctorAbilities.FAILED_EXPERIMENT, abilityProperties);
        } else if (extendedEntityData.isWeatherWizard()) {
            DevilFruitsHelper.verifyAndGiveAbility(WeatherAbilities.HEAT_BALL, abilityProperties);
            DevilFruitsHelper.verifyAndGiveAbility(WeatherAbilities.COOL_BALL, abilityProperties);
            DevilFruitsHelper.verifyAndGiveAbility(WeatherAbilities.THUNDER_BALL, abilityProperties);
            if (!MainConfig.enableQuestProgression) {
                DevilFruitsHelper.verifyAndGiveAbility(WeatherAbilities.GUST_SWORD, abilityProperties);
                DevilFruitsHelper.verifyAndGiveAbility(WeatherAbilities.WEATHER_EGG, abilityProperties);
            }
        }
    }

    public static boolean isSniperAbility(Ability ability) {
        for (Ability ability2 : SniperAbilities.abilitiesArray) {
            if (!ability.getAttribute().getAttributeName().equalsIgnoreCase(ability2.getAttribute().getAttributeName())) continue;
            return true;
        }
        return false;
    }

    public static boolean placeBlockIfAllowed(World world, int n, int n2, int n3, Block block, int n4, String ... stringArray) {
        return DevilFruitsHelper.placeBlockIfAllowed(world, n, n2, n3, block, 0, n4, stringArray);
    }

    public static boolean placeBlockIfAllowed(World world, int n, int n2, int n3, Block block, String ... stringArray) {
        return DevilFruitsHelper.placeBlockIfAllowed(world, n, n2, n3, block, 0, 3, stringArray);
    }

    public static boolean placeBlockIfAllowed(World world, int n, int n2, int n3, Block block, int n4, int n5, String ... stringArray) {
        Block block2 = world.func_147439_a(n, n2, n3);
        ArrayList arrayList = new ArrayList();
        boolean bl = Arrays.toString(stringArray).contains("nogrief");
        ExtendedWorldData extendedWorldData = ExtendedWorldData.get(world);
        if (extendedWorldData.isInsideRestrictedArea(n, n2, n3)) {
            return false;
        }
        Arrays.stream(stringArray).forEach(string -> {
            String string2;
            if (string.split(" ").length > 1) {
                string2 = string.split(" ")[0];
                string = string.split(" ")[1];
            } else {
                string2 = "add";
            }
            if (blockRules.containsKey(string)) {
                if (string2.equalsIgnoreCase("add")) {
                    arrayList.addAll((Collection)blockRules.get(string));
                } else if (string2.equalsIgnoreCase("ignore")) {
                    arrayList.removeAll((Collection)blockRules.get(string));
                }
            }
            if (string.equalsIgnoreCase("all")) {
                if (string2.equalsIgnoreCase("add")) {
                    Block.field_149771_c.forEach(object -> arrayList.add((Block)object));
                } else if (string2.equalsIgnoreCase("ignore")) {
                    Block.field_149771_c.forEach(object -> arrayList.remove(object));
                }
            } else if (string.equalsIgnoreCase("restricted")) {
                arrayList.remove(Blocks.field_150357_h);
                arrayList.remove(ListMisc.Ope);
                arrayList.remove(ListMisc.OpeMid);
                arrayList.remove(ListMisc.StringMid);
                arrayList.remove(ListMisc.StringWall);
                arrayList.remove(ListMisc.Darkness);
            }
        });
        if (MainConfig.enableGriefing || bl) {
            for (Block block3 : arrayList) {
                if (block2 != block3) continue;
                world.func_147465_d(n, n2, n3, block, n4, n5);
                return true;
            }
        }
        return false;
    }

    public static ItemStack getDevilFruitItem(String string) {
        String string2 = "";
        String string3 = "";
        for (String[] stringArray : zoanModels) {
            if (!string.equals(stringArray[0])) continue;
            string2 = stringArray[1];
            string3 = "model" + string2;
            break;
        }
        if (string.equals("yamidummy")) {
            string = "yamiyami";
        }
        return new ItemStack(GameRegistry.findItem((String)"mineminenomi", (String)(string.replace(string2, "") + "nomi" + string3)));
    }

    public static boolean isEntityInRoom(EntityLivingBase entityLivingBase) {
        for (int i = -20; i < 20; ++i) {
            for (int j = -20; j < 20; ++j) {
                for (int k = -20; k < 20; ++k) {
                    if (entityLivingBase.field_70170_p.func_147439_a((int)entityLivingBase.field_70165_t + i, (int)entityLivingBase.field_70163_u + j, (int)entityLivingBase.field_70161_v + k) != ListMisc.OpeMid) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getRegenFromPoision(EntityLivingBase entityLivingBase) {
        return entityLivingBase.func_70660_b(Potion.field_76436_u).func_76458_c() / 5;
    }
}

